/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.lock.redis.algorithm;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.lock.redis.algorithm.HussarRedisLockAlgorithm;
import com.jxdinfo.hussar.support.lock.redis.config.HussarRedisLockProperties;
import com.jxdinfo.hussar.support.lock.redis.constant.HussarRedisLockConstants;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.Duration;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.UncheckedException;
import org.apache.commons.lang3.exception.UncheckedIllegalAccessException;
import org.apache.commons.lang3.exception.UncheckedInterruptedException;
import org.redisson.api.RPermitExpirableSemaphore;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HussarRedissonMutexAlgorithm
implements HussarRedisLockAlgorithm<State> {
    private static final Logger logger = LoggerFactory.getLogger(HussarRedissonMutexAlgorithm.class);
    private static final long SHORT_WAIT_TIME_MILLIS = 2L;
    private final RedissonClient redisson;
    private final HussarRedisLockProperties properties;
    private volatile boolean tryAcquireMethodInitialized = false;
    private volatile Class<?> tryAcquireClass = null;
    private volatile Method tryAcquireMethod = null;

    public HussarRedissonMutexAlgorithm(RedissonClient redisson, HussarRedisLockProperties properties) {
        this.redisson = redisson;
        this.properties = properties;
    }

    @Override
    public String getAlgorithmName() {
        return "REDISSON_MUTEX";
    }

    @Override
    public State acquire(String key, Duration timeout) {
        return this.acquire(key, timeout, null);
    }

    @Override
    public State acquire(String key, Duration waitTimeout, Duration expireTimeout) {
        String permit;
        RPermitExpirableSemaphore semaphore = this.getSemaphore(key);
        Duration lockExpire = this.getLockExpire();
        if (HussarUtils.isNotEmpty((Object)expireTimeout)) {
            lockExpire = expireTimeout;
        }
        try {
            permit = semaphore.tryAcquire(waitTimeout.toMillis(), lockExpire.toMillis(), TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException ex) {
            throw new UncheckedInterruptedException((Throwable)ex);
        }
        if (permit == null) {
            return null;
        }
        return new State(semaphore, permit);
    }

    @Override
    public State tryAcquire(String key) {
        String permit;
        RPermitExpirableSemaphore semaphore = this.getSemaphore(key);
        if (this.getTryAcquireMethodFor(semaphore) != null) {
            permit = this.doTryAcquireNoWait(semaphore, 1, this.getLockExpire().toMillis(), TimeUnit.MILLISECONDS);
        } else if (this.properties.isUseRedissonSemaphoreFallback()) {
            logger.warn("Failed to access method 'tryAcquire(int permits, long leaseTime, TimeUnit unit)', fallback to use a short waitTime={}", (Object)2L);
            try {
                permit = semaphore.tryAcquire(2L, this.getLockExpire().toMillis(), TimeUnit.MILLISECONDS);
            }
            catch (InterruptedException ex) {
                throw new UncheckedInterruptedException((Throwable)ex);
            }
        } else {
            throw new UnsupportedOperationException("Redisson semaphore do not supported: tryAcquire(int permits, long leaseTime, TimeUnit timeUnit)");
        }
        return permit != null ? new State(semaphore, permit) : null;
    }

    @Override
    public boolean release(String key, State state) {
        RPermitExpirableSemaphore semaphore = state.getSemaphore();
        return semaphore.tryRelease(state.getPermit());
    }

    private RPermitExpirableSemaphore getSemaphore(String key) {
        String scopedKey = "semaphore:" + key;
        RPermitExpirableSemaphore semaphore = this.redisson.getPermitExpirableSemaphore(scopedKey);
        semaphore.trySetPermits(1);
        return semaphore;
    }

    private Duration getLockExpire() {
        Duration lockExpire = this.properties.getLockExpire();
        if (lockExpire == null || lockExpire.compareTo(Duration.ZERO) <= 0) {
            lockExpire = HussarRedisLockConstants.DEFAULT_LOCK_EXPIRE;
        }
        return lockExpire;
    }

    private String doTryAcquireNoWait(RPermitExpirableSemaphore semaphore, int permits, long leaseTime, TimeUnit unit) {
        Method method = this.getTryAcquireMethodFor(semaphore);
        if (method == null) {
            throw new IllegalStateException("Method not found: tryAcquire(int permits, long leaseTime, TimeUnit timeUnit)");
        }
        try {
            Object result = method.invoke((Object)semaphore, new Object[]{permits, leaseTime, unit});
            if (result instanceof List) {
                Object element;
                List list = (List)result;
                Object v0 = element = !list.isEmpty() ? list.get(0) : null;
                if (element == null) {
                    return null;
                }
                if (element instanceof String) {
                    String id = element;
                    return id.startsWith(":") ? null : id;
                }
            }
            throw new IllegalStateException("Method '" + method + "' should return List<String>");
        }
        catch (IllegalAccessException ex) {
            throw new UncheckedIllegalAccessException((Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            throw new UncheckedException(ex.getTargetException());
        }
    }

    private Method getTryAcquireMethodFor(RPermitExpirableSemaphore semaphore) {
        if (!this.tryAcquireMethodInitialized) {
            try {
                this.tryAcquireClass = Class.forName("org.redisson.RedissonPermitExpirableSemaphore");
                this.tryAcquireMethod = this.tryAcquireClass.getDeclaredMethod("tryAcquire", Integer.TYPE, Long.TYPE, TimeUnit.class);
                this.tryAcquireMethod.setAccessible(true);
            }
            catch (ClassNotFoundException | LinkageError | NoSuchMethodException | SecurityException ignore) {
                this.tryAcquireClass = null;
                this.tryAcquireMethod = null;
            }
            finally {
                this.tryAcquireMethodInitialized = true;
            }
        }
        if (this.tryAcquireClass != null && this.tryAcquireMethod != null && this.tryAcquireClass.isInstance(semaphore)) {
            return this.tryAcquireMethod;
        }
        return null;
    }

    public static class State {
        private final RPermitExpirableSemaphore semaphore;
        private final String permit;

        public State(RPermitExpirableSemaphore semaphore, String permit) {
            this.semaphore = semaphore;
            this.permit = permit;
        }

        public RPermitExpirableSemaphore getSemaphore() {
            return this.semaphore;
        }

        public String getPermit() {
            return this.permit;
        }

        public String toString() {
            return "State{semaphore=" + this.semaphore + ", permit='" + this.permit + '\'' + '}';
        }
    }
}

