/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.lock.redis.algorithm;

import com.jxdinfo.hussar.support.lock.redis.algorithm.HussarRedisLockAlgorithm;
import com.jxdinfo.hussar.support.lock.redis.config.HussarRedisLockProperties;
import com.jxdinfo.hussar.support.lock.redis.constant.HussarRedisLockConstants;
import java.time.Duration;
import java.time.Instant;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.exception.UncheckedInterruptedException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.util.Assert;

public class HussarRedisSetNxMutexAlgorithm
implements HussarRedisLockAlgorithm<Long> {
    private final RedisTemplate<Object, Object> redisTemplate;
    private final HussarRedisLockProperties properties;

    public HussarRedisSetNxMutexAlgorithm(RedisTemplate<Object, Object> redisTemplate, HussarRedisLockProperties properties) {
        this.redisTemplate = redisTemplate;
        this.properties = properties;
    }

    @Override
    public String getAlgorithmName() {
        return "SET_NX_MUTEX";
    }

    @Override
    public Long acquire(String key, Duration timeout) {
        return this.acquire(key, timeout, null);
    }

    @Override
    public Long acquire(String key, Duration waitTimeout, Duration expireTimeout) {
        Instant start = Instant.now();
        byte[] rawKey = this.getRawKey(key);
        return (Long)this.redisTemplate.execute(connection -> {
            Long expire = this.tryAcquireLock(connection, rawKey);
            if (expire != null) {
                return expire;
            }
            Duration checkInterval = this.properties.getCheckInterval();
            if (checkInterval == null || checkInterval.compareTo(Duration.ZERO) <= 0) {
                checkInterval = HussarRedisLockConstants.DEFAULT_CHECK_INTERVAL;
            }
            if (!waitTimeout.isNegative() && waitTimeout.compareTo(checkInterval) <= 0) {
                checkInterval = waitTimeout;
            }
            while (Duration.between(start, Instant.now()).compareTo(waitTimeout) <= 0) {
                if (this.isLockExpired(connection, rawKey) && (expire = this.retryAcquireLock(connection, rawKey)) != null) {
                    return expire;
                }
                try {
                    Thread.sleep(checkInterval.toMillis());
                }
                catch (InterruptedException ex) {
                    throw new UncheckedInterruptedException((Throwable)ex);
                }
            }
            return null;
        }, true);
    }

    @Override
    public Long tryAcquire(String key) {
        byte[] rawKey = this.getRawKey(key);
        return (Long)this.redisTemplate.execute(connection -> {
            Long expire = this.tryAcquireLock(connection, rawKey);
            if (expire != null) {
                return expire;
            }
            if (!this.isLockExpired(connection, rawKey)) {
                return null;
            }
            return this.retryAcquireLock(connection, rawKey);
        }, true);
    }

    @Override
    public boolean release(String key, Long state) {
        if (state == null) {
            throw new IllegalStateException("algorithm state must not be null");
        }
        long expire = state;
        byte[] rawKey = this.getRawKey(key);
        return Boolean.TRUE.equals(this.redisTemplate.execute(connection -> {
            long timestamp = this.getCurrentTimestamp(connection);
            if (timestamp < expire) {
                Long count = connection.del((byte[][])new byte[][]{rawKey});
                return count != null && count > 0L;
            }
            return false;
        }, true));
    }

    private Long tryAcquireLock(RedisConnection connection, byte[] rawKey) {
        long timestamp = this.getCurrentTimestamp(connection);
        long expire = this.calculateExpire(timestamp);
        byte[] rawExpire = this.getRawExpireValue(expire);
        Boolean ok = connection.setNX(rawKey, rawExpire);
        return Boolean.TRUE.equals(ok) ? Long.valueOf(expire) : null;
    }

    private boolean isLockExpired(RedisConnection connection, byte[] rawKey) {
        Long expire = this.getExpireValue(connection.get(rawKey));
        if (expire == null) {
            return true;
        }
        long timestamp = this.getCurrentTimestamp(connection);
        return timestamp > expire;
    }

    private Long retryAcquireLock(RedisConnection connection, byte[] rawKey) {
        long timestamp = this.getCurrentTimestamp(connection);
        long nextExpire = this.calculateExpire(timestamp);
        byte[] rawNextExpire = this.getRawExpireValue(nextExpire);
        Long previousExpire = this.getExpireValue(connection.getSet(rawKey, rawNextExpire));
        return previousExpire == null || timestamp > previousExpire ? Long.valueOf(nextExpire) : null;
    }

    private long getCurrentTimestamp(RedisConnection connection) {
        if (this.properties.isLocalTimestamp()) {
            return System.currentTimeMillis();
        }
        Long timestamp = connection.time(TimeUnit.MILLISECONDS);
        Assert.notNull((Object)timestamp, (String)"cannot get redis server timestamp");
        return timestamp;
    }

    private long calculateExpire(long timestamp) {
        Duration lockExpire = this.properties.getLockExpire();
        if (lockExpire == null || lockExpire.compareTo(Duration.ZERO) <= 0) {
            lockExpire = HussarRedisLockConstants.DEFAULT_LOCK_EXPIRE;
        }
        return Instant.ofEpochMilli(timestamp).plus(lockExpire).plus(Duration.ofMillis(1L)).toEpochMilli();
    }

    private byte[] getRawKey(String key) {
        String actualKey = "hussar_lock:set_nx:" + key;
        return RedisSerializer.string().serialize((Object)actualKey);
    }

    private byte[] getRawExpireValue(long expire) {
        RedisSerializer valueSerializer = this.redisTemplate.getValueSerializer();
        return valueSerializer.serialize((Object)expire);
    }

    private Long getExpireValue(byte[] rawExpireValue) {
        if (rawExpireValue == null) {
            return null;
        }
        RedisSerializer valueSerializer = this.redisTemplate.getValueSerializer();
        Object expireValue = valueSerializer.deserialize(rawExpireValue);
        return expireValue instanceof Number ? Long.valueOf(((Number)expireValue).longValue()) : null;
    }
}

