/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.lock.redis.algorithm;

import com.jxdinfo.hussar.support.lock.redis.algorithm.HussarRedisLockAlgorithm;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HussarEmptyRedisLockAlgorithm
implements HussarRedisLockAlgorithm<Boolean> {
    private static final Logger logger = LoggerFactory.getLogger(HussarEmptyRedisLockAlgorithm.class);

    @Override
    public String getAlgorithmName() {
        return "EMPTY";
    }

    @Override
    public Boolean acquire(String key, Duration timeout) {
        logger.warn("No-op: acquire lock (key={}, timeout={})", (Object)key, (Object)timeout);
        return Boolean.TRUE;
    }

    @Override
    public Boolean acquire(String key, Duration waitTimeout, Duration expireTimeout) {
        logger.warn("No-op: acquire lock (key={}, waitTimeout={}, expireTimeout={})", new Object[]{key, waitTimeout, expireTimeout});
        return Boolean.TRUE;
    }

    @Override
    public Boolean tryAcquire(String key) {
        logger.warn("No-op: try to acquire lock (key={})", (Object)key);
        return Boolean.TRUE;
    }

    @Override
    public boolean release(String key, Boolean state) {
        logger.warn("No-op: release lock (key={})", (Object)key);
        return true;
    }
}

