/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.lock.redis;

import com.jxdinfo.hussar.support.lock.HussarLockGuard;
import com.jxdinfo.hussar.support.lock.HussarLockType;
import com.jxdinfo.hussar.support.lock.common.HussarAbstractLockManager;
import com.jxdinfo.hussar.support.lock.common.HussarLockExecutionCounter;
import com.jxdinfo.hussar.support.lock.redis.HussarRedisLockExecutionCounter;
import com.jxdinfo.hussar.support.lock.redis.HussarRedisLockGuard;
import com.jxdinfo.hussar.support.lock.redis.algorithm.HussarEmptyRedisLockAlgorithm;
import com.jxdinfo.hussar.support.lock.redis.algorithm.HussarRedisLockAlgorithm;
import com.jxdinfo.hussar.support.lock.redis.algorithm.HussarRedisSetNxMutexAlgorithm;
import com.jxdinfo.hussar.support.lock.redis.algorithm.HussarRedissonMutexAlgorithm;
import com.jxdinfo.hussar.support.lock.redis.algorithm.HussarRedissonReentrantLockAlgorithm;
import com.jxdinfo.hussar.support.lock.redis.config.HussarRedisLockProperties;
import com.jxdinfo.hussar.support.lock.redis.constant.HussarLockRedisType;
import java.time.Duration;
import org.redisson.api.RedissonClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;

public class HussarRedisLockManager
extends HussarAbstractLockManager {
    private static final Logger logger = LoggerFactory.getLogger(HussarRedisLockManager.class);
    private final HussarLockRedisType redisType;
    private final RedisTemplate<Object, Object> redisTemplate;
    private final RedissonClient redisson;
    private final HussarRedisLockProperties properties;
    private volatile HussarEmptyRedisLockAlgorithm emptyAlgorithm;
    private volatile HussarRedisSetNxMutexAlgorithm redisSetNxMutexAlgorithm;
    private volatile HussarRedissonMutexAlgorithm redissonMutexAlgorithm;
    private volatile HussarRedissonReentrantLockAlgorithm redissonReentrantLockAlgorithm;

    public HussarRedisLockManager(HussarLockRedisType redisType, RedisTemplate<Object, Object> redisTemplate, RedissonClient redisson, HussarRedisLockProperties properties) {
        super((HussarLockExecutionCounter)new HussarRedisLockExecutionCounter(redisType, redisTemplate));
        this.redisType = redisType;
        this.redisTemplate = redisTemplate;
        this.redisson = redisson;
        this.properties = properties;
    }

    protected HussarLockGuard doAcquire(HussarLockType type, String key, Duration timeout) {
        logger.trace("Acquiring lock (type={}, key={}, timeout={})", new Object[]{type, key, timeout});
        HussarRedisLockAlgorithm<?> algorithm = this.getAlgorithm(type);
        return HussarRedisLockGuard.acquire(algorithm, type, key, timeout);
    }

    protected HussarLockGuard doAcquire(HussarLockType type, String key, Duration waitTimeout, Duration expireTimeout) {
        logger.trace("Acquiring lock (type={}, key={}, waitTimeout={}, expireTimeout={})", new Object[]{type, key, waitTimeout, expireTimeout});
        HussarRedisLockAlgorithm<?> algorithm = this.getAlgorithm(type);
        return HussarRedisLockGuard.acquire(algorithm, type, key, waitTimeout, expireTimeout);
    }

    protected HussarLockGuard doTryAcquire(HussarLockType type, String key) {
        logger.trace("Trying to acquire lock (type={}, key={})", (Object)type, (Object)key);
        HussarRedisLockAlgorithm<?> algorithm = this.getAlgorithm(type);
        return HussarRedisLockGuard.tryAcquire(algorithm, type, key);
    }

    protected HussarRedisLockAlgorithm<?> getAlgorithm(HussarLockType type) {
        logger.trace("Get lock algorithm for (lock-type={}, redis-type={})", (Object)type, (Object)this.redisType);
        if (type == HussarLockType.SIMPLE_MUTEX) {
            if (this.redisType == HussarLockRedisType.SINGLE || this.redisType == HussarLockRedisType.SENTINEL) {
                return this.getRedisSetNxMutexAlgorithm();
            }
            return this.getRedissonMutexAlgorithm();
        }
        if (type == HussarLockType.REENTRANT_LOCK) {
            return this.getRedissonReentrantLockAlgorithm();
        }
        logger.trace("Failed to acquire or try to acquire lock (type={}): unsupported lock type for redis", (Object)type);
        throw new UnsupportedOperationException("unsupported lock type for redis: " + type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HussarEmptyRedisLockAlgorithm getEmptyAlgorithm() {
        if (this.emptyAlgorithm == null) {
            HussarRedisLockManager hussarRedisLockManager = this;
            synchronized (hussarRedisLockManager) {
                if (this.emptyAlgorithm == null) {
                    this.emptyAlgorithm = new HussarEmptyRedisLockAlgorithm();
                }
            }
        }
        return this.emptyAlgorithm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HussarRedisSetNxMutexAlgorithm getRedisSetNxMutexAlgorithm() {
        if (this.redisSetNxMutexAlgorithm == null) {
            HussarRedisLockManager hussarRedisLockManager = this;
            synchronized (hussarRedisLockManager) {
                if (this.redisSetNxMutexAlgorithm == null) {
                    this.redisSetNxMutexAlgorithm = new HussarRedisSetNxMutexAlgorithm(this.redisTemplate, this.properties);
                }
            }
        }
        return this.redisSetNxMutexAlgorithm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HussarRedissonMutexAlgorithm getRedissonMutexAlgorithm() {
        if (this.redissonMutexAlgorithm == null) {
            HussarRedisLockManager hussarRedisLockManager = this;
            synchronized (hussarRedisLockManager) {
                if (this.redissonMutexAlgorithm == null) {
                    this.redissonMutexAlgorithm = new HussarRedissonMutexAlgorithm(this.redisson, this.properties);
                }
            }
        }
        return this.redissonMutexAlgorithm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HussarRedissonReentrantLockAlgorithm getRedissonReentrantLockAlgorithm() {
        if (this.redissonReentrantLockAlgorithm == null) {
            HussarRedisLockManager hussarRedisLockManager = this;
            synchronized (hussarRedisLockManager) {
                if (this.redissonReentrantLockAlgorithm == null) {
                    this.redissonReentrantLockAlgorithm = new HussarRedissonReentrantLockAlgorithm(this.redisson, this.properties);
                }
            }
        }
        return this.redissonReentrantLockAlgorithm;
    }
}

