/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.lock.redis;

import com.jxdinfo.hussar.support.lock.HussarAbstractLockGuard;
import com.jxdinfo.hussar.support.lock.HussarLockType;
import com.jxdinfo.hussar.support.lock.redis.algorithm.HussarRedisLockAlgorithm;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class HussarRedisLockGuard<S>
extends HussarAbstractLockGuard {
    private static final Logger logger = LoggerFactory.getLogger(HussarRedisLockGuard.class);
    private final HussarRedisLockAlgorithm<S> algorithm;
    private final S state;

    HussarRedisLockGuard(HussarRedisLockAlgorithm<S> algorithm, HussarLockType type, String key, S state) {
        super(type, key);
        this.algorithm = algorithm;
        this.state = state;
    }

    static <S> HussarRedisLockGuard<S> acquire(HussarRedisLockAlgorithm<S> algorithm, HussarLockType type, String key, Duration timeout) {
        S state = algorithm.acquire(key, timeout);
        if (state == null) {
            logger.trace("Acquired no lock (type={}, key={}, timeout={})", new Object[]{type, key, timeout});
            return null;
        }
        HussarRedisLockGuard<S> guard = new HussarRedisLockGuard<S>(algorithm, type, key, state);
        logger.trace("Acquired a lock (type={}, key={}, timeout={}): {}", new Object[]{type, key, timeout, guard});
        return guard;
    }

    static <S> HussarRedisLockGuard<S> tryAcquire(HussarRedisLockAlgorithm<S> algorithm, HussarLockType type, String key) {
        S state = algorithm.tryAcquire(key);
        if (state == null) {
            logger.trace("Acquired no lock (type={}, key={})", (Object)type, (Object)key);
            return null;
        }
        HussarRedisLockGuard<S> guard = new HussarRedisLockGuard<S>(algorithm, type, key, state);
        logger.trace("Acquired a lock (type={}, key={}): {}", new Object[]{type, key, guard});
        return guard;
    }

    protected void doReleaseLock() {
        logger.trace("Releasing lock (type={}, key={})", (Object)this.type, (Object)this.key);
        boolean released = this.algorithm.release(this.getKey(), this.state);
        if (!released) {
            logger.warn("unable to release lock: {}", (Object)this);
        } else {
            logger.trace("Released lock (type={}, key={})", (Object)this.type, (Object)this.key);
        }
    }

    protected void toStringExtra(StringBuilder builder) {
        builder.append(", algorithm=").append(this.algorithm.getAlgorithmName());
        builder.append(", state=").append(this.state);
    }
}

