/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.loader.tools;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.boot.loader.tools.Layout;
import org.springframework.boot.loader.tools.LibraryScope;
import org.springframework.boot.loader.tools.RepackagingLayout;

public final class Layouts {
    private Layouts() {
    }

    public static Layout forFile(File file) {
        if (file == null) {
            throw new IllegalArgumentException("File must not be null");
        }
        String lowerCaseFileName = file.getName().toLowerCase(Locale.ENGLISH);
        if (lowerCaseFileName.endsWith(".jar")) {
            return new Jar();
        }
        if (lowerCaseFileName.endsWith(".war")) {
            return new War();
        }
        if (file.isDirectory() || lowerCaseFileName.endsWith(".zip")) {
            return new Expanded();
        }
        throw new IllegalStateException("Unable to deduce layout for '" + file + "'");
    }

    public static class War
    implements Layout {
        private static final Map<LibraryScope, String> SCOPE_LOCATION;

        public String getLauncherClassName() {
            return "org.springframework.boot.loader.WarLauncher";
        }

        public String getLibraryLocation(String libraryName, LibraryScope scope) {
            return SCOPE_LOCATION.get(scope);
        }

        public String getClassesLocation() {
            return "WEB-INF/classes/";
        }

        public String getClasspathIndexFileLocation() {
            return "WEB-INF/classpath.idx";
        }

        public String getLayersIndexFileLocation() {
            return "WEB-INF/layers.idx";
        }

        public boolean isExecutable() {
            return true;
        }

        static {
            HashMap<LibraryScope, String> locations = new HashMap<LibraryScope, String>();
            locations.put(LibraryScope.COMPILE, "WEB-INF/lib/");
            locations.put(LibraryScope.CUSTOM, "WEB-INF/lib/");
            locations.put(LibraryScope.RUNTIME, "WEB-INF/lib/");
            locations.put(LibraryScope.PROVIDED, "WEB-INF/lib-provided/");
            SCOPE_LOCATION = Collections.unmodifiableMap(locations);
        }
    }

    public static class None
    extends Jar {
        @Override
        public String getLauncherClassName() {
            return null;
        }

        @Override
        public boolean isExecutable() {
            return false;
        }
    }

    public static class Expanded
    extends Jar {
        @Override
        public String getLauncherClassName() {
            return "org.springframework.boot.loader.PropertiesLauncher";
        }
    }

    public static class Jar
    implements RepackagingLayout {
        public String getLauncherClassName() {
            return "org.springframework.boot.loader.JarLauncher";
        }

        public String getLibraryLocation(String libraryName, LibraryScope scope) {
            return "BOOT-INF/lib/";
        }

        public String getClassesLocation() {
            return "";
        }

        public String getRepackagedClassesLocation() {
            return "BOOT-INF/classes/";
        }

        public String getClasspathIndexFileLocation() {
            return "BOOT-INF/classpath.idx";
        }

        public String getLayersIndexFileLocation() {
            return "BOOT-INF/layers.idx";
        }

        public boolean isExecutable() {
            return true;
        }
    }

    public static class PluginLayout
    implements RepackagingLayout {
        public String getLauncherClassName() {
            return null;
        }

        public String getLibraryLocation(String libraryName, LibraryScope scope) {
            return "lib/";
        }

        public String getClassesLocation() {
            return null;
        }

        public boolean isExecutable() {
            return false;
        }

        public String getRepackagedClassesLocation() {
            return "";
        }
    }
}

