/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.hotloaded.framework.plugin.packager;

import com.jxdinfo.hussar.support.hotloaded.framework.plugin.packager.AbstractDependencyFilterMojo;
import com.jxdinfo.hussar.support.hotloaded.framework.plugin.packager.artifacts.ArtifactsLibraries;
import com.jxdinfo.hussar.support.hotloaded.framework.plugin.packager.filter.Exclude;
import com.jxdinfo.hussar.support.hotloaded.framework.plugin.packager.filter.ExcludeFilter;
import com.jxdinfo.hussar.support.hotloaded.framework.plugin.packager.layer.Layers;
import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import java.util.function.Supplier;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Dependency;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectHelper;
import org.apache.maven.shared.artifact.filter.collection.ArtifactIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.ClassifierFilter;
import org.apache.maven.shared.artifact.filter.collection.GroupIdFilter;
import org.apache.maven.shared.artifact.filter.collection.ProjectTransitivityFilter;
import org.apache.maven.shared.artifact.filter.collection.ScopeFilter;
import org.apache.maven.shared.artifact.filter.collection.TypeFilter;
import org.springframework.boot.loader.tools.Layout;
import org.springframework.boot.loader.tools.LayoutFactory;
import org.springframework.boot.loader.tools.Layouts;
import org.springframework.boot.loader.tools.Libraries;
import org.springframework.boot.loader.tools.Packager;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;

public abstract class AbstractPackagerMojo
extends AbstractDependencyFilterMojo {
    private static final org.springframework.boot.loader.tools.Layers IMPLICIT_LAYERS = org.springframework.boot.loader.tools.Layers.IMPLICIT;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${session}", readonly=true, required=true)
    protected MavenSession session;
    @Component
    protected MavenProjectHelper projectHelper;
    @Parameter
    private String mainClass;
    @Parameter(property="hotloaded-plugin.repackage.excludeDevtools", defaultValue="true")
    private final boolean excludeDevtools = true;
    @Parameter(defaultValue="false")
    public boolean includeSystemScope;
    @Parameter
    private boolean excludeTransitive;
    @Parameter(property="excludeScope", defaultValue="")
    protected String excludeScope;
    @Parameter(property="includeScope", defaultValue="")
    protected String includeScope;
    @Parameter(property="includeTypes", defaultValue="")
    protected String includeTypes;
    @Parameter(property="excludeTypes", defaultValue="")
    protected String excludeTypes;
    @Parameter(property="includeClassifiers", defaultValue="")
    protected String includeClassifiers;
    @Parameter(property="excludeClassifiers", defaultValue="")
    protected String excludeClassifiers;
    @Parameter(property="excludeArtifactIds", defaultValue="")
    protected String excludeArtifactIds;
    @Parameter(property="includeArtifactIds", defaultValue="")
    protected String includeArtifactIds;
    @Parameter(property="excludeGroupIds", defaultValue="")
    protected String excludeGroupIds;
    @Parameter(property="includeGroupIds", defaultValue="")
    protected String includeGroupIds;
    @Parameter
    private Layers layers;

    protected LayoutType getLayout() {
        return null;
    }

    protected LayoutFactory getLayoutFactory() {
        return null;
    }

    protected <P extends Packager> P getConfiguredPackager(Supplier<P> supplier) {
        Packager packager = (Packager)supplier.get();
        packager.setLayoutFactory(this.getLayoutFactory());
        LayoutType layout = this.getLayout();
        if (layout != null) {
            this.getLog().info((CharSequence)("Layout: " + (Object)((Object)layout)));
            packager.setLayout(layout.layout());
        } else {
            this.getLog().info((CharSequence)"\u63d2\u4ef6\u6253\u5305\u65f6\uff1aLayout \u81ea\u5b9a\u4e49\u7684layout");
            packager.setLayout((Layout)new Layouts.PluginLayout());
        }
        return (P)packager;
    }

    private Document getDocumentIfAvailable(File xmlFile) throws Exception {
        InputSource inputSource = new InputSource(new FileInputStream(xmlFile));
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(inputSource);
    }

    protected final Libraries getLibraries(Collection<Dependency> unpacks) throws MojoExecutionException {
        Set artifacts = this.project.getArtifacts();
        Set<Artifact> includedArtifacts = this.filterDependencies(artifacts, this.getFilters(this.getAdditionalFilters()));
        return new ArtifactsLibraries(artifacts, includedArtifacts, this.session.getProjects(), unpacks, this.getLog());
    }

    private ArtifactsFilter[] getAdditionalFilters() {
        ArrayList<ExcludeFilter> filters = new ArrayList<ExcludeFilter>();
        ((Object)((Object)this)).getClass();
        Exclude exclude = new Exclude();
        exclude.setGroupId("org.springframework.boot");
        exclude.setArtifactId("spring-boot-devtools");
        ExcludeFilter filter = new ExcludeFilter(exclude);
        filters.add(filter);
        if (!this.includeSystemScope) {
            filters.add((ExcludeFilter)new ScopeFilter(null, "system"));
        }
        filters.add((ExcludeFilter)new ProjectTransitivityFilter(this.project.getDependencyArtifacts(), this.excludeTransitive));
        filters.add((ExcludeFilter)new ScopeFilter(AbstractPackagerMojo.cleanToBeTokenizedString(this.includeScope), AbstractPackagerMojo.cleanToBeTokenizedString(this.excludeScope)));
        filters.add((ExcludeFilter)new TypeFilter(AbstractPackagerMojo.cleanToBeTokenizedString(this.includeTypes), AbstractPackagerMojo.cleanToBeTokenizedString(this.excludeTypes)));
        filters.add((ExcludeFilter)new ClassifierFilter(AbstractPackagerMojo.cleanToBeTokenizedString(this.includeClassifiers), AbstractPackagerMojo.cleanToBeTokenizedString(this.excludeClassifiers)));
        filters.add((ExcludeFilter)new GroupIdFilter(AbstractPackagerMojo.cleanToBeTokenizedString(this.includeGroupIds), AbstractPackagerMojo.cleanToBeTokenizedString(this.excludeGroupIds)));
        filters.add((ExcludeFilter)new ArtifactIdFilter(AbstractPackagerMojo.cleanToBeTokenizedString(this.includeArtifactIds), AbstractPackagerMojo.cleanToBeTokenizedString(this.excludeArtifactIds)));
        return filters.toArray(new ArtifactsFilter[0]);
    }

    protected Artifact getSourceArtifact(String classifier) {
        Artifact sourceArtifact = this.getArtifact(classifier);
        return sourceArtifact != null ? sourceArtifact : this.project.getArtifact();
    }

    private Artifact getArtifact(String classifier) {
        if (classifier != null) {
            for (Artifact attachedArtifact : this.project.getAttachedArtifacts()) {
                if (!classifier.equals(attachedArtifact.getClassifier()) || attachedArtifact.getFile() == null || !attachedArtifact.getFile().isFile()) continue;
                return attachedArtifact;
            }
        }
        return null;
    }

    protected File getTargetFile(String finalName, String classifier, File targetDirectory) {
        String classifierSuffix;
        String string = classifierSuffix = classifier != null ? classifier.trim() : "";
        if (!classifierSuffix.isEmpty() && !classifierSuffix.startsWith("-")) {
            classifierSuffix = "-" + classifierSuffix;
        }
        if (!targetDirectory.exists()) {
            targetDirectory.mkdirs();
        }
        return new File(targetDirectory, finalName + classifierSuffix + "." + this.project.getArtifact().getArtifactHandler().getExtension());
    }

    private static String cleanToBeTokenizedString(String str) {
        String ret = "";
        if (str != null && !str.isEmpty()) {
            ret = str.trim().replaceAll("\\s*,\\s*", ",");
        }
        return ret;
    }

    public static enum LayoutType {
        JAR((Layout)new Layouts.Jar()),
        WAR(new Layouts.War()),
        ZIP((Layout)new Layouts.Expanded()),
        DIR((Layout)new Layouts.Expanded()),
        PLUGIN((Layout)new Layouts.PluginLayout()),
        NONE((Layout)new Layouts.None());

        private final Layout layout;

        private LayoutType(Layout layout) {
            this.layout = layout;
        }

        public Layout layout() {
            return this.layout;
        }
    }
}

