/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.hotloaded.framework.plugin.packager;

import com.jxdinfo.hussar.support.hotloaded.framework.plugin.packager.filter.Exclude;
import com.jxdinfo.hussar.support.hotloaded.framework.plugin.packager.filter.ExcludeFilter;
import com.jxdinfo.hussar.support.hotloaded.framework.plugin.packager.filter.Include;
import com.jxdinfo.hussar.support.hotloaded.framework.plugin.packager.filter.IncludeFilter;
import com.jxdinfo.hussar.support.hotloaded.framework.plugin.packager.filter.MatchingGroupIdFilter;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.shared.artifact.filter.collection.ArtifactFilterException;
import org.apache.maven.shared.artifact.filter.collection.ArtifactsFilter;
import org.apache.maven.shared.artifact.filter.collection.FilterArtifacts;

public abstract class AbstractDependencyFilterMojo
extends AbstractMojo {
    @Parameter(property="hotloaded-plugin.includes")
    private List<Include> includes;
    @Parameter(property="hotloaded-plugin.excludes")
    private List<Exclude> excludes;
    @Parameter(property="hotloaded-plugin.excludeGroupIds", defaultValue="")
    private String excludeGroupIds;

    protected void setExcludes(List<Exclude> excludes) {
        this.excludes = excludes;
    }

    protected void setIncludes(List<Include> includes) {
        this.includes = includes;
    }

    protected void setExcludeGroupIds(String excludeGroupIds) {
        this.excludeGroupIds = excludeGroupIds;
    }

    protected final Set<Artifact> filterDependencies(Set<Artifact> dependencies, FilterArtifacts filters) throws MojoExecutionException {
        try {
            LinkedHashSet<Artifact> filtered = new LinkedHashSet<Artifact>(dependencies);
            filtered.retainAll(filters.filter(dependencies));
            return filtered;
        }
        catch (ArtifactFilterException ex) {
            throw new MojoExecutionException(ex.getMessage(), (Exception)((Object)ex));
        }
    }

    protected final FilterArtifacts getFilters(ArtifactsFilter ... additionalFilters) {
        FilterArtifacts filters = new FilterArtifacts();
        for (ArtifactsFilter additionalFilter : additionalFilters) {
            filters.addFilter(additionalFilter);
        }
        filters.addFilter((ArtifactsFilter)new MatchingGroupIdFilter(this.cleanFilterConfig(this.excludeGroupIds)));
        if (this.includes != null && !this.includes.isEmpty()) {
            filters.addFilter((ArtifactsFilter)new IncludeFilter(this.includes));
        }
        if (this.excludes != null && !this.excludes.isEmpty()) {
            filters.addFilter((ArtifactsFilter)new ExcludeFilter(this.excludes));
        }
        return filters;
    }

    private String cleanFilterConfig(String content) {
        if (content == null || content.trim().isEmpty()) {
            return "";
        }
        StringBuilder cleaned = new StringBuilder();
        StringTokenizer tokenizer = new StringTokenizer(content, ",");
        while (tokenizer.hasMoreElements()) {
            cleaned.append(tokenizer.nextToken().trim());
            if (!tokenizer.hasMoreElements()) continue;
            cleaned.append(",");
        }
        return cleaned.toString();
    }
}

