/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.hotloaded.framework.extension.resource;

import com.jxdinfo.hussar.support.hotloaded.framework.extension.AbstractExtension;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.resource.PluginResourceResolverProcess;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.resource.resolver.ResourceWebMvcConfigurer;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.resource.thymeleaf.ThymeleafProcessor;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.process.pipe.PluginPipeProcessorExtend;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.process.post.PluginPostProcessorExtend;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.context.ApplicationContext;
import org.springframework.http.CacheControl;
import org.springframework.web.servlet.config.annotation.DelegatingWebMvcConfiguration;

public class StaticResourceExtension
extends AbstractExtension {
    private static final String KEY = "StaticResourceExtension";
    private static String pluginStaticResourcePathPrefix = "static-plugin";
    private static CacheControl pluginStaticResourcesCacheControl = CacheControl.maxAge((long)1L, (TimeUnit)TimeUnit.HOURS).cachePublic();
    private final Set<Include> includes = new HashSet<Include>(1);

    public StaticResourceExtension() {
    }

    public StaticResourceExtension(Include ... includes) {
        if (includes != null) {
            this.includes.addAll(Arrays.asList(includes));
        }
    }

    public String key() {
        return KEY;
    }

    public void initialize(ApplicationContext mainApplicationContext) throws Exception {
        ResourceWebMvcConfigurer webMvcConfigurer = new ResourceWebMvcConfigurer();
        ArrayList<ResourceWebMvcConfigurer> webMvcConfigurers = new ArrayList<ResourceWebMvcConfigurer>();
        webMvcConfigurers.add(webMvcConfigurer);
        DelegatingWebMvcConfiguration support = (DelegatingWebMvcConfiguration)mainApplicationContext.getBean(DelegatingWebMvcConfiguration.class);
        support.setConfigurers(webMvcConfigurers);
    }

    public List<PluginPipeProcessorExtend> getPluginPipeProcessor(ApplicationContext mainApplicationContext) {
        if (this.includes.contains((Object)Include.THYMELEAF)) {
            ArrayList<PluginPipeProcessorExtend> pluginPipeProcessorExtends = new ArrayList<PluginPipeProcessorExtend>(1);
            pluginPipeProcessorExtends.add(new ThymeleafProcessor());
            return pluginPipeProcessorExtends;
        }
        return null;
    }

    public List<PluginPostProcessorExtend> getPluginPostProcessor(ApplicationContext mainApplicationContext) {
        ArrayList<PluginPostProcessorExtend> pluginPostProcessorExtends = new ArrayList<PluginPostProcessorExtend>();
        pluginPostProcessorExtends.add(new PluginResourceResolverProcess());
        return pluginPostProcessorExtends;
    }

    public StaticResourceExtension setPathPrefix(String pluginStaticResourcePathPrefix) {
        if (pluginStaticResourcePathPrefix != null && !"".equals(pluginStaticResourcePathPrefix)) {
            StaticResourceExtension.pluginStaticResourcePathPrefix = pluginStaticResourcePathPrefix;
        }
        return this;
    }

    public StaticResourceExtension setCacheControl(CacheControl pluginStaticResourcesCacheControl) {
        StaticResourceExtension.pluginStaticResourcesCacheControl = pluginStaticResourcesCacheControl;
        return this;
    }

    public static String getPluginStaticResourcePathPrefix() {
        return pluginStaticResourcePathPrefix;
    }

    public static CacheControl getPluginStaticResourcesCacheControl() {
        return pluginStaticResourcesCacheControl;
    }

    public static enum Include {
        THYMELEAF;

    }
}

