/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.hotloaded.framework.extension.resource;

import com.jxdinfo.hussar.support.hotloaded.framework.extension.resource.StaticResourceConfig;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.resource.resolver.PluginResourceResolver;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.PluginRegistryInfo;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.process.post.PluginPostProcessorExtend;
import com.jxdinfo.hussar.support.hotloaded.framework.utils.OrderPriority;
import com.jxdinfo.hussar.support.hotloaded.framework.utils.SpringBeanUtils;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.util.ObjectUtils;

public class PluginResourceResolverProcess
implements PluginPostProcessorExtend {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginResourceResolverProcess.class);
    private static final String KEY = "PluginResourceResolverProcess";

    PluginResourceResolverProcess() {
    }

    public String key() {
        return KEY;
    }

    public OrderPriority order() {
        return OrderPriority.getMiddlePriority();
    }

    public void initialize() throws Exception {
    }

    public synchronized void registry(List<PluginRegistryInfo> pluginRegistryInfos) throws Exception {
        for (PluginRegistryInfo pluginRegistryInfo : pluginRegistryInfos) {
            if (pluginRegistryInfo == null) continue;
            String pluginId = pluginRegistryInfo.getPluginWrapper().getPluginId();
            try {
                StaticResourceConfig config;
                Set<String> locations = (Set<String>)pluginRegistryInfo.getPluginBinder().bind("plugin.static.locations", Bindable.setOf(String.class)).orElseGet(() -> null);
                if (ObjectUtils.isEmpty((Object)locations) && (config = (StaticResourceConfig)SpringBeanUtils.getObjectByInterfaceClass((Set)pluginRegistryInfo.getConfigSingletons(), StaticResourceConfig.class)) != null) {
                    locations = config.locations();
                }
                if (ObjectUtils.isEmpty((Object)locations)) {
                    return;
                }
                PluginResourceResolver.parse(pluginRegistryInfo, locations);
            }
            catch (Exception e) {
                LOGGER.error("Parse plugin '{}' static resource failure.", (Object)pluginId, (Object)e);
            }
        }
    }

    public void unRegistry(List<PluginRegistryInfo> pluginRegistryInfos) throws Exception {
        for (PluginRegistryInfo pluginRegistryInfo : pluginRegistryInfos) {
            try {
                PluginResourceResolver.remove(pluginRegistryInfo.getPluginWrapper().getPluginId());
            }
            catch (Exception e) {
                LOGGER.error("Remove plugin '{}' static resource failure.", (Object)pluginRegistryInfo.getPluginWrapper().getPluginId(), (Object)e);
            }
        }
    }
}

