/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis.xml;

import com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis.xml.StaxServiceFinder;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.apache.commons.lang3.StringUtils;
import org.apache.ibatis.builder.BaseBuilder;
import org.apache.ibatis.builder.BuilderException;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.scripting.defaults.RawSqlSource;
import org.apache.ibatis.scripting.xmltags.ChooseSqlNode;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.apache.ibatis.scripting.xmltags.ForEachSqlNode;
import org.apache.ibatis.scripting.xmltags.IfSqlNode;
import org.apache.ibatis.scripting.xmltags.MixedSqlNode;
import org.apache.ibatis.scripting.xmltags.SetSqlNode;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.scripting.xmltags.StaticTextSqlNode;
import org.apache.ibatis.scripting.xmltags.TextSqlNode;
import org.apache.ibatis.scripting.xmltags.TrimSqlNode;
import org.apache.ibatis.scripting.xmltags.VarDeclSqlNode;
import org.apache.ibatis.scripting.xmltags.WhereSqlNode;
import org.apache.ibatis.session.Configuration;

public class StaxXMLScriptBuilder
extends BaseBuilder {
    private static final String TAG_SCRIPT = "script";
    private static final String TAG_TRIM = "trim";
    private static final String TAG_WHERE = "where";
    private static final String TAG_SET = "set";
    private static final String TAG_FOREACH = "foreach";
    private static final String TAG_IF = "if";
    private static final String TAG_CHOOSE = "choose";
    private static final String TAG_WHEN = "when";
    private static final String TAG_OTHERWISE = "otherwise";
    private static final String TAG_BIND = "bind";
    private final Reader inputReader;
    private final Class<?> parameterType;
    private boolean textCoalescing = false;
    private String preferredStaxImplementation = null;
    private NodeBuilder topElement = null;
    private final ArrayList<NodeBuilder> elementStack = new ArrayList();
    private boolean dynamicFlag = false;

    public StaxXMLScriptBuilder(Configuration configuration, Reader inputReader) {
        this(configuration, inputReader, null);
    }

    public StaxXMLScriptBuilder(Configuration configuration, Reader inputReader, Class<?> parameterType) {
        super(configuration);
        this.inputReader = inputReader;
        this.parameterType = parameterType;
    }

    public boolean isTextCoalescing() {
        return this.textCoalescing;
    }

    public void setTextCoalescing(boolean textCoalescing) {
        this.textCoalescing = textCoalescing;
    }

    public String getPreferredStaxImplementation() {
        return this.preferredStaxImplementation;
    }

    public void setPreferredStaxImplementation(String preferredStaxImplementation) {
        this.preferredStaxImplementation = preferredStaxImplementation;
    }

    public SqlSource parseScriptNode() {
        SqlNode rootSqlNode = this.parseSqlNode();
        Object sqlSource = this.dynamicFlag ? new DynamicSqlSource(this.configuration, rootSqlNode) : new RawSqlSource(this.configuration, rootSqlNode, this.parameterType);
        return sqlSource;
    }

    private SqlNode parseSqlNode() {
        try {
            XMLInputFactory xmlInputFactory = this.preferredStaxImplementation != null ? StaxServiceFinder.createXMLInputFactory(this.preferredStaxImplementation) : StaxServiceFinder.createXMLInputFactory();
            if (this.textCoalescing) {
                xmlInputFactory.setProperty("javax.xml.stream.isCoalescing", true);
            }
            XMLStreamReader xmlReader = xmlInputFactory.createXMLStreamReader(this.inputReader);
            this.startParsing();
            StringBuilder text = new StringBuilder();
            while (xmlReader.hasNext()) {
                NodeBuilder current;
                int eventType = xmlReader.next();
                if (eventType == 4 || eventType == 6) {
                    text.append(xmlReader.getText());
                    continue;
                }
                if (text.length() > 0) {
                    this.addNode(NodeBuilder.text(text.toString()));
                    text.setLength(0);
                }
                if (eventType == 12) {
                    current = NodeBuilder.cdata(xmlReader.getText());
                    this.addNode(current);
                    continue;
                }
                if (eventType == 1) {
                    current = NodeBuilder.element(xmlReader.getLocalName());
                    for (int i = 0; i < xmlReader.getAttributeCount(); ++i) {
                        String attributeName = xmlReader.getAttributeLocalName(i);
                        String attributeValue = xmlReader.getAttributeValue(i);
                        current.setAttribute(attributeName, attributeValue);
                    }
                    this.openElement(current);
                    continue;
                }
                if (eventType == 2) {
                    this.closeElement(xmlReader.getLocalName());
                    continue;
                }
                if (eventType != 8) continue;
                return this.finishParsing();
            }
            if (text.length() > 0) {
                this.addNode(NodeBuilder.text(text.toString()));
                text.setLength(0);
            }
            throw new BuilderException("unreachable, missing document end");
        }
        catch (XMLStreamException ex) {
            throw new BuilderException("failed to parse xml", (Throwable)ex);
        }
    }

    private void startParsing() {
        this.openElement(NodeBuilder.root());
    }

    private SqlNode finishParsing() {
        if (this.elementStack.size() == 1 && this.elementStack.get(0).getLength() == 1) {
            NodeBuilder node = this.elementStack.get(0).getChild(0);
            if (node != null && TAG_SCRIPT.equals(node.getTag())) {
                return node.build(this);
            }
            throw new BuilderException("root tag must be script");
        }
        throw new BuilderException("multiple root elements");
    }

    private void openElement(NodeBuilder node) {
        this.topElement = node;
        this.elementStack.add(node);
    }

    private void addNode(NodeBuilder node) {
        if (node == null) {
            return;
        }
        this.topElement.addChild(node);
    }

    private void closeElement(String tag) {
        if (tag == null) {
            throw new BuilderException("close tag is null");
        }
        if (!Objects.equals(this.topElement.getTag(), tag)) {
            throw new BuilderException("close tag does not strictly match: " + tag);
        }
        int idx = this.elementStack.size() - 1;
        NodeBuilder current = this.elementStack.remove(idx);
        this.topElement = this.elementStack.get(idx - 1);
        this.topElement.addChild(current);
    }

    private void markDynamic() {
        this.dynamicFlag = true;
    }

    private static class NodeBuilder {
        private final Type type;
        private final String tag;
        private final String value;
        private Map<String, String> attributes;
        private List<NodeBuilder> children;

        private NodeBuilder(Type type, String tag, String value) {
            this.type = type;
            this.tag = tag;
            this.value = value;
        }

        public static NodeBuilder root() {
            return new NodeBuilder(Type.ROOT, null, null);
        }

        public static NodeBuilder element(String tag) {
            return new NodeBuilder(Type.ELEMENT, tag, null);
        }

        public static NodeBuilder text(String value) {
            if (StringUtils.isEmpty((CharSequence)value)) {
                return null;
            }
            return new NodeBuilder(Type.TEXT, null, value);
        }

        public static NodeBuilder cdata(String value) {
            return new NodeBuilder(Type.CDATA, null, value);
        }

        public boolean isTerminal() {
            return this.type == Type.TEXT || this.type == Type.CDATA;
        }

        public boolean isElement(String tag) {
            return this.type == Type.ELEMENT && Objects.equals(this.tag, tag);
        }

        public String getAttribute(String name) {
            if (this.attributes == null) {
                return null;
            }
            return this.attributes.get(name);
        }

        public Boolean getAttributeAsBoolean(String name) {
            String literal = this.getAttribute(name);
            return literal == null ? null : Boolean.valueOf(literal);
        }

        public void setAttribute(String name, String value) {
            if (this.attributes == null) {
                this.attributes = new LinkedHashMap<String, String>();
            }
            this.attributes.put(name, value);
        }

        public int getLength() {
            if (this.children == null) {
                return 0;
            }
            return this.children.size();
        }

        public NodeBuilder getChild(int index) {
            if (this.children == null) {
                return null;
            }
            if (0 > index || index >= this.children.size()) {
                return null;
            }
            return this.children.get(index);
        }

        public void addChild(NodeBuilder child) {
            if (this.children == null) {
                this.children = new ArrayList<NodeBuilder>();
            }
            this.children.add(child);
        }

        public SqlNode build(StaxXMLScriptBuilder context) {
            return this.buildNode(context, true);
        }

        private SqlNode buildNode(StaxXMLScriptBuilder context) {
            return this.buildNode(context, false);
        }

        private SqlNode buildNode(StaxXMLScriptBuilder context, boolean root) {
            switch (this.type) {
                case TEXT: 
                case CDATA: {
                    String data = Objects.toString(this.value, "");
                    TextSqlNode textSqlNode = new TextSqlNode(data);
                    if (textSqlNode.isDynamic()) {
                        context.markDynamic();
                        return textSqlNode;
                    }
                    return new StaticTextSqlNode(data);
                }
                case ELEMENT: {
                    if (!Objects.equals(this.tag, StaxXMLScriptBuilder.TAG_SCRIPT)) {
                        context.markDynamic();
                    }
                    return this.buildElement(context, root);
                }
            }
            throw new BuilderException("unsupported node type: " + (Object)((Object)this.type));
        }

        private SqlNode buildElement(StaxXMLScriptBuilder context, boolean root) {
            switch (this.tag) {
                case "script": {
                    if (!root) {
                        throw new BuilderException("script tag must be root");
                    }
                    return this.buildChildren(context);
                }
                case "trim": {
                    return new TrimSqlNode(context.configuration, (SqlNode)this.buildChildren(context), this.getAttribute("prefix"), this.getAttribute("prefixOverrides"), this.getAttribute("suffix"), this.getAttribute("suffixOverrides"));
                }
                case "where": {
                    return new WhereSqlNode(context.configuration, (SqlNode)this.buildChildren(context));
                }
                case "set": {
                    return new SetSqlNode(context.configuration, (SqlNode)this.buildChildren(context));
                }
                case "foreach": {
                    return new ForEachSqlNode(context.configuration, (SqlNode)this.buildChildren(context), this.getAttribute("collection"), this.getAttributeAsBoolean("nullable"), this.getAttribute("index"), this.getAttribute("item"), this.getAttribute("open"), this.getAttribute("close"), this.getAttribute("separator"));
                }
                case "if": 
                case "when": {
                    return new IfSqlNode((SqlNode)this.buildChildren(context), this.getAttribute("test"));
                }
                case "choose": {
                    ArrayList<SqlNode> whenNodes = new ArrayList<SqlNode>();
                    ArrayList<SqlNode> otherwiseNodes = new ArrayList<SqlNode>();
                    for (NodeBuilder child : this.getChildrenNotNull()) {
                        if (child.isElement(StaxXMLScriptBuilder.TAG_WHEN) || child.isElement(StaxXMLScriptBuilder.TAG_IF)) {
                            SqlNode whenNode = child.buildElement(context, false);
                            whenNodes.add(whenNode);
                            continue;
                        }
                        if (!child.isElement(StaxXMLScriptBuilder.TAG_OTHERWISE)) continue;
                        SqlNode otherwiseNode = child.buildElement(context, false);
                        otherwiseNodes.add(otherwiseNode);
                    }
                    SqlNode defaultNode = null;
                    if (otherwiseNodes.size() == 1) {
                        defaultNode = (SqlNode)otherwiseNodes.get(0);
                    } else if (otherwiseNodes.size() > 1) {
                        throw new BuilderException("too many otherwise elements in choose statement");
                    }
                    return new ChooseSqlNode(whenNodes, defaultNode);
                }
                case "otherwise": {
                    return this.buildChildren(context);
                }
                case "bind": {
                    return new VarDeclSqlNode(this.getAttribute("name"), this.getAttribute("value"));
                }
            }
            throw new BuilderException("unsupported tag: " + this.tag);
        }

        private MixedSqlNode buildChildren(StaxXMLScriptBuilder context) {
            ArrayList<SqlNode> nodes = new ArrayList<SqlNode>(this.getLength());
            for (NodeBuilder child : this.getChildrenNotNull()) {
                nodes.add(child.buildNode(context));
            }
            return new MixedSqlNode(nodes);
        }

        public Type getType() {
            return this.type;
        }

        public String getTag() {
            return this.tag;
        }

        public String getValue() {
            return this.value;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public void setAttributes(Map<String, String> attributes) {
            this.attributes = attributes;
        }

        public List<NodeBuilder> getChildrenNotNull() {
            return this.children != null ? this.children : Collections.emptyList();
        }

        public List<NodeBuilder> getChildren() {
            return this.children;
        }

        public void setChildren(List<NodeBuilder> children) {
            this.children = children;
        }

        public String toString() {
            StringBuilder builder = new StringBuilder();
            switch (this.type) {
                case ELEMENT: {
                    builder.append("<ELEMENT ").append(this.tag);
                    boolean first = true;
                    if (this.attributes != null && !this.attributes.isEmpty()) {
                        builder.append(":");
                        first = false;
                        builder.append(" attributes=").append(this.attributes);
                    }
                    if (this.children == null || this.children.isEmpty()) break;
                    if (first) {
                        builder.append(":");
                    }
                    builder.append(" children=").append(this.children);
                    break;
                }
                case TEXT: {
                    builder.append("<TEXT: ").append(this.value).append(">");
                    break;
                }
                case CDATA: {
                    builder.append("<CDATA: ").append(this.value).append(">");
                }
            }
            return builder.toString();
        }

        public static enum Type {
            ROOT,
            ELEMENT,
            TEXT,
            CDATA;

        }
    }
}

