/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis.xml;

import com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis.xml.StaxXMLScriptBuilder;
import java.io.StringReader;
import java.util.Properties;
import org.apache.ibatis.mapping.SqlSource;
import org.apache.ibatis.parsing.PropertyParser;
import org.apache.ibatis.parsing.XNode;
import org.apache.ibatis.scripting.defaults.RawSqlSource;
import org.apache.ibatis.scripting.xmltags.DynamicSqlSource;
import org.apache.ibatis.scripting.xmltags.SqlNode;
import org.apache.ibatis.scripting.xmltags.TextSqlNode;
import org.apache.ibatis.scripting.xmltags.XMLLanguageDriver;
import org.apache.ibatis.session.Configuration;

public class StaxXMLLanguageDriver
extends XMLLanguageDriver {
    private volatile Boolean textCoalescing = null;
    private volatile String preferredStaxImplementation = null;

    public SqlSource createSqlSource(Configuration configuration, XNode script, Class<?> parameterType) {
        return super.createSqlSource(configuration, script, parameterType);
    }

    public SqlSource createSqlSource(Configuration configuration, String script, Class<?> parameterType) {
        if (script.startsWith("<script>")) {
            return this.createSqlSourceStax(configuration, script, parameterType);
        }
        TextSqlNode textSqlNode = new TextSqlNode(script = PropertyParser.parse((String)script, (Properties)configuration.getVariables()));
        if (textSqlNode.isDynamic()) {
            return new DynamicSqlSource(configuration, (SqlNode)textSqlNode);
        }
        return new RawSqlSource(configuration, script, parameterType);
    }

    private SqlSource createSqlSourceStax(Configuration configuration, String script, Class<?> parameterType) {
        StaxXMLScriptBuilder scriptBuilder = new StaxXMLScriptBuilder(configuration, new StringReader(script), parameterType);
        if (this.textCoalescing != null) {
            scriptBuilder.setTextCoalescing(this.textCoalescing);
        }
        if (this.preferredStaxImplementation != null) {
            scriptBuilder.setPreferredStaxImplementation(this.preferredStaxImplementation);
        }
        return scriptBuilder.parseScriptNode();
    }

    public Boolean getTextCoalescing() {
        return this.textCoalescing;
    }

    public void setTextCoalescing(Boolean textCoalescing) {
        this.textCoalescing = textCoalescing;
    }

    public String getPreferredStaxImplementation() {
        return this.preferredStaxImplementation;
    }

    public void setPreferredStaxImplementation(String preferredStaxImplementation) {
        this.preferredStaxImplementation = preferredStaxImplementation;
    }
}

