/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis.support;

import com.jxdinfo.hussar.platform.core.support.service.dto.SharePluginInfo;
import com.jxdinfo.hussar.platform.core.support.service.dto.TenantDetails;
import com.jxdinfo.hussar.platform.core.tenant.util.HussarTenantContextHolder;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.cache.util.HussarFixedCacheUtil;
import com.jxdinfo.hussar.support.expansion.core.aspect.impl.AbstractExpansionMethodAspectService;
import com.jxdinfo.hussar.support.expansion.core.config.ExpansionMethodExtensionInfo;
import com.jxdinfo.hussar.support.expansion.core.config.HussarExpansionProperties;
import com.jxdinfo.hussar.support.expansion.core.context.ExpansionContextHolder;
import com.jxdinfo.hussar.support.expansion.core.service.ExpansionColumnInfoService;
import com.jxdinfo.hussar.support.expansion.core.support.service.ExtensionInvocationService;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.PluginRegistryInfo;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.process.pipe.extract.ExtractCoordinate;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.process.pipe.extract.ExtractFactory;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.aopalliance.intercept.MethodInvocation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

public class ExtensionPluginMethodAspectService
extends AbstractExpansionMethodAspectService {
    private static final Logger log = LoggerFactory.getLogger(ExtensionPluginMethodAspectService.class);
    private PluginRegistryInfo pluginRegistryInfo;
    private HussarExpansionProperties hussarExpansionProperties;

    public ExtensionPluginMethodAspectService(ExpansionColumnInfoService expansionColumnInfoService, PluginRegistryInfo pluginRegistryInfo, HussarExpansionProperties hussarExpansionProperties) {
        super(expansionColumnInfoService);
        this.pluginRegistryInfo = pluginRegistryInfo;
        this.hussarExpansionProperties = hussarExpansionProperties;
    }

    public void doAspectService(MethodInvocation invocation, String interceptType, Object procced) {
        Service serviceAnno = this.getServiceAnno(invocation);
        String modelId = ExpansionContextHolder.get();
        if (HussarUtils.isEmpty((Object)modelId) || HussarUtils.isEmpty((Object)serviceAnno) || HussarUtils.isEmpty((Object)this.getExpansionMethodConfigMap())) {
            return;
        }
        List expansionMethodExtensionInfos = (List)this.getExpansionMethodConfigMap().get(interceptType);
        if (HussarUtils.isEmpty((Object)expansionMethodExtensionInfos)) {
            return;
        }
        String pluginId = this.getExpansionPluginId();
        Object[] arguments = invocation.getArguments();
        for (ExpansionMethodExtensionInfo emei : expansionMethodExtensionInfos) {
            String methodName = emei.getMethodName();
            Map extract = emei.getExtract();
            if (HussarUtils.isEmpty((Object)extract)) continue;
            ExtractCoordinate extractCoordinate = ExtractCoordinate.build((String)((String)extract.get("bus")), (String)((String)extract.get("scene")), (String)((String)extract.get("useCase")));
            ExtensionInvocationService extensionInvocationService = (ExtensionInvocationService)ExtractFactory.getInstant().getExtractByCoordinate(pluginId, extractCoordinate);
            if (HussarUtils.isEmpty((Object)extensionInvocationService)) continue;
            extensionInvocationService.doInvocation(methodName, procced, arguments);
        }
    }

    private String getExpansionPluginId() {
        String pluginId = this.pluginRegistryInfo.getPluginWrapper().getPluginId();
        String expansionPluginId = null;
        if (HussarUtils.isNotEmpty((Object)this.hussarExpansionProperties) && this.hussarExpansionProperties.isShared()) {
            TenantDetails tenant = HussarTenantContextHolder.getTenant();
            log.info("config share plugin method aspect get pluginid start......");
            if (HussarUtils.isEmpty((Object)tenant) || HussarUtils.isEmpty((Object)tenant.getTenantCode())) {
                log.error("\u83b7\u53d6MethodAspect \u672a\u627e\u5230\u5f53\u524d\u7684\u79df\u6237code:{},\u65e0\u6cd5\u83b7\u53d6\u5b57\u6bb5\u914d\u7f6e\u4fe1\u606f", (Object)tenant.getTenantCode());
                return null;
            }
            Map appV1CodeMap = HussarFixedCacheUtil.getHash((String)"share-plugins", (String)("tenant-plugins:" + tenant.getTenantCode()));
            if (HussarUtils.isEmpty((Object)appV1CodeMap)) {
                log.error("\u83b7\u53d6MethodAspect \u672a\u627e\u5230\u5f53\u524d\u7684\u79df\u6237code:{},\u4e0b\u7684\u914d\u7f6e\u63d2\u4ef6\u7684\u4fe1\u606f,\u65e0\u6cd5\u83b7\u53d6\u5b57\u6bb5\u914d\u7f6e\u4fe1\u606f", (Object)tenant.getTenantCode());
                expansionPluginId = tenant.getTenantCode() + "-" + pluginId + this.hussarExpansionProperties.getPluginNameSuffix();
            } else {
                expansionPluginId = this.getExpansionPluginId(pluginId, tenant.getTenantCode(), appV1CodeMap);
            }
            log.info("config share plugin method aspect getpluginId={}", (Object)pluginId);
            return expansionPluginId;
        }
        log.info("not config share plugin method aspect get pluginid start......");
        expansionPluginId = pluginId + this.hussarExpansionProperties.getPluginNameSuffix();
        log.info("not config share plugin method aspect getpluginId={}", (Object)pluginId);
        return expansionPluginId;
    }

    private String getExpansionPluginId(String pluginId, String tenantCode, Map<Object, Object> appV1CodeMap) {
        String expansionPluginId;
        try {
            Optional<SharePluginInfo> optional = appV1CodeMap.values().stream().filter(o -> {
                SharePluginInfo sharePluginInfo = (SharePluginInfo)o;
                return pluginId.equalsIgnoreCase(sharePluginInfo.getSharePluginId() + "-" + sharePluginInfo.getAppVersion());
            }).map(o -> (SharePluginInfo)o).findFirst();
            expansionPluginId = optional.isPresent() && HussarUtils.isNotEmpty((Object)optional.get().getExpansionPluginId()) ? optional.get().getExpansionPluginId() : tenantCode + "-" + pluginId + this.hussarExpansionProperties.getPluginNameSuffix();
            log.info("config share plugin method aspect sharePluginId:{}", (Object)(optional.isPresent() ? optional.get().getSharePluginId() : ""));
        }
        catch (Exception ex) {
            log.error("\u4ece\u7f13\u5b58map\u4e2d\u83b7\u53d6pluginId\u5f02\u5e38:", (Throwable)ex);
            expansionPluginId = null;
        }
        return expansionPluginId;
    }

    public int order() {
        return 2;
    }
}

