/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis;

import com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis.CommonRegister;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis.MapperHandler;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis.PluginFollowCoreConfig;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis.PluginResourceFinder;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis.SpringBootMybatisConfig;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.mybatis.SpringBootMybatisExtension;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.PluginRegistryInfo;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.process.pipe.bean.PluginBeanRegistrarExtend;
import com.jxdinfo.hussar.support.hotloaded.framework.utils.SpringBeanUtils;
import java.util.Set;
import org.apache.ibatis.io.Resources;
import org.apache.ibatis.mapping.DatabaseIdProvider;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.scripting.LanguageDriver;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.Resource;

public class MybatisProcessor
implements PluginBeanRegistrarExtend {
    private static final Logger LOGGER = LoggerFactory.getLogger(MybatisProcessor.class);

    public String key() {
        return "MybatisProcessor";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        Resource[] xmlResource;
        SpringBootMybatisConfig config = (SpringBootMybatisConfig)SpringBeanUtils.getObjectByInterfaceClass((Set)pluginRegistryInfo.getConfigSingletons(), SpringBootMybatisConfig.class);
        if (config == null) {
            return;
        }
        SqlSessionFactoryBean factory = new SqlSessionFactoryBean();
        if (config.enableOneselfConfig()) {
            config.oneselfConfig(factory);
        } else {
            LanguageDriver[] languageDrivers;
            DatabaseIdProvider databaseIdProvider;
            GenericApplicationContext mainApplicationContext = pluginRegistryInfo.getMainApplicationContext();
            PluginFollowCoreConfig followCoreConfig = new PluginFollowCoreConfig((ApplicationContext)mainApplicationContext);
            factory.setDataSource(followCoreConfig.getDataSource());
            Configuration configuration = followCoreConfig.getConfiguration(SpringBootMybatisExtension.Type.MYBATIS);
            factory.setConfiguration(configuration);
            Interceptor[] interceptor = followCoreConfig.getInterceptor();
            if (interceptor != null && interceptor.length > 0) {
                factory.setPlugins(interceptor);
            }
            if ((databaseIdProvider = followCoreConfig.getDatabaseIdProvider()) != null) {
                factory.setDatabaseIdProvider(databaseIdProvider);
            }
            if ((languageDrivers = followCoreConfig.getLanguageDriver()) != null) {
                for (LanguageDriver languageDriver : languageDrivers) {
                    configuration.getLanguageRegistry().register(languageDriver);
                }
            }
        }
        PluginResourceFinder pluginResourceFinder = new PluginResourceFinder(pluginRegistryInfo);
        Class[] aliasesClasses = pluginResourceFinder.getAliasesClasses(config.entityPackage());
        if (aliasesClasses != null && aliasesClasses.length > 0) {
            factory.setTypeAliases(aliasesClasses);
        }
        if ((xmlResource = pluginResourceFinder.getXmlResource(config.xmlLocationsMatch())) != null && xmlResource.length > 0) {
            factory.setMapperLocations(xmlResource);
        }
        ClassLoader defaultClassLoader = Resources.getDefaultClassLoader();
        try {
            Resources.setDefaultClassLoader((ClassLoader)pluginRegistryInfo.getPluginClassLoader());
            SqlSessionFactory sqlSessionFactory = factory.getObject();
            if (sqlSessionFactory == null) {
                throw new Exception("Get mybatis sqlSessionFactory is null");
            }
            SqlSessionTemplate sqlSessionTemplate = new SqlSessionTemplate(sqlSessionFactory);
            MapperHandler mapperHandler = new MapperHandler();
            mapperHandler.processMapper(pluginRegistryInfo, (holder, mapperClass) -> mapperHandler.commonProcessMapper(holder, mapperClass, sqlSessionFactory, sqlSessionTemplate));
            CommonRegister.commonRegister(pluginRegistryInfo, sqlSessionFactory, sqlSessionTemplate);
        }
        finally {
            Resources.setDefaultClassLoader((ClassLoader)defaultClassLoader);
        }
    }
}

