/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.hotloaded.framework.extension.log.util;

import com.jxdinfo.hussar.support.hotloaded.framework.extension.log.annotation.ConfigItem;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.log.config.LogConfig;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.log.util.ObjectUtil;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.PluginRegistryInfo;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.IntegrationConfiguration;
import com.jxdinfo.hussar.support.hotloaded.framework.utils.CommonUtils;
import com.jxdinfo.hussar.support.hotloaded.framework.utils.ResourceUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.pf4j.PluginWrapper;
import org.pf4j.RuntimeMode;
import org.pf4j.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class LogConfigUtil {
    private static final Logger LOG = LoggerFactory.getLogger(LogConfigUtil.class);
    public static final String ROOT_PLUGIN_SIGN = "~";

    public static LogConfig getLogConfig(Resource xmlResource, PluginRegistryInfo pluginRegistryInfo) throws Exception {
        PluginWrapper pluginWrapper = pluginRegistryInfo.getPluginWrapper();
        String configText = LogConfigUtil.readConfigText(xmlResource);
        LogConfig logConfig = (LogConfig)LogConfigUtil.xml2object(configText);
        LogConfigUtil.checkLogConfig(logConfig, pluginWrapper.getPluginId());
        String packageName = logConfig.getPackageName();
        if (StringUtils.isNullOrEmpty((String)packageName)) {
            logConfig.setPackageName(pluginRegistryInfo.getBasePlugin().scanPackage());
        }
        return logConfig;
    }

    public static String getLogFile(PluginRegistryInfo pluginRegistryInfo, LogConfig logConfig) {
        String rootDir = logConfig.getRootDir();
        PluginWrapper pluginWrapper = pluginRegistryInfo.getPluginWrapper();
        IntegrationConfiguration configuration = pluginRegistryInfo.getConfiguration();
        RuntimeMode runtimeMode = pluginWrapper.getRuntimeMode();
        String pluginRootDir = runtimeMode == RuntimeMode.DEVELOPMENT ? pluginWrapper.getPluginPath().toString() : configuration.pluginPath();
        String home = StringUtils.isNullOrEmpty((String)rootDir) ? CommonUtils.joiningFilePath((String[])new String[]{pluginRootDir, "logs"}) : ResourceUtils.getAbsolutePath((PluginRegistryInfo)pluginRegistryInfo, (String)rootDir);
        String fileName = logConfig.getFileName();
        if (StringUtils.isNullOrEmpty((String)fileName)) {
            fileName = pluginWrapper.getPluginId();
        }
        return CommonUtils.joiningFilePath((String[])new String[]{home, pluginWrapper.getPluginId(), fileName});
    }

    private static void checkLogConfig(LogConfig logConfig, String pluginId) {
        Field[] fields;
        String fileName = logConfig.getFileName();
        if (StringUtils.isNullOrEmpty((String)fileName)) {
            logConfig.setFileName(pluginId.concat("-log"));
        }
        for (Field field : fields = LogConfig.class.getDeclaredFields()) {
            ConfigItem configItem;
            if (!field.isAccessible()) {
                field.setAccessible(true);
            }
            if ((configItem = field.getDeclaredAnnotation(ConfigItem.class)) == null) continue;
            try {
                Object fieldValue = field.get(logConfig);
                Class<?> fieldType = field.getType();
                if (fieldValue != null && !"".equals(fieldValue.toString()) && !ObjectUtil.isEmptyObject(fieldType, fieldValue)) continue;
                String defaultValue = configItem.defaultValue();
                LOG.debug("Field {} is not config or invalid in log config of plugin {}, set it to default value {}.", new Object[]{field.getName(), defaultValue, pluginId});
                Object fixedValue = ObjectUtil.parseBasicTypeValue(fieldType, defaultValue);
                field.set(logConfig, fixedValue);
            }
            catch (IllegalAccessException e) {
                LOG.error("Failed to check config item {} in log config.", (Object)field.getName());
            }
        }
    }

    private static String readConfigText(Resource resource) throws IOException {
        String fileContent;
        try (InputStream inputStream = resource.getInputStream();
             ByteArrayOutputStream stream = new ByteArrayOutputStream();){
            int len;
            byte[] buff = new byte[1024];
            while ((len = inputStream.read(buff)) != -1) {
                stream.write(buff, 0, len);
            }
            fileContent = stream.toString();
        }
        return fileContent;
    }

    private static Object xml2object(String xml) throws Exception {
        Object object;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{LogConfig.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            StringReader stringReader = new StringReader(xml);
            object = unmarshaller.unmarshal((Reader)stringReader);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            throw new Exception("Invalid xml definition");
        }
        return object;
    }
}

