/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.hotloaded.framework.extension.log.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.rolling.RollingFileAppender;
import ch.qos.logback.core.rolling.RollingPolicy;
import ch.qos.logback.core.rolling.SizeAndTimeBasedRollingPolicy;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.spi.PropertyContainer;
import ch.qos.logback.core.util.FileSize;
import ch.qos.logback.core.util.OptionHelper;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.log.LogRegistry;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.log.config.LogConfig;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.log.util.LogConfigUtil;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.PluginRegistryInfo;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.pf4j.PluginWrapper;
import org.pf4j.util.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;

public class LogbackLogRegistry
implements LogRegistry {
    private final Logger log = LoggerFactory.getLogger(LogbackLogRegistry.class);
    private final Map<String, Set<Appender<ILoggingEvent>>> pluginAppenderInfo = new ConcurrentHashMap<String, Set<Appender<ILoggingEvent>>>();

    @Override
    public void registry(List<Resource> resources, PluginRegistryInfo pluginRegistryInfo) throws Exception {
        HashSet<Appender<ILoggingEvent>> appenderSet = new HashSet<Appender<ILoggingEvent>>();
        PluginWrapper pluginWrapper = pluginRegistryInfo.getPluginWrapper();
        for (Resource resource : resources) {
            LogConfig logConfig;
            if (resource == null) continue;
            try {
                logConfig = LogConfigUtil.getLogConfig(resource, pluginRegistryInfo);
            }
            catch (Exception e) {
                this.log.error("Failed to read log configuration.", (Throwable)e);
                continue;
            }
            Set<Appender<ILoggingEvent>> logAppenderSet = this.addAppender(pluginRegistryInfo, logConfig);
            appenderSet.addAll(logAppenderSet);
        }
        this.pluginAppenderInfo.put(pluginWrapper.getPluginId(), appenderSet);
    }

    @Override
    public void unRegistry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        PluginWrapper pluginWrapper = pluginRegistryInfo.getPluginWrapper();
        Set<Appender<ILoggingEvent>> logAppenderSet = this.pluginAppenderInfo.get(pluginWrapper.getPluginId());
        if (logAppenderSet == null || logAppenderSet.isEmpty()) {
            return;
        }
        String packageName = pluginRegistryInfo.getBasePlugin().scanPackage();
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        ch.qos.logback.classic.Logger logger = context.getLogger(packageName);
        for (Appender<ILoggingEvent> appender : logAppenderSet) {
            logger.detachAppender(appender);
        }
        this.pluginAppenderInfo.remove(pluginWrapper.getPluginId());
    }

    private Set<Appender<ILoggingEvent>> addAppender(PluginRegistryInfo pluginRegistryInfo, LogConfig logConfig) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        String packageName = logConfig.getPackageName();
        ch.qos.logback.classic.Logger logger = context.getLogger(packageName);
        logger.detachAndStopAllAppenders();
        ConsoleAppender<ILoggingEvent> consoleAppender = this.createConsoleAppender(pluginRegistryInfo.getPluginWrapper(), logConfig, packageName);
        RollingFileAppender<ILoggingEvent> fileAppender = this.createFileAppender(pluginRegistryInfo, logConfig, packageName);
        logger.setAdditive(false);
        logger.setLevel(Level.toLevel((String)logConfig.getLevel()));
        logger.addAppender(consoleAppender);
        logger.addAppender(fileAppender);
        HashSet<Appender<ILoggingEvent>> appenderSet = new HashSet<Appender<ILoggingEvent>>();
        appenderSet.add((Appender<ILoggingEvent>)consoleAppender);
        appenderSet.add((Appender<ILoggingEvent>)fileAppender);
        return appenderSet;
    }

    private ConsoleAppender<ILoggingEvent> createConsoleAppender(PluginWrapper pluginWrapper, LogConfig logConfig, String packageName) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        ConsoleAppender appender = new ConsoleAppender();
        LogFilter filter = new LogFilter(packageName);
        filter.start();
        appender.addFilter((Filter)filter);
        appender.setContext((Context)context);
        appender.setName(pluginWrapper.getPluginId().concat("-console"));
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)context);
        encoder.setPattern(logConfig.getPattern());
        encoder.start();
        appender.setEncoder((Encoder)encoder);
        appender.start();
        return appender;
    }

    private RollingFileAppender<ILoggingEvent> createFileAppender(PluginRegistryInfo pluginRegistryInfo, LogConfig logConfig, String packageName) {
        LoggerContext context = (LoggerContext)LoggerFactory.getILoggerFactory();
        RollingFileAppender appender = new RollingFileAppender();
        if (StringUtils.isNotNullOrEmpty((String)packageName)) {
            LogFilter filter = new LogFilter(packageName);
            filter.start();
            appender.addFilter((Filter)filter);
        }
        PluginWrapper pluginWrapper = pluginRegistryInfo.getPluginWrapper();
        appender.setContext((Context)context);
        appender.setName(pluginWrapper.getPluginId());
        String logFilePrefix = LogConfigUtil.getLogFile(pluginRegistryInfo, logConfig);
        appender.setFile(OptionHelper.substVars((String)logFilePrefix.concat(".log"), (PropertyContainer)context));
        appender.setAppend(true);
        appender.setPrudent(false);
        SizeAndTimeBasedRollingPolicy policy = new SizeAndTimeBasedRollingPolicy();
        String fp = OptionHelper.substVars((String)logFilePrefix.concat(".%d{yyyy-MM-dd}-%i.log"), (PropertyContainer)context);
        policy.setMaxFileSize(FileSize.valueOf((String)logConfig.getMaxFileSize()));
        policy.setFileNamePattern(fp);
        policy.setMaxHistory(logConfig.getMaxHistory().intValue());
        policy.setTotalSizeCap(FileSize.valueOf((String)logConfig.getTotalFileSize()));
        policy.setParent((FileAppender)appender);
        policy.setContext((Context)context);
        policy.start();
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext((Context)context);
        encoder.setPattern(logConfig.getPattern());
        encoder.start();
        appender.setRollingPolicy((RollingPolicy)policy);
        appender.setEncoder((Encoder)encoder);
        appender.start();
        return appender;
    }

    private static class LogFilter
    extends Filter<ILoggingEvent> {
        private final String packageName;
        private final LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();

        private LogFilter(String packageName) {
            this.packageName = packageName;
        }

        public FilterReply decide(ILoggingEvent event) {
            ch.qos.logback.classic.Logger logger = this.loggerContext.getLogger(this.packageName);
            if (event.getLoggerName().startsWith(this.packageName) && event.getLevel().isGreaterOrEqual(logger.getLevel())) {
                return FilterReply.ACCEPT;
            }
            return FilterReply.DENY;
        }
    }
}

