/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.hotloaded.framework.extension.log;

import com.jxdinfo.hussar.support.hotloaded.framework.extension.log.LogRegistry;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.log.SpringBootLogExtension;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.log.log4j.Log4jLogRegistry;
import com.jxdinfo.hussar.support.hotloaded.framework.extension.log.logback.LogbackLogRegistry;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.PluginRegistryInfo;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.process.pipe.PluginPipeProcessorExtend;
import com.jxdinfo.hussar.support.hotloaded.framework.utils.OrderPriority;
import com.jxdinfo.hussar.support.hotloaded.framework.utils.ResourceUtils;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;
import org.springframework.util.ObjectUtils;

class PluginLogConfigProcessor
implements PluginPipeProcessorExtend {
    private static final Logger LOG = LoggerFactory.getLogger(PluginLogConfigProcessor.class);
    private final LogRegistry logRegistry;

    public PluginLogConfigProcessor(SpringBootLogExtension.Type type) {
        this.logRegistry = type == SpringBootLogExtension.Type.LOG4J ? new Log4jLogRegistry() : (type == SpringBootLogExtension.Type.LOGBACK ? new LogbackLogRegistry() : null);
    }

    public String key() {
        return "SpringBootLogConfigProcessor";
    }

    public OrderPriority order() {
        return OrderPriority.getLowPriority();
    }

    public void initialize() throws Exception {
    }

    public void registry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        if (this.logRegistry == null) {
            return;
        }
        Resource resource = this.getLogConfigFile(pluginRegistryInfo);
        ArrayList<Resource> resources = new ArrayList<Resource>(1);
        resources.add(resource);
        this.logRegistry.registry(resources, pluginRegistryInfo);
    }

    public void unRegistry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        if (this.logRegistry == null) {
            return;
        }
        this.logRegistry.unRegistry(pluginRegistryInfo);
    }

    private Resource getLogConfigFile(PluginRegistryInfo pluginRegistryInfo) throws IOException {
        GenericApplicationContext pluginApplicationContext = pluginRegistryInfo.getPluginApplicationContext();
        String logConfigLocation = pluginApplicationContext.getEnvironment().getProperty("plugin.log-config-location");
        if (ObjectUtils.isEmpty((Object)logConfigLocation)) {
            return null;
        }
        String pluginId = pluginRegistryInfo.getPluginWrapper().getPluginId();
        String matchLocation = ResourceUtils.getMatchLocation((String)logConfigLocation);
        if (matchLocation == null || "".equals(matchLocation)) {
            LOG.warn("Plugin '{}' not match {}: {}", new Object[]{pluginId, "plugin.log-config-location", logConfigLocation});
            return null;
        }
        if (ResourceUtils.isFile((String)logConfigLocation)) {
            String absolutePath = ResourceUtils.getAbsolutePath((PluginRegistryInfo)pluginRegistryInfo, (String)matchLocation);
            return new FileSystemResource(absolutePath);
        }
        return new ClassPathResource(matchLocation, pluginRegistryInfo.getPluginClassLoader());
    }
}

