/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.hotloaded.framework.extension.feign.processor;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.PluginRegistryInfo;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.SpringBeanRegister;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.process.pipe.bean.PluginBeanRegistrarExtend;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.IntegrationConfiguration;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.annotation.AnnotatedGenericBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.boot.context.properties.bind.Bindable;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.FeignClientFactoryBean;
import org.springframework.cloud.openfeign.PluginFeignRegistrar;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.ObjectUtils;

public class FeignProcessor
implements PluginBeanRegistrarExtend {
    private static final Logger log = LoggerFactory.getLogger(FeignProcessor.class);

    public void registry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        List callerClasses = pluginRegistryInfo.getGroupClasses("feign-class-group");
        if (callerClasses == null || callerClasses.isEmpty()) {
            return;
        }
        GenericApplicationContext pluginApplicationContext = pluginRegistryInfo.getPluginApplicationContext();
        GenericApplicationContext mainApplicationContext = pluginRegistryInfo.getMainApplicationContext();
        LinkedHashSet<AnnotatedGenericBeanDefinition> candidateComponents = new LinkedHashSet<AnnotatedGenericBeanDefinition>();
        IntegrationConfiguration configuration = pluginRegistryInfo.getConfiguration();
        List jarResourceClassPackage = configuration.jarResourceClassPackage();
        Set pluginFeignServices = (Set)pluginRegistryInfo.getPluginBinder().bind("plugin.plugin-feign-service", Bindable.setOf(String.class)).orElseGet(() -> null);
        ArrayList<String> totalFeignServices = new ArrayList<String>();
        if (jarResourceClassPackage != null && jarResourceClassPackage.size() > 0) {
            totalFeignServices.addAll(jarResourceClassPackage);
        }
        if (pluginFeignServices != null && pluginFeignServices.size() > 0) {
            totalFeignServices.addAll(pluginFeignServices);
        }
        AntPathMatcher pathMatcher = new AntPathMatcher(".");
        ArrayList<Class> feginServiceMatch = new ArrayList<Class>();
        for (Class clazz : callerClasses) {
            if (!this.validateClass(clazz, totalFeignServices, pathMatcher)) continue;
            feginServiceMatch.add(clazz);
            Object beanFromApplicationContext = this.getBeanFromApplicationContext(clazz, mainApplicationContext);
            if (beanFromApplicationContext != null) continue;
            candidateComponents.add(new AnnotatedGenericBeanDefinition(clazz));
        }
        for (BeanDefinition beanDefinition : candidateComponents) {
            if (!(beanDefinition instanceof AnnotatedBeanDefinition)) continue;
            AnnotatedBeanDefinition beanDefinition2 = (AnnotatedBeanDefinition)beanDefinition;
            AnnotationMetadata annotationMetadata = beanDefinition2.getMetadata();
            Assert.isTrue((boolean)annotationMetadata.isInterface(), (String)"@FeignClient can only be specified on an interface");
            Map attributes = annotationMetadata.getAnnotationAttributes(FeignClient.class.getCanonicalName());
            String name = PluginFeignRegistrar.getClientName(attributes);
            PluginFeignRegistrar.registerClientConfiguration((BeanDefinitionRegistry)mainApplicationContext, name, attributes.get("configuration"));
            this.registerFeignClient(pluginRegistryInfo, annotationMetadata, attributes);
        }
        this.registerFeignService(pluginRegistryInfo, feginServiceMatch);
    }

    private void registerFeignClient(PluginRegistryInfo pluginRegistryInfo, AnnotationMetadata annotationMetadata, Map<String, Object> attributes) {
        GenericApplicationContext mainApplicationContext = pluginRegistryInfo.getMainApplicationContext();
        ClassLoader pluginClassLoader = pluginRegistryInfo.getPluginClassLoader();
        String className = annotationMetadata.getClassName();
        Class clazz = ClassUtils.resolveClassName((String)className, (ClassLoader)pluginClassLoader);
        ConfigurableListableBeanFactory mainBeanFactory = mainApplicationContext.getBeanFactory();
        ConfigurableListableBeanFactory beanFactory = mainBeanFactory instanceof ConfigurableBeanFactory ? mainBeanFactory : null;
        String contextId = PluginFeignRegistrar.getContextId((ConfigurableBeanFactory)beanFactory, attributes);
        String name = PluginFeignRegistrar.getName((ConfigurableBeanFactory)beanFactory, attributes);
        FeignClientFactoryBean factoryBean = new FeignClientFactoryBean();
        factoryBean.setBeanFactory((BeanFactory)beanFactory);
        factoryBean.setName(name);
        factoryBean.setContextId(contextId);
        factoryBean.setType(clazz);
        BeanDefinitionBuilder definition = BeanDefinitionBuilder.genericBeanDefinition((Class)clazz, () -> FeignProcessor.lambda$registerFeignClient$1(factoryBean, (ConfigurableBeanFactory)beanFactory, attributes));
        definition.setAutowireMode(2);
        definition.setLazyInit(true);
        PluginFeignRegistrar.validate(attributes);
        AbstractBeanDefinition beanDefinition = definition.getBeanDefinition();
        beanDefinition.setAttribute("factoryBeanObjectType", (Object)className);
        beanDefinition.setAttribute("feignClientsRegistrarFactoryBean", (Object)factoryBean);
        boolean primary = (Boolean)attributes.get("primary");
        beanDefinition.setPrimary(primary);
        Object[] qualifiers = PluginFeignRegistrar.getQualifiers(attributes);
        if (ObjectUtils.isEmpty((Object[])qualifiers)) {
            qualifiers = new String[]{contextId + "FeignClient"};
        }
        BeanDefinitionHolder holder = new BeanDefinitionHolder((BeanDefinition)beanDefinition, className, (String[])qualifiers);
        BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)holder, (BeanDefinitionRegistry)mainApplicationContext);
    }

    public void registerFeignService(PluginRegistryInfo pluginRegistryInfo, List<Class> feginServiceMatch) {
        if (feginServiceMatch == null || feginServiceMatch.isEmpty()) {
            return;
        }
        SpringBeanRegister springBeanRegister = pluginRegistryInfo.getSpringBeanRegister();
        GenericApplicationContext mainApplicationContext = pluginRegistryInfo.getMainApplicationContext();
        for (Class aClass : feginServiceMatch) {
            Object bean;
            if (aClass == null || (bean = this.getBeanFromApplicationContext(aClass, mainApplicationContext)) == null) continue;
            String beanName = this.generalBeanName(aClass);
            springBeanRegister.registerSingleton(beanName, bean);
        }
    }

    private Object getBeanFromApplicationContext(Class clz, GenericApplicationContext applicationContext) {
        if (applicationContext == null) {
            return null;
        }
        Object bean = null;
        try {
            bean = applicationContext.getBean(clz);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return bean;
    }

    private String generalBeanName(Class clz) {
        String beanClassName = clz.getName();
        String shortClassName = ClassUtils.getShortName((String)beanClassName);
        String packageName = ClassUtils.getPackageName((String)beanClassName);
        String stringBuilder = packageName + "." + shortClassName;
        return stringBuilder;
    }

    public boolean validateClass(Class clz, List<String> totalFeignServices, AntPathMatcher pathMatcher) {
        if (HussarUtils.isEmpty(totalFeignServices)) {
            return false;
        }
        boolean isMatch = totalFeignServices.stream().anyMatch(s -> pathMatcher.matchStart(s, clz.getName()));
        return isMatch;
    }

    public String key() {
        return "FeignProcessor";
    }

    private static /* synthetic */ Object lambda$registerFeignClient$1(FeignClientFactoryBean factoryBean, ConfigurableBeanFactory beanFactory, Map attributes) {
        Object fallbackFactory;
        factoryBean.setUrl(PluginFeignRegistrar.getUrl(beanFactory, attributes));
        factoryBean.setPath(PluginFeignRegistrar.getPath(beanFactory, attributes));
        factoryBean.setDecode404(Boolean.parseBoolean(String.valueOf(attributes.get("decode404"))));
        Object fallback = attributes.get("fallback");
        if (fallback != null) {
            factoryBean.setFallback(fallback instanceof Class ? (Class)fallback : ClassUtils.resolveClassName((String)fallback.toString(), null));
        }
        if ((fallbackFactory = attributes.get("fallbackFactory")) != null) {
            factoryBean.setFallbackFactory(fallbackFactory instanceof Class ? (Class)fallbackFactory : ClassUtils.resolveClassName((String)fallbackFactory.toString(), null));
        }
        return factoryBean.getObject();
    }
}

