/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.hotloaded.framework.extension.feign.resourceloader;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.PathUtil;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.PluginRegistryInfo;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.process.pipe.loader.PluginResourceLoader;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.process.pipe.loader.ResourceWrapper;
import com.jxdinfo.hussar.support.hotloaded.framework.integration.loader.archive.Archive;
import com.jxdinfo.hussar.support.hotloaded.framework.realize.BasePlugin;
import com.jxdinfo.hussar.support.hotloaded.framework.utils.OrderPriority;
import com.jxdinfo.hussar.support.hotloaded.framework.utils.ScanUtils;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.pf4j.PluginWrapper;
import org.pf4j.RuntimeMode;
import org.pf4j.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FeignPluginResourceLoader
implements PluginResourceLoader {
    private static final Logger log = LoggerFactory.getLogger(FeignPluginResourceLoader.class);
    private final String targetLibPathDev = "target/lib";
    private final String targetLibPathDeploy = "lib";
    public static final String KEY = "FeignPluginResourceClassLoader";

    public String key() {
        return KEY;
    }

    public ResourceWrapper load(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        Set<String> jarClassPackageNames;
        PluginWrapper pluginWrapper = pluginRegistryInfo.getPluginWrapper();
        RuntimeMode runtimeMode = pluginWrapper.getRuntimeMode();
        BasePlugin basePlugin = pluginRegistryInfo.getBasePlugin();
        HashSet<String> classPackageNames = new HashSet<String>();
        if (runtimeMode == RuntimeMode.DEPLOYMENT) {
            Set<String> readLibThreeJarClassPackageName = this.readLibThreeJarClassPackageName(pluginRegistryInfo);
            if (HussarUtils.isNotEmpty(readLibThreeJarClassPackageName)) {
                classPackageNames.addAll(readLibThreeJarClassPackageName);
            }
        } else if (runtimeMode == RuntimeMode.DEVELOPMENT && HussarUtils.isNotEmpty(jarClassPackageNames = this.readLibClassPackageNames(pluginRegistryInfo))) {
            classPackageNames.addAll(jarClassPackageNames);
        }
        ResourceWrapper resourceWrapper = new ResourceWrapper();
        resourceWrapper.addClassPackageNames(classPackageNames);
        return resourceWrapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> readLibThreeJarClassPackageName(PluginRegistryInfo pluginRegistryInfo) throws IOException {
        HashSet<String> classPackageNames = new HashSet<String>();
        PluginWrapper pluginWrapper = pluginRegistryInfo.getPluginWrapper();
        String pluginPath = pluginWrapper.getPluginPath().toString();
        List archives = null;
        try {
            archives = ScanUtils.scanJarByJar((String)pluginPath);
            if (HussarUtils.isEmpty((Object)archives)) {
                HashSet<String> hashSet = classPackageNames;
                return hashSet;
            }
            for (Archive archive : archives) {
                Set classPackages = ScanUtils.scanClassPackageName((Archive)archive, null);
                if (!HussarUtils.isNotEmpty((Object)classPackages)) continue;
                classPackageNames.addAll(classPackages);
            }
            HashSet<String> hashSet = classPackageNames;
            return hashSet;
        }
        finally {
            if (HussarUtils.isNotEmpty((Object)archives)) {
                for (Archive archive : archives) {
                    try {
                        archive.close();
                    }
                    catch (Exception ex) {
                        log.error("close jar archive", (Throwable)ex);
                    }
                }
            }
        }
    }

    private Set<String> readLibClassPackageNames(PluginRegistryInfo pluginRegistryInfo) throws IOException {
        Set<String> classPackageNames = new HashSet<String>();
        PluginWrapper pluginWrapper = pluginRegistryInfo.getPluginWrapper();
        Path pluginPath = pluginWrapper.getPluginPath();
        Path targetPath = Paths.get(pluginPath.toString(), "target/lib");
        if (!PathUtil.exists((Path)targetPath, (boolean)true)) {
            return classPackageNames;
        }
        List files = FileUtils.getJars((Path)targetPath);
        if (HussarUtils.isEmpty((Object)files)) {
            return classPackageNames;
        }
        classPackageNames = ScanUtils.scanClassPackageName((List)files, null);
        return classPackageNames;
    }

    public void unload(PluginRegistryInfo pluginRegistryInfo, ResourceWrapper resourceWrapper) throws Exception {
    }

    public OrderPriority order() {
        return OrderPriority.getHighPriority();
    }
}

