/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.cloud.openfeign;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanExpressionContext;
import org.springframework.beans.factory.config.BeanExpressionResolver;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.cloud.openfeign.FeignClientSpecification;
import org.springframework.core.annotation.AnnotationAttributes;
import org.springframework.core.type.AnnotationMetadata;
import org.springframework.util.Assert;
import org.springframework.util.ClassUtils;
import org.springframework.util.StringUtils;

public class PluginFeignRegistrar {
    public static void validateFallback(Class clazz) {
        Assert.isTrue((!clazz.isInterface() ? 1 : 0) != 0, (String)"Fallback class must implement the interface annotated by @FeignClient");
    }

    public static void validateFallbackFactory(Class clazz) {
        Assert.isTrue((!clazz.isInterface() ? 1 : 0) != 0, (String)"Fallback factory must produce instances of fallback classes that implement the interface annotated by @FeignClient");
    }

    public static String getName(String name) {
        if (!StringUtils.hasText((String)name)) {
            return "";
        }
        String host = null;
        try {
            String url = !name.startsWith("http://") && !name.startsWith("https://") ? "http://" + name : name;
            host = new URI(url).getHost();
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        Assert.state((host != null ? 1 : 0) != 0, (String)("Service id not legal hostname (" + name + ")"));
        return name;
    }

    public static String getUrl(String url) {
        if (!(!StringUtils.hasText((String)url) || url.startsWith("#{") && url.contains("}"))) {
            if (!url.contains("://")) {
                url = "http://" + url;
            }
            try {
                new URL(url);
            }
            catch (MalformedURLException e) {
                throw new IllegalArgumentException(url + " is malformed", e);
            }
        }
        return url;
    }

    public static String getPath(String path) {
        if (StringUtils.hasText((String)path)) {
            if (!(path = path.trim()).startsWith("/")) {
                path = "/" + path;
            }
            if (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
        }
        return path;
    }

    public static void validate(Map<String, Object> attributes) {
        AnnotationAttributes annotation = AnnotationAttributes.fromMap(attributes);
        PluginFeignRegistrar.validateFallback(annotation.getClass("fallback"));
        PluginFeignRegistrar.validateFallbackFactory(annotation.getClass("fallbackFactory"));
    }

    public static String getName(Map<String, Object> attributes) {
        return PluginFeignRegistrar.getName(null, attributes);
    }

    public static String getName(ConfigurableBeanFactory beanFactory, Map<String, Object> attributes) {
        String name = (String)attributes.get("serviceId");
        if (!StringUtils.hasText((String)name)) {
            name = (String)attributes.get("name");
        }
        if (!StringUtils.hasText((String)name)) {
            name = (String)attributes.get("value");
        }
        name = PluginFeignRegistrar.resolve(beanFactory, name);
        return PluginFeignRegistrar.getName(name);
    }

    public static String getContextId(ConfigurableBeanFactory beanFactory, Map<String, Object> attributes) {
        String contextId = (String)attributes.get("contextId");
        if (!StringUtils.hasText((String)contextId)) {
            return PluginFeignRegistrar.getName(beanFactory, attributes);
        }
        contextId = PluginFeignRegistrar.resolve(beanFactory, contextId);
        return PluginFeignRegistrar.getName(contextId);
    }

    private static String resolve(ConfigurableBeanFactory beanFactory, String value) {
        if (StringUtils.hasText((String)value)) {
            BeanExpressionResolver resolver = beanFactory.getBeanExpressionResolver();
            String resolved = beanFactory.resolveEmbeddedValue(value);
            if (resolver == null) {
                return resolved;
            }
            return String.valueOf(resolver.evaluate(resolved, new BeanExpressionContext(beanFactory, null)));
        }
        return value;
    }

    public static String getUrl(ConfigurableBeanFactory beanFactory, Map<String, Object> attributes) {
        String url = PluginFeignRegistrar.resolve(beanFactory, (String)attributes.get("url"));
        return PluginFeignRegistrar.getUrl(url);
    }

    public static String getPath(ConfigurableBeanFactory beanFactory, Map<String, Object> attributes) {
        String path = PluginFeignRegistrar.resolve(beanFactory, (String)attributes.get("path"));
        return PluginFeignRegistrar.getPath(path);
    }

    protected Set<String> getBasePackages(AnnotationMetadata importingClassMetadata) {
        Map attributes = importingClassMetadata.getAnnotationAttributes(EnableFeignClients.class.getCanonicalName());
        HashSet<String> basePackages = new HashSet<String>();
        for (String pkg : (String[])attributes.get("value")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (String pkg : (String[])attributes.get("basePackages")) {
            if (!StringUtils.hasText((String)pkg)) continue;
            basePackages.add(pkg);
        }
        for (Class clazz : (Class[])attributes.get("basePackageClasses")) {
            basePackages.add(ClassUtils.getPackageName((Class)clazz));
        }
        if (basePackages.isEmpty()) {
            basePackages.add(ClassUtils.getPackageName((String)importingClassMetadata.getClassName()));
        }
        return basePackages;
    }

    public static String getQualifier(Map<String, Object> client) {
        if (client == null) {
            return null;
        }
        String qualifier = (String)client.get("qualifier");
        if (StringUtils.hasText((String)qualifier)) {
            return qualifier;
        }
        return null;
    }

    public static String[] getQualifiers(Map<String, Object> client) {
        if (client == null) {
            return null;
        }
        List<String> qualifierList = new ArrayList<String>(Arrays.asList((String[])client.get("qualifiers")));
        qualifierList.removeIf(qualifier -> !StringUtils.hasText((String)qualifier));
        if (qualifierList.isEmpty() && PluginFeignRegistrar.getQualifier(client) != null) {
            qualifierList = Collections.singletonList(PluginFeignRegistrar.getQualifier(client));
        }
        return !qualifierList.isEmpty() ? qualifierList.toArray(new String[0]) : null;
    }

    public static String getClientName(Map<String, Object> client) {
        if (client == null) {
            return null;
        }
        String value = (String)client.get("contextId");
        if (!StringUtils.hasText((String)value)) {
            value = (String)client.get("value");
        }
        if (!StringUtils.hasText((String)value)) {
            value = (String)client.get("name");
        }
        if (!StringUtils.hasText((String)value)) {
            value = (String)client.get("serviceId");
        }
        if (StringUtils.hasText((String)value)) {
            return value;
        }
        throw new IllegalStateException("Either 'name' or 'value' must be provided in @" + FeignClient.class.getSimpleName());
    }

    public static void registerClientConfiguration(BeanDefinitionRegistry registry, Object name, Object configuration) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(FeignClientSpecification.class);
        builder.addConstructorArgValue(name);
        builder.addConstructorArgValue(configuration);
        registry.registerBeanDefinition(name + "." + FeignClientSpecification.class.getSimpleName(), (BeanDefinition)builder.getBeanDefinition());
    }
}

