/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.hotloaded.framework.extension.feign.processor;

import com.jxdinfo.hussar.support.hotloaded.framework.extension.feign.group.FeignClassGroup;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.PluginRegistryInfo;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.process.pipe.PluginPreProcessorExtend;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.process.pipe.classs.PluginClassGroup;
import com.jxdinfo.hussar.support.hotloaded.framework.factory.process.pipe.loader.ResourceWrapper;
import com.jxdinfo.hussar.support.hotloaded.framework.realize.BasePlugin;
import com.jxdinfo.hussar.support.hotloaded.framework.utils.OrderPriority;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

public class FeignPrePipeProcessor
implements PluginPreProcessorExtend {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final List<FeignClassGroup> feignClassGroups = new ArrayList<FeignClassGroup>();
    private static final String OTHER = "other";

    public void initialize() throws Exception {
        this.feignClassGroups.add(new FeignClassGroup());
    }

    public void registry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        BasePlugin basePlugin = pluginRegistryInfo.getBasePlugin();
        ResourceWrapper resourceWrapper = pluginRegistryInfo.getPluginLoadResource("FeignPluginResourceClassLoader");
        if (resourceWrapper == null) {
            return;
        }
        List pluginResources = resourceWrapper.getResources();
        if (pluginResources == null) {
            return;
        }
        for (PluginClassGroup pluginClassGroup : this.feignClassGroups) {
            try {
                pluginClassGroup.initialize(basePlugin);
            }
            catch (Exception e) {
                this.log.error("PluginClassGroup {} initialize exception. {}", new Object[]{pluginClassGroup.getClass(), e.getMessage(), e});
            }
        }
        Set classPackageNames = resourceWrapper.getClassPackageNames();
        ClassLoader classLoader = basePlugin.getWrapper().getPluginClassLoader();
        for (String classPackageName : classPackageNames) {
            Class<?> aClass = Class.forName(classPackageName, false, classLoader);
            if (aClass == null) continue;
            for (PluginClassGroup pluginClassGroup : this.feignClassGroups) {
                if (pluginClassGroup == null || StringUtils.isEmpty((Object)pluginClassGroup.groupId()) || !pluginClassGroup.filter(aClass)) continue;
                pluginRegistryInfo.addGroupClasses(pluginClassGroup.groupId(), aClass);
            }
            pluginRegistryInfo.addClasses(aClass);
        }
    }

    public void unRegistry(PluginRegistryInfo pluginRegistryInfo) throws Exception {
        pluginRegistryInfo.cleanClasses();
    }

    public String key() {
        return "feignpipeProcessor";
    }

    public OrderPriority order() {
        return OrderPriority.getLowPriority();
    }
}

