/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.expansion.config;

import com.baomidou.mybatisplus.autoconfigure.ConfigurationCustomizer;
import com.jxdinfo.hussar.support.exception.mvc.support.HussarHandlerMethodArgumentResolverCustomizers;
import com.jxdinfo.hussar.support.exception.mvc.support.HussarHandlerMethodReturnValueHandlerCustomizers;
import com.jxdinfo.hussar.support.expansion.core.aspect.ExpansionAdvisor;
import com.jxdinfo.hussar.support.expansion.core.aspect.ExpansionAspectInterceptor;
import com.jxdinfo.hussar.support.expansion.core.aspect.impl.DefaultExpansionMethodAspectService;
import com.jxdinfo.hussar.support.expansion.core.aspect.impl.DefaultExpansionModelIdAspectService;
import com.jxdinfo.hussar.support.expansion.core.config.HussarExpansionModelInfoProperties;
import com.jxdinfo.hussar.support.expansion.core.config.HussarExpansionProperties;
import com.jxdinfo.hussar.support.expansion.core.service.ExpansionColumnInfoService;
import com.jxdinfo.hussar.support.expansion.core.service.ExpansionMethodAspectService;
import com.jxdinfo.hussar.support.expansion.core.service.ExpansionSuperQueryColumnService;
import com.jxdinfo.hussar.support.expansion.plugin.mvc.RequestMappingHandlerAdapterWebMvcRegistrations;
import com.jxdinfo.hussar.support.expansion.plugin.mvc.customizers.ExpansionHandlerMethodArgumentResolverCustomizers;
import com.jxdinfo.hussar.support.expansion.plugin.mvc.customizers.ExpansionHandlerMethodReturnValueHandlerCustomizers;
import com.jxdinfo.hussar.support.expansion.plugin.mvc.customizers.ExpansionJackson2ObjectMapperBuilderCustomizer;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.customizer.ExpansionMybatisPluginConfigurationCustomizer;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.customizer.ExpansionMybatisPlusInterceptorCustomizer;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.DefaultExpansionColumnInfoService;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.DefaultExpansionSuperQueryColumnService;
import com.jxdinfo.hussar.support.mp.customizer.MybatisPlusInterceptorCustomizer;
import java.util.List;
import java.util.Optional;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Advisor;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jackson.Jackson2ObjectMapperBuilderCustomizer;
import org.springframework.boot.autoconfigure.web.servlet.WebMvcRegistrations;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;

@Configuration
@EnableConfigurationProperties(value={HussarExpansionProperties.class, HussarExpansionModelInfoProperties.class})
@ConditionalOnProperty(prefix="hussar.expansion", name={"enable"}, havingValue="true", matchIfMissing=false)
public class HussarExpansionConfiguration {
    private HussarExpansionProperties hussarExpansionProperties;
    private HussarExpansionModelInfoProperties hussarExpansionModelInfoProperties;

    public HussarExpansionConfiguration(HussarExpansionProperties hussarExpansionProperties, HussarExpansionModelInfoProperties hussarExpansionModelInfoProperties) {
        this.hussarExpansionProperties = hussarExpansionProperties;
        this.hussarExpansionModelInfoProperties = hussarExpansionModelInfoProperties;
    }

    @Bean
    public HussarHandlerMethodArgumentResolverCustomizers expansionHussarHandlerMethodArgumentResolverCustomizers() {
        return new ExpansionHandlerMethodArgumentResolverCustomizers();
    }

    @Bean
    public HussarHandlerMethodReturnValueHandlerCustomizers expansionHandlerMethodArgumentResolverCustomizers() {
        return new ExpansionHandlerMethodReturnValueHandlerCustomizers();
    }

    @Bean
    public WebMvcRegistrations requestMappingHandlerAdapterWebMvcRegistrations() {
        return new RequestMappingHandlerAdapterWebMvcRegistrations(this.hussarExpansionProperties);
    }

    @Bean
    public Jackson2ObjectMapperBuilderCustomizer expansionJackson2ObjectMapperBuilderCustomizer() {
        return new ExpansionJackson2ObjectMapperBuilderCustomizer(this.hussarExpansionProperties);
    }

    @Bean
    public ExpansionColumnInfoService defaultExpansionColumnInfoService(HussarExpansionModelInfoProperties hussarExpansionModelInfoProperties) {
        return new DefaultExpansionColumnInfoService(hussarExpansionModelInfoProperties);
    }

    @Bean
    public ExpansionSuperQueryColumnService defaultExpansionSuperQueryColumnService() {
        return new DefaultExpansionSuperQueryColumnService();
    }

    @Bean
    @Order(value=10)
    public MybatisPlusInterceptorCustomizer expansionMybatisPlusInterceptorCustomizer(HussarExpansionProperties hussarExpansionProperties, ExpansionColumnInfoService defaultExpansionColumnInfoService) {
        return new ExpansionMybatisPlusInterceptorCustomizer(hussarExpansionProperties, defaultExpansionColumnInfoService);
    }

    @Bean
    public ExpansionMethodAspectService defaultExpansionMethodAspectService(ExpansionColumnInfoService defaultExpansionColumnInfoService) {
        return new DefaultExpansionMethodAspectService(defaultExpansionColumnInfoService);
    }

    @Bean
    public ExpansionMethodAspectService defaultExpansionModelIdAspectService() {
        return new DefaultExpansionModelIdAspectService();
    }

    @Bean
    public Advisor expansionAnnotationAdvisor(ExpansionColumnInfoService defaultExpansionColumnInfoService, Optional<List<ExpansionMethodAspectService>> optionalExpansionMethodAspectServiceList) {
        ExpansionAspectInterceptor expansionAspectInterceptor = new ExpansionAspectInterceptor(defaultExpansionColumnInfoService, optionalExpansionMethodAspectServiceList);
        ExpansionAdvisor expansionAdvisor = new ExpansionAdvisor((Advice)expansionAspectInterceptor);
        return expansionAdvisor;
    }

    @Bean
    public ConfigurationCustomizer expansionMybatisPluginConfigurationCustomizer() {
        return new ExpansionMybatisPluginConfigurationCustomizer();
    }
}

