/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.service;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.expansion.core.context.ExpansionContextHolder;
import com.jxdinfo.hussar.support.expansion.core.enums.ExpansionPositionTypeEnum;
import com.jxdinfo.hussar.support.expansion.core.service.ExpansionColumnInfoService;
import com.jxdinfo.hussar.support.expansion.core.service.dto.ExpansionExtensionTableServiceDto;
import com.jxdinfo.hussar.support.expansion.core.service.dto.ExpansionTableFieldInfoVo;
import com.jxdinfo.hussar.support.expansion.core.service.dto.ExpansionTableVo;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.dto.ExpansionServiceDto;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.context.ExpansionMybatisContextHolder;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.context.ExpansionMybatisPlusContext;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.AbstractExtensionTableLogic;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.ExpansionJoinSQLDto;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.ExpansionParameterMappingDto;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.ExpansionSQLDto;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.ExpansionSQLVo;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.FieldLogicInfo;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.JoinTableInfo;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.ParameterMappingKeyValueVo;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.ParameterMappingVo;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.param.ColumnExpressionDto;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.param.SelectExpansionParameterMappingDto;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.param.SelectExpansionSQLVo;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.visitor.ExpansionTableVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandler;

public class SelectExtensionTableLogic
extends AbstractExtensionTableLogic {
    public SelectExtensionTableLogic() {
        this.MAP_KEY_LIST.add(ExpansionPositionTypeEnum.SELECT_COLUMNS.getType());
        this.MAP_KEY_LIST.add(ExpansionPositionTypeEnum.SELECT_WHERE.getType());
    }

    @Override
    public boolean support(Statement statement, Object obj) {
        if (HussarUtils.isEmpty((Object)obj) || !(obj instanceof ExpansionServiceDto) || HussarUtils.isEmpty((Object)ExpansionContextHolder.get())) {
            return false;
        }
        Select select = (Select)statement;
        SelectBody selectBody = select.getSelectBody();
        if (!(selectBody instanceof PlainSelect)) {
            return false;
        }
        try {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            FromItem fromItem = plainSelect.getFromItem();
            if (!(fromItem instanceof Table)) {
                return false;
            }
            boolean b = this.isSelectCountSql(plainSelect);
            if (b) {
                return true;
            }
            Alias alias = fromItem.getAlias();
            if (HussarUtils.isNotEmpty((Object)alias) && HussarUtils.isNotEmpty((Object)alias.getName())) {
                return true;
            }
        }
        catch (Exception e) {
            return false;
        }
        return false;
    }

    @Override
    public List<? extends ExpansionTableFieldInfoVo> expansionGetTableConfigInfo(Statement statement, ExpansionColumnInfoService expansionColumnInfoService) {
        ExpansionTableVisitor expansionTableVisitor = new ExpansionTableVisitor();
        List<Table> tableList = expansionTableVisitor.getTableList(statement);
        if (HussarUtils.isEmpty(tableList)) {
            return null;
        }
        String moduleId = ExpansionContextHolder.get();
        ArrayList<ExpansionTableVo> tableInfos = new ArrayList<ExpansionTableVo>();
        ExpansionTableVo expansionTableVo = null;
        for (Table table : tableList) {
            String aliasName = table.getAlias().getName();
            String tableName = table.getName();
            expansionTableVo = new ExpansionTableVo(aliasName, tableName);
            tableInfos.add(expansionTableVo);
        }
        ExpansionExtensionTableServiceDto expansionExtensionTableServiceDto = new ExpansionExtensionTableServiceDto(moduleId, tableInfos);
        List expansionExtensionTableInfos = expansionColumnInfoService.getExpansionExtensionTableInfo(expansionExtensionTableServiceDto);
        return expansionExtensionTableInfos;
    }

    @Override
    public ExpansionSQLVo expandSqlService(ExpansionSQLDto expansionSQLDto) {
        HashMap<String, List<FieldLogicInfo>> actualMapField = new HashMap<String, List<FieldLogicInfo>>();
        Map<String, List<FieldLogicInfo>> returnMapField = expansionSQLDto.getReturnMapField();
        Statement statement = expansionSQLDto.getStatement();
        ExpansionMybatisPlusContext expansionMybatisPlusContext = expansionSQLDto.getExpansionMybatisPlusContext();
        Select select = (Select)statement;
        PlainSelect plainSelect = (PlainSelect)select.getSelectBody(PlainSelect.class);
        List selectItems = plainSelect.getSelectItems();
        Expression where = plainSelect.getWhere();
        Set<Object> whereJdbcParameterSet = null;
        HashSet<Column> whereColumnName = null;
        if (HussarUtils.isEmpty((Object)where)) {
            whereJdbcParameterSet = new HashSet();
            whereColumnName = new HashSet();
        } else {
            whereJdbcParameterSet = this.getWhereJdbcParameter(where);
            whereColumnName = this.getWhereColumnName(where);
        }
        List<FieldLogicInfo> whereFieldLoginInfoList = returnMapField.get(ExpansionPositionTypeEnum.SELECT_WHERE.getType());
        ArrayList<ColumnExpressionDto> addWhereList = new ArrayList<ColumnExpressionDto>();
        if (HussarUtils.isNotEmpty(whereFieldLoginInfoList)) {
            ArrayList<FieldLogicInfo> whereActualFieldLogicList = new ArrayList<FieldLogicInfo>();
            actualMapField.put(ExpansionPositionTypeEnum.SELECT_WHERE.getType(), whereActualFieldLogicList);
            int whereIndex = whereJdbcParameterSet.size();
            for (FieldLogicInfo info : whereFieldLoginInfoList) {
                expansionMybatisPlusContext.convert(info);
                boolean b = this.existWhereItem(whereColumnName, info);
                if (b || HussarUtils.isEmpty((Object)info.getValue())) continue;
                Column column = new Column(info.getColumnName());
                Expression expression = this.getConditionByFieldInfo(info, ++whereIndex);
                ColumnExpressionDto columnExpressionDto = new ColumnExpressionDto(info.getTableName(), info.getTableAlias(), column, expression, info.getPropertyName(), ExpansionPositionTypeEnum.SELECT_WHERE.getType(), whereIndex);
                addWhereList.add(columnExpressionDto);
                whereActualFieldLogicList.add(info);
            }
        }
        ExpansionJoinSQLDto expansionJoinSQLDto = (ExpansionJoinSQLDto)expansionSQLDto;
        boolean joinTableHandlerEnable = this.expansionJoinTableHandler(statement, expansionJoinSQLDto.getJoinTableInfos(), addWhereList);
        Map<String, FieldLogicInfo> propertyCloumnMap = null;
        if (joinTableHandlerEnable) {
            propertyCloumnMap = this.expansionSelectItem(returnMapField, selectItems);
        }
        SelectExpansionSQLVo expansionSQLVo = new SelectExpansionSQLVo();
        expansionSQLVo.setActualFieldLogicInfoMap(actualMapField);
        expansionSQLVo.setAddWhereList(addWhereList);
        ExpansionMybatisContextHolder.set(propertyCloumnMap);
        return expansionSQLVo;
    }

    @Override
    public ParameterMappingVo expandParameterMappingService(ExpansionParameterMappingDto expansionParameterMappingDto) {
        if (HussarUtils.isEmpty((Object)expansionParameterMappingDto) || HussarUtils.isEmpty(expansionParameterMappingDto.getActualFieldLogicInfoMap()) || HussarUtils.isEmpty(expansionParameterMappingDto.getParameterMappingList())) {
            return null;
        }
        String expansionMapPropertyName = expansionParameterMappingDto.getExpansionMapPropertyName();
        Map<String, List<FieldLogicInfo>> actualFieldLogicInfoMap = expansionParameterMappingDto.getActualFieldLogicInfoMap();
        List<ParameterMapping> parameterMappingList = expansionParameterMappingDto.getParameterMappingList();
        SelectExpansionParameterMappingDto selectExpansionParameterMappingDto = (SelectExpansionParameterMappingDto)expansionParameterMappingDto;
        ExpansionMybatisPlusContext expansionMybatisPlusContext = expansionParameterMappingDto.getExpansionMybatisPlusContext();
        List<ColumnExpressionDto> addWhereList = selectExpansionParameterMappingDto.getAddWhereList();
        Configuration mybatisConfiguration = expansionMybatisPlusContext.getConfiguration();
        List<ParameterMappingKeyValueVo> parameterMappingKeyValueVos = this.getParameterMappingKey(expansionMybatisPlusContext, actualFieldLogicInfoMap, expansionMapPropertyName);
        if (HussarUtils.isEmpty(parameterMappingKeyValueVos)) {
            return null;
        }
        if (HussarUtils.isNotEmpty(addWhereList)) {
            for (ColumnExpressionDto columnExpressionDto : addWhereList) {
                Optional<ParameterMappingKeyValueVo> first = parameterMappingKeyValueVos.stream().filter(pkv -> pkv.getPropertyName().equalsIgnoreCase(columnExpressionDto.getPropertyName()) && pkv.getPositionType().equalsIgnoreCase(columnExpressionDto.getPositionType())).findFirst();
                if (!first.isPresent()) continue;
                ParameterMappingKeyValueVo parameterMappingKeyValueVo = first.get();
                Optional<ParameterMapping> optionalColumn = parameterMappingList.stream().filter(pm -> pm.getProperty().equalsIgnoreCase(parameterMappingKeyValueVo.getParameterMappingKey())).findAny();
                if (optionalColumn.isPresent()) continue;
                TypeHandler typeHandler = expansionMybatisPlusContext.getTypeHandler(parameterMappingKeyValueVo);
                ParameterMapping.Builder builder = new ParameterMapping.Builder(mybatisConfiguration, parameterMappingKeyValueVo.getParameterMappingKey(), typeHandler);
                int index = columnExpressionDto.getIndex();
                if (index - 1 > parameterMappingList.size()) {
                    parameterMappingList.add(builder.build());
                    continue;
                }
                parameterMappingList.add(index - 1, builder.build());
            }
        }
        ParameterMappingVo parameterMappingVo = new ParameterMappingVo();
        parameterMappingVo.setParameterMappingList(parameterMappingList);
        parameterMappingVo.setParameterMappingKeyValueVoList(parameterMappingKeyValueVos);
        return parameterMappingVo;
    }

    @Override
    public boolean expandChangeSqlAndParameterMappingForBoundSql(ExpansionSQLVo expansionSQLVo, ParameterMappingVo parameterMappingVo, Statement statement, ExpansionMybatisPlusContext expansionMybatisPlusContext) {
        boolean flag = false;
        Select select = (Select)statement;
        SelectBody selectBody = select.getSelectBody();
        PlainSelect plainSelect = (PlainSelect)selectBody;
        SelectExpansionSQLVo selectExpansionSQLVo = (SelectExpansionSQLVo)expansionSQLVo;
        if (HussarUtils.isNotEmpty((Object)parameterMappingVo) && HussarUtils.isNotEmpty(parameterMappingVo.getParameterMappingList()) && HussarUtils.isNotEmpty(parameterMappingVo.getParameterMappingKeyValueVoList())) {
            List<ColumnExpressionDto> addWhereList = selectExpansionSQLVo.getAddWhereList();
            if (HussarUtils.isNotEmpty(addWhereList)) {
                for (ColumnExpressionDto columnExpressionDto : addWhereList) {
                    AndExpression andExpression = new AndExpression(plainSelect.getWhere(), columnExpressionDto.getExpression());
                    plainSelect.setWhere((Expression)andExpression);
                }
            }
            flag = expansionMybatisPlusContext.changeBoundSql(parameterMappingVo);
        }
        expansionMybatisPlusContext.changeBoundSql(statement);
        return flag;
    }

    private boolean expansionJoinTableHandler(Statement statement, List<JoinTableInfo> joinTableInfos, List<ColumnExpressionDto> addWhereList) {
        Select select = (Select)statement;
        SelectBody selectBody = select.getSelectBody();
        PlainSelect plainSelect = (PlainSelect)selectBody;
        boolean selectCountSql = this.isSelectCountSql(plainSelect);
        if (selectCountSql) {
            List<JoinTableInfo> countSqlJoinTableList = this.countSqlJoinTableByWhere(joinTableInfos, plainSelect, addWhereList);
            if (HussarUtils.isEmpty(countSqlJoinTableList)) {
                return false;
            }
            joinTableInfos = countSqlJoinTableList;
        }
        ArrayList<Join> joinList = plainSelect.getJoins();
        if (HussarUtils.isEmpty(joinTableInfos)) {
            return false;
        }
        if (HussarUtils.isEmpty((Object)joinList)) {
            joinList = new ArrayList<Join>();
        }
        Join join = null;
        Column leftColumn = null;
        Column rightColumn = null;
        for (JoinTableInfo joinTableInfo : joinTableInfos) {
            leftColumn = new Column(joinTableInfo.getMasterTablePrimaryColumn()).withTable(new Table().withAlias(new Alias(joinTableInfo.getMastertTableAlias())));
            rightColumn = new Column(joinTableInfo.getExpansionTableForeignColumn()).withTable(new Table().withAlias(new Alias(joinTableInfo.getExpansionTableAlias())));
            join = new Join();
            join.withLeft(true).withRightItem((FromItem)new Table(joinTableInfo.getExpansionTableName()).withAlias(new Alias(joinTableInfo.getExpansionTableAlias()))).addOnExpression((Expression)new EqualsTo((Expression)leftColumn, (Expression)rightColumn));
            joinList.add(join);
        }
        plainSelect.setJoins(joinList);
        return true;
    }

    private boolean isSelectCountSql(PlainSelect plainSelect) {
        SelectExpressionItem item;
        String countSql;
        SelectItem selectItem;
        List selectItems = plainSelect.getSelectItems();
        return selectItems.size() == 1 && (selectItem = (SelectItem)selectItems.get(0)) instanceof SelectExpressionItem && (countSql = (item = (SelectExpressionItem)selectItem).getExpression().toString()).equalsIgnoreCase("COUNT(*)") && HussarUtils.isNotEmpty((Object)plainSelect.getFromItem().getAlias());
    }

    private List<JoinTableInfo> countSqlJoinTableByWhere(List<JoinTableInfo> joinTableInfos, PlainSelect plainSelect, List<ColumnExpressionDto> addWhereList) {
        if (HussarUtils.isEmpty(joinTableInfos)) {
            return null;
        }
        ArrayList<JoinTableInfo> returnJoinTableInfoList = new ArrayList<JoinTableInfo>();
        String whereS = Optional.ofNullable(plainSelect.getWhere()).map(Object::toString).orElse("");
        for (JoinTableInfo jti : joinTableInfos) {
            Optional<ColumnExpressionDto> first = addWhereList.stream().filter(addwhere -> addwhere.getTableAlias().equalsIgnoreCase(jti.getExpansionTableAlias())).findFirst();
            if (!whereS.contains(jti.getExpansionTableAlias() + ".") && !first.isPresent() || returnJoinTableInfoList.contains(jti)) continue;
            returnJoinTableInfoList.add(jti);
        }
        return returnJoinTableInfoList;
    }

    static {
        POSITION_TYPE_LIST.add(ExpansionPositionTypeEnum.SELECT_COLUMNS.getType());
        POSITION_TYPE_LIST.add(ExpansionPositionTypeEnum.SELECT_WHERE.getType());
        POSITION_TYPE_LIST.add(ExpansionPositionTypeEnum.SELECT_COLUMNS_WHERE.getType());
        POSITION_TYPE_LIST.add(ExpansionPositionTypeEnum.ALL.getType());
    }
}

