/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.expansion.plugin.mybatis.support;

import com.google.common.collect.Lists;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.expansion.core.config.ExpansionExtensionFieldConfigInfo;
import com.jxdinfo.hussar.support.expansion.core.config.ExpansionExtensionTableConfigInfo;
import com.jxdinfo.hussar.support.expansion.core.config.ExpansionFieldConfigInfo;
import com.jxdinfo.hussar.support.expansion.core.config.ExpansionMethodConfigInfo;
import com.jxdinfo.hussar.support.expansion.core.config.ExpansionTableConfigInfo;
import com.jxdinfo.hussar.support.expansion.core.config.HussarExpansionModelInfoProperties;
import com.jxdinfo.hussar.support.expansion.core.service.ExpansionColumnInfoService;
import com.jxdinfo.hussar.support.expansion.core.service.dto.ExpansionColumnInfoServiceVo;
import com.jxdinfo.hussar.support.expansion.core.service.dto.ExpansionExtensionTableInfo;
import com.jxdinfo.hussar.support.expansion.core.service.dto.ExpansionExtensionTableServiceDto;
import com.jxdinfo.hussar.support.expansion.core.service.dto.ExpansionTableColumnsInfo;
import com.jxdinfo.hussar.support.expansion.core.service.dto.ExpansionTableVo;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class DefaultExpansionColumnInfoService
implements ExpansionColumnInfoService {
    private final HussarExpansionModelInfoProperties hussarExpansionModelInfoProperties;

    public DefaultExpansionColumnInfoService(HussarExpansionModelInfoProperties hussarExpansionModelInfoProperties) {
        this.hussarExpansionModelInfoProperties = hussarExpansionModelInfoProperties;
    }

    public List<ExpansionTableColumnsInfo> getExpansionColumnInfo(ExpansionColumnInfoServiceVo expansionColumnInfoServiceVo) {
        if (HussarUtils.isEmpty((Object)this.hussarExpansionModelInfoProperties) || HussarUtils.isEmpty((Object)expansionColumnInfoServiceVo) || HussarUtils.isEmpty((Object)expansionColumnInfoServiceVo.getTableInfos()) || HussarUtils.isEmpty((Object)expansionColumnInfoServiceVo.getModelId())) {
            return null;
        }
        List tableInfos = expansionColumnInfoServiceVo.getTableInfos();
        String modelId = expansionColumnInfoServiceVo.getModelId();
        Map tableExpansionColumnInfo = this.hussarExpansionModelInfoProperties.getTableExpansionColumnInfo();
        if (HussarUtils.isEmpty((Object)tableExpansionColumnInfo)) {
            return null;
        }
        List expansionTableConfigInfos = (List)tableExpansionColumnInfo.get(modelId);
        ArrayList<ExpansionTableColumnsInfo> returnExpansionTableColumnsInfoList = new ArrayList<ExpansionTableColumnsInfo>();
        for (ExpansionTableVo tableInfo : tableInfos) {
            List expansionTableColumnsInfoList = this.getExpansionTableInfoByTableName(tableInfo, expansionTableConfigInfos);
            if (HussarUtils.isEmpty((Object)expansionTableColumnsInfoList)) continue;
            returnExpansionTableColumnsInfoList.addAll(expansionTableColumnsInfoList);
        }
        return returnExpansionTableColumnsInfoList;
    }

    public ExpansionTableColumnsInfo getSuperQueryColumnService(String modelId, String propertyName, boolean enableAlias) {
        if (HussarUtils.isEmpty((Object)this.hussarExpansionModelInfoProperties) || HussarUtils.isEmpty((Object)propertyName) || HussarUtils.isEmpty((Object)modelId)) {
            return null;
        }
        Map tableExpansionColumnInfo = this.hussarExpansionModelInfoProperties.getTableExpansionColumnInfo();
        Map extensionTableConfigInfoMap = this.hussarExpansionModelInfoProperties.getTableExpansionSlaveTableInfos();
        if (HussarUtils.isEmpty((Object)tableExpansionColumnInfo) && HussarUtils.isEmpty((Object)extensionTableConfigInfoMap)) {
            return null;
        }
        ArrayList expansionTableConfigInfos = HussarUtils.isNotEmpty((Object)tableExpansionColumnInfo) ? (List)tableExpansionColumnInfo.get(modelId) : Lists.newArrayListWithCapacity((int)0);
        ArrayList extensionTableConfigInfos = HussarUtils.isNotEmpty((Object)extensionTableConfigInfoMap) ? (List)extensionTableConfigInfoMap.get(modelId) : Lists.newArrayListWithCapacity((int)0);
        ArrayList allExpansionTableInfos = Lists.newArrayListWithCapacity((int)5);
        if (HussarUtils.isNotEmpty((Object)expansionTableConfigInfos)) {
            allExpansionTableInfos.addAll(expansionTableConfigInfos);
        }
        if (HussarUtils.isNotEmpty((Object)extensionTableConfigInfos)) {
            allExpansionTableInfos.addAll(this.convertToExpansionTableConfigList(extensionTableConfigInfos));
        }
        ExpansionTableColumnsInfo expansionTableColumnsInfo = this.doGetSuperQueryExpansionColums(allExpansionTableInfos, propertyName, enableAlias);
        return expansionTableColumnsInfo;
    }

    private List<ExpansionTableConfigInfo> convertToExpansionTableConfigList(List<ExpansionExtensionTableConfigInfo> extensionTableConfigInfos) {
        ArrayList expansionTableConfigInfos = Lists.newArrayListWithCapacity((int)extensionTableConfigInfos.size());
        for (ExpansionExtensionTableConfigInfo extensionTableConfigInfo : extensionTableConfigInfos) {
            if (HussarUtils.isEmpty((Object)extensionTableConfigInfo.getFields())) continue;
            ExpansionTableConfigInfo expansionTableConfigInfo = new ExpansionTableConfigInfo();
            expansionTableConfigInfo.setModelName(extensionTableConfigInfo.getModelName());
            expansionTableConfigInfo.setTableName(extensionTableConfigInfo.getTableName());
            expansionTableConfigInfo.setAlias(extensionTableConfigInfo.getAlias());
            expansionTableConfigInfo.setType(extensionTableConfigInfo.getType());
            expansionTableConfigInfo.setFields(this.convertToExpansionFieldConfigInfo(extensionTableConfigInfo.getFields()));
            expansionTableConfigInfos.add(expansionTableConfigInfo);
        }
        return expansionTableConfigInfos;
    }

    private List<ExpansionFieldConfigInfo> convertToExpansionFieldConfigInfo(List<ExpansionExtensionFieldConfigInfo> fields) {
        ArrayList expansionFieldConfigInfos = Lists.newArrayListWithCapacity((int)fields.size());
        for (ExpansionExtensionFieldConfigInfo fieldConfigInfo : fields) {
            ExpansionFieldConfigInfo expansionFieldConfigInfo = new ExpansionFieldConfigInfo();
            expansionFieldConfigInfo.setTableName(fieldConfigInfo.getTableName());
            expansionFieldConfigInfo.setColumnName(fieldConfigInfo.getColumnName());
            expansionFieldConfigInfo.setColumnAlias(fieldConfigInfo.getColumnAlias());
            expansionFieldConfigInfo.setColumnType(fieldConfigInfo.getColumnType());
            expansionFieldConfigInfo.setEscape(fieldConfigInfo.getEscape());
            expansionFieldConfigInfo.setExcludeInfos(fieldConfigInfo.getExcludeInfos());
            expansionFieldConfigInfo.setOptType(fieldConfigInfo.getOptType());
            expansionFieldConfigInfo.setPositionType(fieldConfigInfo.getPositionType());
            expansionFieldConfigInfo.setPropertyName(fieldConfigInfo.getPropertyName());
            expansionFieldConfigInfo.setPropertyType(fieldConfigInfo.getPropertyType());
            expansionFieldConfigInfos.add(expansionFieldConfigInfo);
        }
        return expansionFieldConfigInfos;
    }

    public List<ExpansionMethodConfigInfo> getExpansionMethodConfigInfoService(String modelId) {
        if (HussarUtils.isEmpty((Object)this.hussarExpansionModelInfoProperties) || HussarUtils.isEmpty((Object)modelId)) {
            return null;
        }
        Map tableExpansionMethodInfos = this.hussarExpansionModelInfoProperties.getTableExpansionMethodInfos();
        if (HussarUtils.isEmpty((Object)tableExpansionMethodInfos)) {
            return null;
        }
        List expansionMethodConfigInfos = (List)tableExpansionMethodInfos.get(modelId);
        if (HussarUtils.isEmpty((Object)expansionMethodConfigInfos)) {
            return null;
        }
        return expansionMethodConfigInfos;
    }

    public List<ExpansionExtensionTableInfo> getExpansionExtensionTableInfo(ExpansionExtensionTableServiceDto expansionExtensionTableServiceDto) {
        if (HussarUtils.isEmpty((Object)this.hussarExpansionModelInfoProperties) || HussarUtils.isEmpty((Object)expansionExtensionTableServiceDto) || HussarUtils.isEmpty((Object)expansionExtensionTableServiceDto.getTableInfos()) || HussarUtils.isEmpty((Object)expansionExtensionTableServiceDto.getModelId())) {
            return null;
        }
        Map tableExpansionSlaveTableInfos = this.hussarExpansionModelInfoProperties.getTableExpansionSlaveTableInfos();
        if (HussarUtils.isEmpty((Object)tableExpansionSlaveTableInfos)) {
            return null;
        }
        String modelId = expansionExtensionTableServiceDto.getModelId();
        List expansionExtensionTableConfigInfos = (List)tableExpansionSlaveTableInfos.get(modelId);
        if (HussarUtils.isEmpty((Object)expansionExtensionTableConfigInfos)) {
            return null;
        }
        List tableInfos = expansionExtensionTableServiceDto.getTableInfos();
        ArrayList<ExpansionExtensionTableInfo> returnExpansionTableColumnsInfoList = new ArrayList<ExpansionExtensionTableInfo>();
        for (ExpansionTableVo tableInfo : tableInfos) {
            List expansionExtensionTableInfos = this.doGetExpansionExtensionTableConfigInfoService(tableInfo, expansionExtensionTableConfigInfos);
            if (HussarUtils.isEmpty((Object)expansionExtensionTableInfos)) continue;
            returnExpansionTableColumnsInfoList.addAll(expansionExtensionTableInfos);
        }
        return returnExpansionTableColumnsInfoList;
    }
}

