/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.strategy;

import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.strategy.AbstractExpansionServiceHandler;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.strategy.ExpansionServiceHandler;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.strategy.ExtensionTableExpansionServiceHandler;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.strategy.TableColumnExpansionServiceHandler;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.strategy.dto.ProcessorDto;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class ExpansionServiceHandlerContext
implements ExpansionServiceHandler {
    private List<AbstractExpansionServiceHandler> handlerList = new ArrayList<AbstractExpansionServiceHandler>();

    public ExpansionServiceHandlerContext() {
        this.handlerList.add(0, new TableColumnExpansionServiceHandler());
        this.handlerList.add(1, new ExtensionTableExpansionServiceHandler());
    }

    public void addHandler(AbstractExpansionServiceHandler handler) {
        Optional<AbstractExpansionServiceHandler> first = this.handlerList.stream().filter(abstractExpansionServiceHandler -> abstractExpansionServiceHandler.getClass().getSimpleName().equals(handler.getClass().getSimpleName())).findFirst();
        if (!first.isPresent()) {
            this.handlerList.add(handler);
        }
    }

    @Override
    public void processInsert(ProcessorDto processorDto) {
        this.handlerList.stream().forEach(e -> e.processInsert(processorDto));
    }

    @Override
    public void processUpdate(ProcessorDto processorDto) {
        this.handlerList.stream().forEach(e -> e.processUpdate(processorDto));
    }

    @Override
    public void processDelete(ProcessorDto processorDto) {
        this.handlerList.stream().forEach(e -> e.processDelete(processorDto));
    }

    @Override
    public void processSelect(ProcessorDto processorDto) {
        this.handlerList.stream().forEach(e -> e.processSelect(processorDto));
    }
}

