/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.service;

import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.expansion.core.config.HussarExpansionProperties;
import com.jxdinfo.hussar.support.expansion.core.context.ExpansionContextHolder;
import com.jxdinfo.hussar.support.expansion.core.enums.ExpansionPositionTypeEnum;
import com.jxdinfo.hussar.support.expansion.core.service.ExpansionColumnInfoService;
import com.jxdinfo.hussar.support.expansion.core.service.dto.ExpansionColumnInfoServiceVo;
import com.jxdinfo.hussar.support.expansion.core.service.dto.ExpansionTableColumnsInfo;
import com.jxdinfo.hussar.support.expansion.core.service.dto.ExpansionTableVo;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.dto.ExpansionServiceDto;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.AbstractExpandFieldLogic;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.ExpansionParameterMappingDto;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.ExpansionSQLDto;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.ExpansionSQLVo;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.FieldLogicInfo;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.ParameterMappingKeyValueVo;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.ParameterMappingVo;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.param.ColumnExpressionDto;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.param.SelectExpansionParameterMappingDto;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.param.SelectExpansionSQLVo;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.utils.ExpansionMybatisUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.operators.conditional.AndExpression;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.Join;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandler;

public class SelectExpandFieldLogic
extends AbstractExpandFieldLogic {
    public SelectExpandFieldLogic() {
        this.MAP_KEY_LIST.add(ExpansionPositionTypeEnum.SELECT_COLUMNS.getType());
        this.MAP_KEY_LIST.add(ExpansionPositionTypeEnum.SELECT_WHERE.getType());
    }

    private void expansionSelectItemAndResultHandler(StatementHandler statementHandler, Map<String, List<FieldLogicInfo>> returnMapField, List<SelectItem> selectItems, HussarExpansionProperties hussarExpansionProperties) {
        List<FieldLogicInfo> fieldLogicInfos = returnMapField.get(ExpansionPositionTypeEnum.SELECT_COLUMNS.getType());
        HashMap<String, FieldLogicInfo> propertyCloumnMap = new HashMap<String, FieldLogicInfo>();
        for (FieldLogicInfo fieldLogicInfo : fieldLogicInfos) {
            SelectExpressionItem selectExpressionItem;
            boolean b;
            String columnName = fieldLogicInfo.getColumnName();
            if (HussarUtils.isEmpty((Object)columnName) || (b = this.existSelectItem(selectItems, fieldLogicInfo))) continue;
            if (HussarUtils.isNotEmpty((Object)fieldLogicInfo.getTableAlias()) && fieldLogicInfo.isEnableAlias()) {
                ArrayList<String> partItems = new ArrayList<String>();
                partItems.add(fieldLogicInfo.getTableAlias());
                Table tableAlias = new Table(partItems);
                selectExpressionItem = new SelectExpressionItem((Expression)new Column(tableAlias, columnName));
                String columnAliasName = this.createColumnAlias(fieldLogicInfo);
                String columnAliasNameUpperCase = columnAliasName.toUpperCase();
                Alias columnAlias = new Alias(columnAliasNameUpperCase);
                selectExpressionItem.setAlias(columnAlias);
                propertyCloumnMap.put(columnAliasNameUpperCase, fieldLogicInfo);
            } else {
                String columnNameUpperCase = columnName.toUpperCase();
                propertyCloumnMap.put(columnNameUpperCase, fieldLogicInfo);
                selectExpressionItem = new SelectExpressionItem((Expression)new Column(columnNameUpperCase));
            }
            selectItems.add((SelectItem)selectExpressionItem);
        }
        ExpansionMybatisUtils.createExpansionResultSetHandler(statementHandler, hussarExpansionProperties, propertyCloumnMap);
    }

    @Override
    public boolean support(Statement statement, Object obj) {
        if (HussarUtils.isEmpty((Object)obj) || !(obj instanceof ExpansionServiceDto) || HussarUtils.isEmpty((Object)ExpansionContextHolder.get())) {
            return false;
        }
        Select select = (Select)statement;
        SelectBody selectBody = select.getSelectBody();
        if (!(selectBody instanceof PlainSelect)) {
            return false;
        }
        try {
            PlainSelect plainSelect = (PlainSelect)selectBody;
            FromItem fromItem = plainSelect.getFromItem();
            if (!(fromItem instanceof Table)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public List<ExpansionTableColumnsInfo> expansionGetTableConfigInfo(Statement statement, ExpansionColumnInfoService expansionColumnInfoService) {
        Select select = (Select)statement;
        SelectBody selectBody = select.getSelectBody();
        PlainSelect plainSelect = (PlainSelect)selectBody;
        Table table = (Table)plainSelect.getFromItem(Table.class);
        String tableName = table.getName();
        ExpansionTableVo expansionTableColumnsInfoLeft = HussarUtils.isNotEmpty((Object)table.getAlias()) ? new ExpansionTableVo(table.getAlias().getName(), tableName) : new ExpansionTableVo(null, tableName);
        ArrayList<ExpansionTableVo> expansionTableColumnsInfos = new ArrayList<ExpansionTableVo>();
        expansionTableColumnsInfos.add(expansionTableColumnsInfoLeft);
        List joins = plainSelect.getJoins();
        if (HussarUtils.isNotEmpty((Object)joins)) {
            for (Join join : joins) {
                FromItem rightItem = join.getRightItem();
                if (!(rightItem instanceof Table)) continue;
                Table rightItemTable = (Table)rightItem;
                ExpansionTableVo expansionTableColumnsInfoRight = new ExpansionTableVo(rightItemTable.getAlias().getName(), rightItemTable.getName());
                expansionTableColumnsInfos.add(expansionTableColumnsInfoRight);
            }
        }
        String moduleId = ExpansionContextHolder.get();
        ExpansionColumnInfoServiceVo expansionColumnInfoServiceVo = new ExpansionColumnInfoServiceVo();
        expansionColumnInfoServiceVo.setModelId(moduleId);
        expansionColumnInfoServiceVo.setTableInfos(expansionTableColumnsInfos);
        List expansionColumnInfos = expansionColumnInfoService.getExpansionColumnInfo(expansionColumnInfoServiceVo);
        return expansionColumnInfos;
    }

    @Override
    public ExpansionSQLVo expandSqlService(ExpansionSQLDto expansionSQLDto) {
        HashMap<String, List<FieldLogicInfo>> actualMapField = new HashMap<String, List<FieldLogicInfo>>();
        Map<String, List<FieldLogicInfo>> returnMapField = expansionSQLDto.getReturnMapField();
        Statement statement = expansionSQLDto.getStatement();
        StatementHandler statementHandler = expansionSQLDto.getStatementHandler();
        Select select = (Select)statement;
        PlainSelect plainSelect = (PlainSelect)select.getSelectBody(PlainSelect.class);
        List selectItems = plainSelect.getSelectItems();
        Expression where = plainSelect.getWhere();
        Set<Object> whereJdbcParameterSet = null;
        HashSet<Column> whereColumnName = null;
        if (HussarUtils.isEmpty((Object)where)) {
            whereJdbcParameterSet = new HashSet();
            whereColumnName = new HashSet();
        } else {
            whereJdbcParameterSet = this.getWhereJdbcParameter(where);
            whereColumnName = this.getWhereColumnName(where);
        }
        PluginUtils.MPStatementHandler mpStatementHandler = PluginUtils.mpStatementHandler((StatementHandler)statementHandler);
        Configuration configuration = mpStatementHandler.configuration();
        List<FieldLogicInfo> whereFieldLoginInfoList = returnMapField.get(ExpansionPositionTypeEnum.SELECT_WHERE.getType());
        ArrayList<ColumnExpressionDto> addWhereList = new ArrayList<ColumnExpressionDto>();
        if (HussarUtils.isNotEmpty(whereFieldLoginInfoList)) {
            ArrayList<FieldLogicInfo> whereActualFieldLogicList = new ArrayList<FieldLogicInfo>();
            actualMapField.put(ExpansionPositionTypeEnum.SELECT_WHERE.getType(), whereActualFieldLogicList);
            int whereIndex = whereJdbcParameterSet.size();
            for (FieldLogicInfo info : whereFieldLoginInfoList) {
                this.convert(configuration, info);
                boolean b = this.existWhereItem(whereColumnName, info);
                if (b || HussarUtils.isEmpty((Object)info.getValue())) continue;
                Column column = new Column(info.getColumnName());
                Expression expression = this.getConditionByFieldInfo(info, ++whereIndex);
                ColumnExpressionDto columnExpressionDto = new ColumnExpressionDto(info.getTableName(), info.getTableAlias(), column, expression, info.getPropertyName(), ExpansionPositionTypeEnum.SELECT_WHERE.getType(), whereIndex);
                addWhereList.add(columnExpressionDto);
                whereActualFieldLogicList.add(info);
            }
        }
        this.expansionSelectItemAndResultHandler(statementHandler, returnMapField, selectItems, expansionSQLDto.getHussarExpansionProperties());
        SelectExpansionSQLVo expansionSQLVo = new SelectExpansionSQLVo();
        expansionSQLVo.setActualFieldLogicInfoMap(actualMapField);
        expansionSQLVo.setAddWhereList(addWhereList);
        return expansionSQLVo;
    }

    @Override
    public ParameterMappingVo expandParameterMappingService(ExpansionParameterMappingDto expansionParameterMappingDto) {
        if (HussarUtils.isEmpty((Object)expansionParameterMappingDto) || HussarUtils.isEmpty(expansionParameterMappingDto.getActualFieldLogicInfoMap()) || HussarUtils.isEmpty(expansionParameterMappingDto.getParameterMappingList())) {
            return null;
        }
        String expansionMapPropertyName = expansionParameterMappingDto.getExpansionMapPropertyName();
        Map<String, List<FieldLogicInfo>> actualFieldLogicInfoMap = expansionParameterMappingDto.getActualFieldLogicInfoMap();
        List<ParameterMapping> parameterMappingList = expansionParameterMappingDto.getParameterMappingList();
        SelectExpansionParameterMappingDto selectExpansionParameterMappingDto = (SelectExpansionParameterMappingDto)expansionParameterMappingDto;
        List<ColumnExpressionDto> addWhereList = selectExpansionParameterMappingDto.getAddWhereList();
        Configuration mybatisConfiguration = this.getMybatisConfiguration(parameterMappingList.get(0));
        List<ParameterMappingKeyValueVo> parameterMappingKeyValueVos = this.getParameterMappingKey(mybatisConfiguration, actualFieldLogicInfoMap, expansionMapPropertyName);
        if (HussarUtils.isEmpty(parameterMappingKeyValueVos)) {
            return null;
        }
        if (HussarUtils.isNotEmpty(addWhereList)) {
            for (ColumnExpressionDto columnExpressionDto : addWhereList) {
                Optional<ParameterMappingKeyValueVo> first = parameterMappingKeyValueVos.stream().filter(pkv -> pkv.getPropertyName().equalsIgnoreCase(columnExpressionDto.getPropertyName()) && pkv.getPositionType().equalsIgnoreCase(columnExpressionDto.getPositionType())).findFirst();
                if (!first.isPresent()) continue;
                ParameterMappingKeyValueVo parameterMappingKeyValueVo = first.get();
                Optional<ParameterMapping> optionalColumn = parameterMappingList.stream().filter(pm -> pm.getProperty().equalsIgnoreCase(parameterMappingKeyValueVo.getParameterMappingKey())).findAny();
                if (optionalColumn.isPresent()) continue;
                TypeHandler typeHandler = this.getTypeHandler(mybatisConfiguration, parameterMappingKeyValueVo);
                ParameterMapping.Builder builder = new ParameterMapping.Builder(mybatisConfiguration, parameterMappingKeyValueVo.getParameterMappingKey(), typeHandler);
                int index = columnExpressionDto.getIndex();
                if (index - 1 > parameterMappingList.size()) {
                    parameterMappingList.add(builder.build());
                    continue;
                }
                parameterMappingList.add(index - 1, builder.build());
            }
        }
        ParameterMappingVo parameterMappingVo = new ParameterMappingVo();
        parameterMappingVo.setParameterMappingList(parameterMappingList);
        parameterMappingVo.setParameterMappingKeyValueVoList(parameterMappingKeyValueVos);
        return parameterMappingVo;
    }

    @Override
    public boolean expandChangeSqlAndParameterMappingForBoundSql(ExpansionSQLVo expansionSQLVo, ParameterMappingVo parameterMappingVo, Statement statement, StatementHandler statementHandler) {
        boolean flag = false;
        if (HussarUtils.isEmpty((Object)expansionSQLVo)) {
            this.changeBoundSql(statementHandler, statement);
            return flag;
        }
        Select select = (Select)statement;
        SelectBody selectBody = select.getSelectBody();
        PlainSelect plainSelect = (PlainSelect)selectBody;
        SelectExpansionSQLVo selectExpansionSQLVo = (SelectExpansionSQLVo)expansionSQLVo;
        if (HussarUtils.isNotEmpty((Object)parameterMappingVo) && HussarUtils.isNotEmpty(parameterMappingVo.getParameterMappingList()) && HussarUtils.isNotEmpty(parameterMappingVo.getParameterMappingKeyValueVoList())) {
            List<ColumnExpressionDto> addWhereList = selectExpansionSQLVo.getAddWhereList();
            if (HussarUtils.isNotEmpty(addWhereList)) {
                for (ColumnExpressionDto columnExpressionDto : addWhereList) {
                    AndExpression andExpression = new AndExpression(plainSelect.getWhere(), columnExpressionDto.getExpression());
                    plainSelect.setWhere((Expression)andExpression);
                }
            }
            flag = this.processingParameterMappingAndAdditionalParameter(parameterMappingVo, statementHandler);
        }
        this.changeBoundSql(statementHandler, statement);
        return flag;
    }

    static {
        POSITION_TYPE_LIST.add(ExpansionPositionTypeEnum.SELECT_COLUMNS.getType());
        POSITION_TYPE_LIST.add(ExpansionPositionTypeEnum.SELECT_WHERE.getType());
        POSITION_TYPE_LIST.add(ExpansionPositionTypeEnum.SELECT_COLUMNS_WHERE.getType());
        POSITION_TYPE_LIST.add(ExpansionPositionTypeEnum.ALL.getType());
    }
}

