/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.service;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.expansion.core.context.ExpansionContextHolder;
import com.jxdinfo.hussar.support.expansion.core.enums.ExpansionPositionTypeEnum;
import com.jxdinfo.hussar.support.expansion.core.service.ExpansionColumnInfoService;
import com.jxdinfo.hussar.support.expansion.core.service.dto.ExpansionColumnInfoServiceVo;
import com.jxdinfo.hussar.support.expansion.core.service.dto.ExpansionTableColumnsInfo;
import com.jxdinfo.hussar.support.expansion.core.service.dto.ExpansionTableVo;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.dto.ExpansionServiceDto;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.AbstractExpandFieldLogic;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.ExpansionParameterMappingDto;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.ExpansionSQLDto;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.ExpansionSQLVo;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.FieldLogicInfo;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.ParameterMappingKeyValueVo;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.ParameterMappingVo;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.param.ColumnExpressionDto;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.param.InsertExpansionSQLVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.operators.relational.ExpressionList;
import net.sf.jsqlparser.expression.operators.relational.ItemsList;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.insert.Insert;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.TypeHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InsertExpandFieldLogic
extends AbstractExpandFieldLogic {
    private static final Logger logger = LoggerFactory.getLogger(InsertExpandFieldLogic.class);
    private static List<String> POSITION_TYPE_LIST = new ArrayList<String>();

    public InsertExpandFieldLogic() {
        this.MAP_KEY_LIST.add(ExpansionPositionTypeEnum.INSERT_COLUMNS.getType());
    }

    @Override
    public boolean support(Statement statement, Object obj) {
        if (HussarUtils.isEmpty((Object)obj) || !(obj instanceof ExpansionServiceDto) || HussarUtils.isEmpty((Object)ExpansionContextHolder.get())) {
            return false;
        }
        Insert insert = (Insert)statement;
        List columns = insert.getColumns();
        if (CollectionUtils.isEmpty((Collection)columns)) {
            logger.info("insert\u8bed\u53e5\u4e0d\u652f\u6301* \u7684\u65b9\u5f0f");
            return false;
        }
        ItemsList itemList = insert.getItemsList();
        if (!(itemList instanceof ExpressionList)) {
            logger.info("insert \u8bed\u53e5\u53ea\u662f\u652f\u6301value(? ? ? ?)\u7684\u683c\u5f0f");
            return false;
        }
        return true;
    }

    public List<ExpansionTableColumnsInfo> expansionGetTableConfigInfo(Statement statement, ExpansionColumnInfoService expansionColumnInfoService) {
        Insert insert = (Insert)statement;
        Table table = insert.getTable();
        String tableName = table.getName();
        String moduleId = ExpansionContextHolder.get();
        ArrayList<ExpansionTableVo> expansionTableInfos = new ArrayList<ExpansionTableVo>();
        ExpansionTableVo expansionTableVo = new ExpansionTableVo(null, tableName);
        expansionTableInfos.add(expansionTableVo);
        ExpansionColumnInfoServiceVo expansionColumnInfoServiceVo = new ExpansionColumnInfoServiceVo();
        expansionColumnInfoServiceVo.setModelId(moduleId);
        expansionColumnInfoServiceVo.setTableInfos(expansionTableInfos);
        List expansionColumnInfos = expansionColumnInfoService.getExpansionColumnInfo(expansionColumnInfoServiceVo);
        return expansionColumnInfos;
    }

    @Override
    public ExpansionSQLVo expandSqlService(ExpansionSQLDto expansionSQLDto) {
        HashMap<String, List<FieldLogicInfo>> actualMapField = new HashMap<String, List<FieldLogicInfo>>();
        Map<String, List<FieldLogicInfo>> returnMapField = expansionSQLDto.getReturnMapField();
        Statement statement = expansionSQLDto.getStatement();
        StatementHandler statementHandler = expansionSQLDto.getStatementHandler();
        List<FieldLogicInfo> fieldLogicInfos = returnMapField.get(ExpansionPositionTypeEnum.INSERT_COLUMNS.getType());
        if (HussarUtils.isEmpty(fieldLogicInfos)) {
            logger.info("\u672a\u5339\u914d\u5230\u6269\u5c55\u5b57\u6bb5\u7684\u6570\u636e");
            return null;
        }
        Insert insert = (Insert)statement;
        List columns = insert.getColumns();
        ArrayList<FieldLogicInfo> actualFieldLogicList = new ArrayList<FieldLogicInfo>();
        actualMapField.put(ExpansionPositionTypeEnum.INSERT_COLUMNS.getType(), actualFieldLogicList);
        ItemsList itemList = insert.getItemsList();
        ExpressionList expressionList = (ExpressionList)itemList;
        List expressions = expressionList.getExpressions();
        if (HussarUtils.isEmpty((Object)expressions)) {
            logger.info("insert \u8bed\u53e5\u672a\u68c0\u6d4b\u5230value\u7684\u8bed\u6cd5\u7ed3\u6784");
            return null;
        }
        ArrayList<ColumnExpressionDto> addColumnExpressionDtoList = new ArrayList<ColumnExpressionDto>();
        ColumnExpressionDto columnExpressionDto = null;
        int valueIndex = expressions.size();
        Column column = null;
        JdbcParameter jdbcParameter = null;
        PluginUtils.MPStatementHandler mpStatementHandler = PluginUtils.mpStatementHandler((StatementHandler)statementHandler);
        Configuration configuration = mpStatementHandler.configuration();
        for (FieldLogicInfo info : fieldLogicInfos) {
            Optional<Column> optionalColumn = columns.stream().filter(col -> col.getColumnName().equalsIgnoreCase(info.getColumnName())).findAny();
            this.convert(configuration, info);
            if (optionalColumn.isPresent() || info.getValue() == null) continue;
            column = new Column(info.getColumnName());
            jdbcParameter = new JdbcParameter(Integer.valueOf(++valueIndex), false);
            columnExpressionDto = new ColumnExpressionDto(info.getTableName(), info.getTableAlias(), column, (Expression)jdbcParameter, info.getPropertyName(), ExpansionPositionTypeEnum.INSERT_COLUMNS.getType(), valueIndex);
            addColumnExpressionDtoList.add(columnExpressionDto);
            actualFieldLogicList.add(info);
        }
        InsertExpansionSQLVo insertExpansionSQLVo = new InsertExpansionSQLVo();
        insertExpansionSQLVo.setAddInsertColumnList(addColumnExpressionDtoList);
        insertExpansionSQLVo.setActualFieldLogicInfoMap(actualMapField);
        return insertExpansionSQLVo;
    }

    @Override
    public ParameterMappingVo expandParameterMappingService(ExpansionParameterMappingDto expansionParameterMappingDto) {
        if (HussarUtils.isEmpty((Object)expansionParameterMappingDto) || HussarUtils.isEmpty(expansionParameterMappingDto.getActualFieldLogicInfoMap()) || HussarUtils.isEmpty(expansionParameterMappingDto.getParameterMappingList())) {
            return null;
        }
        String expansionMapPropertyName = expansionParameterMappingDto.getExpansionMapPropertyName();
        Map<String, List<FieldLogicInfo>> actualFieldLogicInfoMap = expansionParameterMappingDto.getActualFieldLogicInfoMap();
        List<ParameterMapping> parameterMappingList = expansionParameterMappingDto.getParameterMappingList();
        Configuration mybatisConfiguration = this.getMybatisConfiguration(parameterMappingList.get(0));
        List<ParameterMappingKeyValueVo> parameterMappingKeyValueVos = this.getParameterMappingKey(mybatisConfiguration, actualFieldLogicInfoMap, expansionMapPropertyName);
        if (HussarUtils.isEmpty(parameterMappingKeyValueVos)) {
            return null;
        }
        for (ParameterMappingKeyValueVo propertyNameObj : parameterMappingKeyValueVos) {
            Optional<ParameterMapping> optionalColumn = parameterMappingList.stream().filter(pm -> pm.getProperty().equalsIgnoreCase(propertyNameObj.getParameterMappingKey())).findAny();
            if (optionalColumn.isPresent()) continue;
            TypeHandler typeHandler = this.getTypeHandler(mybatisConfiguration, propertyNameObj);
            ParameterMapping.Builder builder = new ParameterMapping.Builder(mybatisConfiguration, propertyNameObj.getParameterMappingKey(), typeHandler);
            parameterMappingList.add(builder.build());
        }
        ParameterMappingVo parameterMappingVo = new ParameterMappingVo();
        parameterMappingVo.setParameterMappingList(parameterMappingList);
        parameterMappingVo.setParameterMappingKeyValueVoList(parameterMappingKeyValueVos);
        return parameterMappingVo;
    }

    @Override
    public boolean expandChangeSqlAndParameterMappingForBoundSql(ExpansionSQLVo expansionSQLVo, ParameterMappingVo parameterMappingVo, Statement statement, StatementHandler statementHandler) {
        boolean flag = false;
        if (HussarUtils.isEmpty((Object)expansionSQLVo)) {
            this.changeBoundSql(statementHandler, statement);
            return flag;
        }
        Insert insert = (Insert)statement;
        ItemsList itemList = insert.getItemsList();
        ExpressionList expressionList = (ExpressionList)itemList;
        List expressions = expressionList.getExpressions();
        List columns = insert.getColumns();
        InsertExpansionSQLVo insertExpansionSQLVo = (InsertExpansionSQLVo)expansionSQLVo;
        if (HussarUtils.isNotEmpty((Object)parameterMappingVo) && HussarUtils.isNotEmpty(parameterMappingVo.getParameterMappingList()) && HussarUtils.isNotEmpty(parameterMappingVo.getParameterMappingKeyValueVoList()) && HussarUtils.isNotEmpty(insertExpansionSQLVo.getAddInsertColumnList())) {
            for (ColumnExpressionDto columnExpressionDto : insertExpansionSQLVo.getAddInsertColumnList()) {
                columns.add(columnExpressionDto.getColumn());
                expressions.add(columnExpressionDto.getExpression());
            }
            flag = this.processingParameterMappingAndAdditionalParameter(parameterMappingVo, statementHandler);
        }
        this.changeBoundSql(statementHandler, statement);
        return flag;
    }

    static {
        POSITION_TYPE_LIST.add(ExpansionPositionTypeEnum.INSERT_COLUMNS.getType());
        POSITION_TYPE_LIST.add(ExpansionPositionTypeEnum.ALL.getType());
    }
}

