/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler;

import com.baomidou.mybatisplus.core.toolkit.PluginUtils;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.platform.core.utils.convert.HussarConverter;
import com.jxdinfo.hussar.support.expansion.core.config.ExpansionFieldExcludeInfo;
import com.jxdinfo.hussar.support.expansion.core.config.HussarExpansionProperties;
import com.jxdinfo.hussar.support.expansion.core.enums.ExpansionWhereOptrEnum;
import com.jxdinfo.hussar.support.expansion.core.service.dto.ExpansionTableFieldInfoVo;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.ExpansionLogicService;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.FieldLogicInfo;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.ParameterMappingKeyValueVo;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.handler.dto.ParameterMappingVo;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.visitor.ExpansionExpressionVisitorAdapter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.ExpressionVisitor;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.JdbcParameter;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.operators.relational.EqualsTo;
import net.sf.jsqlparser.expression.operators.relational.IsNullExpression;
import net.sf.jsqlparser.expression.operators.relational.LikeExpression;
import net.sf.jsqlparser.expression.operators.relational.NotEqualsTo;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import org.apache.ibatis.executor.statement.StatementHandler;
import org.apache.ibatis.mapping.BoundSql;
import org.apache.ibatis.mapping.ParameterMapping;
import org.apache.ibatis.reflection.MetaObject;
import org.apache.ibatis.reflection.SystemMetaObject;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeAliasRegistry;
import org.apache.ibatis.type.TypeHandler;
import org.apache.ibatis.type.TypeHandlerRegistry;
import org.springframework.util.AntPathMatcher;

public abstract class AbstractExpansionLogicService
implements ExpansionLogicService {
    private String EXPANSION_PARAMETER_MAPPING_KEY = "E_P_M_K";
    protected List<String> MAP_KEY_LIST = new ArrayList<String>();
    protected static final List<String> POSITION_TYPE_LIST = new ArrayList<String>();

    protected abstract FieldLogicInfo doExpandFeildLogic(String var1, String var2, Object var3, HussarExpansionProperties var4, ExpansionTableFieldInfoVo var5);

    protected Map<String, List<FieldLogicInfo>> doExpandFieldLogicMap(String currentMapperId, String sqlOperatorType, List<FieldLogicInfo> fieldLogicInfoList) {
        if (HussarUtils.isEmpty(fieldLogicInfoList)) {
            return null;
        }
        Map<String, List<FieldLogicInfo>> returnMap = this.getReturnMap();
        for (FieldLogicInfo fieldLogicInfo : fieldLogicInfoList) {
            this.putFieldTOMap(currentMapperId, sqlOperatorType, fieldLogicInfo, returnMap);
        }
        return returnMap;
    }

    protected Configuration getMybatisConfiguration(ParameterMapping parameterMapping) {
        parameterMapping = (ParameterMapping)PluginUtils.realTarget((Object)parameterMapping);
        MetaObject metaObject = SystemMetaObject.forObject((Object)parameterMapping);
        return (Configuration)metaObject.getValue("configuration");
    }

    protected TypeHandler getTypeHandler(Configuration mybatisConfiguration, ParameterMappingKeyValueVo propertyNameObj) {
        TypeHandlerRegistry typeHandlerRegistry = mybatisConfiguration.getTypeHandlerRegistry();
        TypeAliasRegistry typeAliasRegistry = mybatisConfiguration.getTypeAliasRegistry();
        TypeHandler unknownTypeHandler = typeHandlerRegistry.getUnknownTypeHandler();
        TypeHandler typeHandler = null;
        if (HussarUtils.isEmpty((Object)propertyNameObj.getPropertyType()) || HussarUtils.isEmpty((Object)typeAliasRegistry.resolveAlias(propertyNameObj.getPropertyType()))) {
            typeHandler = unknownTypeHandler;
        } else {
            Class objectClass;
            JdbcType jdbcType = null;
            if (HussarUtils.isNotEmpty((Object)propertyNameObj.getColumnType())) {
                jdbcType = JdbcType.valueOf((String)propertyNameObj.getColumnType());
            }
            typeHandler = HussarUtils.isNotEmpty((Object)(objectClass = typeAliasRegistry.resolveAlias(propertyNameObj.getPropertyType()))) ? typeHandlerRegistry.getTypeHandler(objectClass, jdbcType) : unknownTypeHandler;
        }
        return typeHandler;
    }

    protected void convert(Configuration mybatisConfiguration, FieldLogicInfo fieldLogicInfo) {
        TypeAliasRegistry typeAliasRegistry = mybatisConfiguration.getTypeAliasRegistry();
        Class objectClass = typeAliasRegistry.resolveAlias(fieldLogicInfo.getPropertyType());
        if (HussarUtils.isNotEmpty((Object)objectClass)) {
            Object convert = HussarConverter.convert((Class)objectClass, (Object)fieldLogicInfo.getValue());
            fieldLogicInfo.setValue(convert);
        }
    }

    protected Map<String, List<FieldLogicInfo>> getReturnMap() {
        HashMap<String, List<FieldLogicInfo>> returnMap = new HashMap<String, List<FieldLogicInfo>>();
        for (String key : this.MAP_KEY_LIST) {
            returnMap.put(key, new ArrayList());
        }
        return returnMap;
    }

    protected void putFieldTOMap(String currentMapperId, String sqlOperatorType, FieldLogicInfo fieldLogicInfo, Map<String, List<FieldLogicInfo>> returnMap) {
        List<String> positionTypes = fieldLogicInfo.getPositionTypes(sqlOperatorType);
        for (Map.Entry<String, List<FieldLogicInfo>> entry : returnMap.entrySet()) {
            String key = entry.getKey();
            List<FieldLogicInfo> value = entry.getValue();
            if (!positionTypes.contains(key) || !this.doExcludeExpansion(fieldLogicInfo, currentMapperId, key)) continue;
            value.add(fieldLogicInfo);
        }
    }

    protected boolean doExcludeExpansion(FieldLogicInfo fieldLogicInfo, String currentMapperId, String currentPositionType) {
        List<ExpansionFieldExcludeInfo> excludeInfos = fieldLogicInfo.getExcludeInfos();
        if (HussarUtils.isEmpty(excludeInfos)) {
            return true;
        }
        Optional<ExpansionFieldExcludeInfo> fieldExcludeInfoOptional = excludeInfos.stream().filter(e -> HussarUtils.isNotEmpty((Object)e.getExcludePositionType()) && e.getExcludePositionType().equalsIgnoreCase(currentPositionType)).findFirst();
        if (!fieldExcludeInfoOptional.isPresent()) {
            return true;
        }
        ExpansionFieldExcludeInfo expansionFieldExcludeInfo = fieldExcludeInfoOptional.get();
        if (HussarUtils.isEmpty((Object)expansionFieldExcludeInfo.getExcludeMappersPattern())) {
            return false;
        }
        List excludeMappersPattern = expansionFieldExcludeInfo.getExcludeMappersPattern();
        AntPathMatcher pathMatcher = new AntPathMatcher(".");
        boolean b = excludeMappersPattern.stream().anyMatch(s -> pathMatcher.matchStart(s, currentMapperId));
        return !b;
    }

    protected Set<Column> getWhereColumnName(Expression where) {
        ExpansionExpressionVisitorAdapter expansionExpressionVisitorAdapter = new ExpansionExpressionVisitorAdapter();
        where.accept((ExpressionVisitor)expansionExpressionVisitorAdapter);
        return expansionExpressionVisitorAdapter.getFields();
    }

    protected Set<JdbcParameter> getWhereJdbcParameter(Expression where) {
        ExpansionExpressionVisitorAdapter expansionExpressionVisitorAdapter = new ExpansionExpressionVisitorAdapter();
        where.accept((ExpressionVisitor)expansionExpressionVisitorAdapter);
        return expansionExpressionVisitorAdapter.getJdbcParametersSet();
    }

    protected Expression getConditionByFieldInfo(FieldLogicInfo info, int paramIndex) {
        String columnName = info.getColumnName();
        Column column = new Column(columnName);
        if (info.isEnableAlias() && HussarUtils.isNotEmpty((Object)info.getTableAlias())) {
            Table tableAlias = new Table(info.getTableAlias());
            column.setTable(tableAlias);
        }
        if (info.getOptType() == null || ExpansionWhereOptrEnum.EQUALS.getCode().equalsIgnoreCase(info.getOptType())) {
            JdbcParameter jdbcParameter = new JdbcParameter(Integer.valueOf(paramIndex), false);
            return new EqualsTo((Expression)column, (Expression)jdbcParameter);
        }
        if (ExpansionWhereOptrEnum.LIKE.name().equalsIgnoreCase(info.getOptType()) || ExpansionWhereOptrEnum.NOT_LIKE.name().equalsIgnoreCase(info.getOptType())) {
            JdbcParameter jdbcParameter = new JdbcParameter(Integer.valueOf(paramIndex), false);
            LikeExpression like = new LikeExpression();
            like.setLeftExpression((Expression)column);
            like.setRightExpression((Expression)jdbcParameter);
            like.setNot(ExpansionWhereOptrEnum.NOT_LIKE.name().equalsIgnoreCase(info.getOptType()));
            if (HussarUtils.isNotEmpty((Object)info.getEscape())) {
                StringValue escape = new StringValue(info.getEscape());
                like.setEscape((Expression)escape);
            }
            return like;
        }
        if (ExpansionWhereOptrEnum.NOT_EQUALS.getCode().equalsIgnoreCase(info.getOptType())) {
            JdbcParameter jdbcParameter = new JdbcParameter(Integer.valueOf(paramIndex), false);
            return new NotEqualsTo((Expression)column, (Expression)jdbcParameter);
        }
        if (ExpansionWhereOptrEnum.IS_NULL.getCode().equalsIgnoreCase(info.getOptType()) || ExpansionWhereOptrEnum.IS_NOT_NULL.name().equalsIgnoreCase(info.getOptType())) {
            IsNullExpression isNull = new IsNullExpression();
            isNull.setLeftExpression((Expression)column);
            isNull.setNot(ExpansionWhereOptrEnum.IS_NOT_NULL.name().equalsIgnoreCase(info.getOptType()));
            return isNull;
        }
        return new EqualsTo((Expression)new Column("1"), (Expression)new LongValue(1L));
    }

    protected List<ParameterMappingKeyValueVo> getParameterMappingKey(Configuration mybatisConfiguration, Map<String, List<FieldLogicInfo>> actualFieldLogicInfoMap, String expansionMapPropertyName) {
        ArrayList<ParameterMappingKeyValueVo> returnList = new ArrayList<ParameterMappingKeyValueVo>();
        StringBuilder stringBuilder = new StringBuilder(this.EXPANSION_PARAMETER_MAPPING_KEY);
        stringBuilder.append('.');
        stringBuilder.append(expansionMapPropertyName);
        String prefix = stringBuilder.toString();
        ParameterMappingKeyValueVo parameterMappingKeyValueVo = null;
        for (Map.Entry<String, List<FieldLogicInfo>> entry : actualFieldLogicInfoMap.entrySet()) {
            String positionType = entry.getKey();
            List<FieldLogicInfo> fieldLogicInfos = entry.getValue();
            for (FieldLogicInfo fieldLogicInfo : fieldLogicInfos) {
                this.convert(mybatisConfiguration, fieldLogicInfo);
                if (fieldLogicInfo.getValue() == null) continue;
                parameterMappingKeyValueVo = new ParameterMappingKeyValueVo();
                parameterMappingKeyValueVo.setParameterMappingKey(prefix + '.' + fieldLogicInfo.getPropertyName() + "_" + positionType);
                parameterMappingKeyValueVo.setValue(fieldLogicInfo.getValue());
                parameterMappingKeyValueVo.setPropertyName(fieldLogicInfo.getPropertyName());
                parameterMappingKeyValueVo.setPositionType(positionType);
                parameterMappingKeyValueVo.setPropertyType(fieldLogicInfo.getPropertyType());
                parameterMappingKeyValueVo.setColumnType(fieldLogicInfo.getColumnType());
                returnList.add(parameterMappingKeyValueVo);
            }
        }
        return returnList;
    }

    public boolean processingParameterMappingAndAdditionalParameter(ParameterMappingVo doneParameterMappingVo, StatementHandler statementHandler) {
        if (HussarUtils.isEmpty((Object)doneParameterMappingVo)) {
            return false;
        }
        BoundSql boundSql = statementHandler.getBoundSql();
        PluginUtils.MPBoundSql mpBoundSql = PluginUtils.mpBoundSql((BoundSql)boundSql);
        List<ParameterMapping> parameterMappingList = doneParameterMappingVo.getParameterMappingList();
        List<ParameterMappingKeyValueVo> parameterMappingKeyValueVoList = doneParameterMappingVo.getParameterMappingKeyValueVoList();
        if (HussarUtils.isNotEmpty(parameterMappingList) && HussarUtils.isNotEmpty(parameterMappingKeyValueVoList)) {
            mpBoundSql.parameterMappings(parameterMappingList);
            parameterMappingKeyValueVoList.forEach(pmkv -> boundSql.setAdditionalParameter(pmkv.getParameterMappingKey(), pmkv.getValue()));
            return true;
        }
        return false;
    }

    protected void changeBoundSql(StatementHandler statementHandler, Statement statement) {
        BoundSql boundSql = statementHandler.getBoundSql();
        PluginUtils.MPBoundSql mpBoundSql = PluginUtils.mpBoundSql((BoundSql)boundSql);
        mpBoundSql.sql(statement.toString());
    }

    protected boolean existWhereItem(Set<Column> whereColumnNames, FieldLogicInfo info) {
        if (HussarUtils.isNotEmpty(whereColumnNames)) {
            String tableAaliasName = null;
            String columnName = null;
            for (Column column : whereColumnNames) {
                columnName = column.getColumnName();
                if (HussarUtils.isNotEmpty((Object)column.getTable())) {
                    tableAaliasName = column.getTable().getName();
                }
                if (!columnName.equalsIgnoreCase(info.getColumnName())) {
                    return false;
                }
                if (!HussarUtils.isNotEmpty((Object)tableAaliasName) || !HussarUtils.isNotEmpty((Object)info.getTableAlias())) continue;
                return tableAaliasName.equalsIgnoreCase(info.getTableAlias());
            }
        }
        return false;
    }

    protected boolean existSelectItem(List<SelectItem> selectItems, FieldLogicInfo info) {
        SelectExpressionItem item;
        Expression expression;
        SelectItem selectItem;
        if (HussarUtils.isNotEmpty(selectItems) && selectItems.size() == 1 && (selectItem = selectItems.get(0)) instanceof SelectExpressionItem && (expression = (item = (SelectExpressionItem)selectItem).getExpression()) instanceof Function) {
            return true;
        }
        for (SelectItem selectItem2 : selectItems) {
            SelectExpressionItem item2;
            Expression expression2;
            if (!(selectItem2 instanceof SelectExpressionItem) || !((expression2 = (item2 = (SelectExpressionItem)selectItem2).getExpression()) instanceof Column)) continue;
            Column column = (Column)expression2;
            String columnName = null;
            String tableAaliasName = null;
            String columnAliasName = null;
            if (HussarUtils.isNotEmpty((Object)column.getTable())) {
                tableAaliasName = column.getTable().getName();
            }
            columnName = column.getColumnName();
            if (HussarUtils.isNotEmpty((Object)item2.getAlias())) {
                columnAliasName = item2.getAlias().getName();
            }
            if (!columnName.equalsIgnoreCase(info.getColumnName())) {
                return false;
            }
            if (HussarUtils.isNotEmpty((Object)tableAaliasName) && HussarUtils.isNotEmpty((Object)info.getTableAlias())) {
                return tableAaliasName.equalsIgnoreCase(info.getTableAlias());
            }
            if (!HussarUtils.isNotEmpty((Object)columnAliasName) || !HussarUtils.isNotEmpty((Object)info.getColumnAlias())) continue;
            return columnAliasName.equalsIgnoreCase(info.getColumnAlias());
        }
        return false;
    }

    protected String createColumnAlias(FieldLogicInfo fieldLogicInfo) {
        StringBuilder columnBuilder = new StringBuilder(fieldLogicInfo.getTableAlias());
        columnBuilder.append(StringUtil.firstCharToUpper((String)fieldLogicInfo.getPropertyName()));
        return columnBuilder.toString();
    }
}

