/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.expansion.plugin.mybatis.interceptor;

import com.jxdinfo.hussar.support.expansion.core.config.HussarExpansionProperties;
import com.jxdinfo.hussar.support.expansion.core.service.ExpansionColumnInfoService;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.dto.ExpansionServiceDto;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.interceptor.AbstractExpansionInterceptor;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.strategy.ExpansionServiceHandlerContext;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.support.strategy.dto.ProcessorDto;
import com.jxdinfo.hussar.support.expansion.plugin.mybatis.utils.ExpansionMybatisUtils;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.delete.Delete;
import net.sf.jsqlparser.statement.insert.Insert;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.update.Update;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExpansionInterceptor
extends AbstractExpansionInterceptor {
    private static final Logger logger = LoggerFactory.getLogger(ExpansionInterceptor.class);
    private ExpansionServiceHandlerContext expansionServiceHandlerContext = new ExpansionServiceHandlerContext();

    public Expression buildTableExpression(Table table, Expression where, String whereSegment) {
        return null;
    }

    public ExpansionInterceptor() {
    }

    public ExpansionInterceptor(HussarExpansionProperties hussarExpansionProperties, ExpansionColumnInfoService expansionColumnInfoService) {
        super(hussarExpansionProperties, expansionColumnInfoService);
    }

    protected void processInsert(Insert insert, int index, String sql, Object obj) {
        ProcessorDto processorDto = new ProcessorDto((Statement)insert, index, sql, obj, this.getHussarExpansionProperties(), this.getExpansionColumnInfoService());
        this.expansionServiceHandlerContext.processInsert(processorDto);
    }

    protected void processDelete(Delete delete, int index, String sql, Object obj) {
        ProcessorDto processorDto = new ProcessorDto((Statement)delete, index, sql, obj, this.getHussarExpansionProperties(), this.getExpansionColumnInfoService());
        this.expansionServiceHandlerContext.processDelete(processorDto);
    }

    protected void processUpdate(Update update, int index, String sql, Object obj) {
        ProcessorDto processorDto = new ProcessorDto((Statement)update, index, sql, obj, this.getHussarExpansionProperties(), this.getExpansionColumnInfoService());
        this.expansionServiceHandlerContext.processUpdate(processorDto);
    }

    protected void processSelect(Select select, int index, String sql, Object obj) {
        ProcessorDto processorDto = new ProcessorDto((Statement)select, index, sql, obj, this.getHussarExpansionProperties(), this.getExpansionColumnInfoService());
        this.expansionServiceHandlerContext.processSelect(processorDto);
        ExpansionServiceDto expansionServiceDto = (ExpansionServiceDto)obj;
        if (!expansionServiceDto.isExpansionEnable()) {
            ExpansionMybatisUtils.createExpansionResultSetHandler(expansionServiceDto.getStatementHandler(), this.getHussarExpansionProperties(), null);
        }
    }
}

