/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import com.jxdinfo.hussar.platform.core.base.entity.ExpansionMapEntity;
import com.jxdinfo.hussar.platform.core.utils.ClassUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.expansion.core.config.HussarExpansionProperties;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import org.springframework.beans.AbstractNestablePropertyAccessor;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.BeansException;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.GenericTypeAwarePropertyDescriptor;
import org.springframework.beans.InvalidPropertyException;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.NotWritablePropertyException;
import org.springframework.beans.PropertyEditorRegistrySupport;
import org.springframework.beans.PropertyMatches;
import org.springframework.beans.PropertyValue;
import org.springframework.beans.TypeConverterDelegate;
import org.springframework.beans.TypeMismatchException;
import org.springframework.core.ResolvableType;
import org.springframework.core.convert.Property;
import org.springframework.core.convert.TypeDescriptor;
import org.springframework.lang.Nullable;
import org.springframework.util.ReflectionUtils;
import org.springframework.util.StringUtils;

public class HussarBeanWrapperImpl
extends AbstractNestablePropertyAccessor
implements BeanWrapper {
    @Nullable
    private CachedIntrospectionResults cachedIntrospectionResults;
    @Nullable
    private AccessControlContext acc;
    private HussarExpansionProperties hussarExpansionProperties;

    public HussarBeanWrapperImpl() {
        this(true);
    }

    public HussarBeanWrapperImpl(boolean registerDefaultEditors) {
        super(registerDefaultEditors);
    }

    public HussarBeanWrapperImpl(Object object) {
        super(object);
    }

    public HussarBeanWrapperImpl(Object object, HussarExpansionProperties hussarExpansionProperties) {
        super(object);
        this.hussarExpansionProperties = hussarExpansionProperties;
    }

    public HussarBeanWrapperImpl(Class<?> clazz) {
        super(clazz);
    }

    public HussarBeanWrapperImpl(Object object, String nestedPath, Object rootObject) {
        super(object, nestedPath, rootObject);
    }

    private HussarBeanWrapperImpl(Object object, String nestedPath, HussarBeanWrapperImpl parent) {
        super(object, nestedPath, (AbstractNestablePropertyAccessor)parent);
        this.setSecurityContext(parent.acc);
    }

    public HussarBeanWrapperImpl(Object object, String nestedPath, HussarBeanWrapperImpl parent, HussarExpansionProperties hussarExpansionProperties) {
        super(object, nestedPath, (AbstractNestablePropertyAccessor)parent);
        this.hussarExpansionProperties = hussarExpansionProperties;
    }

    public void setBeanInstance(Object object) {
        this.wrappedObject = object;
        this.rootObject = object;
        this.typeConverterDelegate = new TypeConverterDelegate((PropertyEditorRegistrySupport)this, this.wrappedObject);
        this.setIntrospectionClass(object.getClass());
    }

    public void setWrappedInstance(Object object, @Nullable String nestedPath, @Nullable Object rootObject) {
        super.setWrappedInstance(object, nestedPath, rootObject);
        this.setIntrospectionClass(this.getWrappedClass());
    }

    protected void setIntrospectionClass(Class<?> clazz) {
        if (this.cachedIntrospectionResults != null && this.cachedIntrospectionResults.getBeanClass() != clazz) {
            this.cachedIntrospectionResults = null;
        }
    }

    private CachedIntrospectionResults getCachedIntrospectionResults() {
        if (this.cachedIntrospectionResults == null) {
            this.cachedIntrospectionResults = CachedIntrospectionResults.forClass((Class)this.getWrappedClass());
        }
        return this.cachedIntrospectionResults;
    }

    public void setSecurityContext(@Nullable AccessControlContext acc) {
        this.acc = acc;
    }

    @Nullable
    public AccessControlContext getSecurityContext() {
        return this.acc;
    }

    @Nullable
    public Object convertForProperty(@Nullable Object value, String propertyName) throws TypeMismatchException {
        CachedIntrospectionResults cachedIntrospectionResults = this.getCachedIntrospectionResults();
        PropertyDescriptor pd = cachedIntrospectionResults.getPropertyDescriptor(propertyName);
        if (pd == null) {
            throw new InvalidPropertyException(this.getRootClass(), this.getNestedPath() + propertyName, "No property '" + propertyName + "' found");
        }
        TypeDescriptor td = cachedIntrospectionResults.getTypeDescriptor(pd);
        if (td == null) {
            td = cachedIntrospectionResults.addTypeDescriptor(pd, new TypeDescriptor(this.property(pd)));
        }
        return this.convertForProperty(propertyName, null, value, td);
    }

    private Property property(PropertyDescriptor pd) {
        GenericTypeAwarePropertyDescriptor gpd = (GenericTypeAwarePropertyDescriptor)pd;
        return new Property(gpd.getBeanClass(), gpd.getReadMethod(), gpd.getWriteMethod(), gpd.getName());
    }

    public void setPropertyValue(PropertyValue pv) throws BeansException {
        AbstractNestablePropertyAccessor.PropertyTokenHolder tokens = (AbstractNestablePropertyAccessor.PropertyTokenHolder)pv.resolvedTokens;
        if (tokens == null) {
            AbstractNestablePropertyAccessor nestedPa;
            String propertyName = pv.getName();
            try {
                nestedPa = this.getPropertyAccessorForPropertyPath(propertyName);
            }
            catch (NotReadablePropertyException ex) {
                throw new NotWritablePropertyException(this.getRootClass(), this.getNestedPath() + propertyName, "Nested property in path '" + propertyName + "' does not exist", (Throwable)ex);
            }
            tokens = this.getPropertyNameTokens(this.getFinalPath(nestedPa, propertyName));
            if (nestedPa == this) {
                pv.getOriginalPropertyValue().resolvedTokens = tokens;
            }
            nestedPa.setPropertyValue(tokens, pv);
        } else {
            this.setPropertyValue(tokens, pv);
        }
    }

    private AbstractNestablePropertyAccessor.PropertyTokenHolder getPropertyNameTokens(String propertyName) {
        String actualName = null;
        ArrayList<String> keys = new ArrayList<String>(2);
        int searchIndex = 0;
        while (searchIndex != -1) {
            String key;
            int keyEnd;
            int keyStart = propertyName.indexOf("[", searchIndex);
            searchIndex = -1;
            if (keyStart == -1 || (keyEnd = this.getPropertyNameKeyEnd(propertyName, keyStart + "[".length())) == -1) continue;
            if (actualName == null) {
                actualName = propertyName.substring(0, keyStart);
            }
            if ((key = propertyName.substring(keyStart + "[".length(), keyEnd)).length() > 1 && key.startsWith("'") && key.endsWith("'") || key.startsWith("\"") && key.endsWith("\"")) {
                key = key.substring(1, key.length() - 1);
            }
            keys.add(key);
            searchIndex = keyEnd + "]".length();
        }
        AbstractNestablePropertyAccessor.PropertyTokenHolder tokens = new AbstractNestablePropertyAccessor.PropertyTokenHolder(actualName != null ? actualName : propertyName);
        if (!keys.isEmpty()) {
            tokens.canonicalName = tokens.canonicalName + "[" + StringUtils.collectionToDelimitedString(keys, (String)"][") + "]";
            tokens.keys = StringUtils.toStringArray(keys);
        }
        return tokens;
    }

    private int getPropertyNameKeyEnd(String propertyName, int startIndex) {
        int unclosedPrefixes = 0;
        int length = propertyName.length();
        block4: for (int i = startIndex; i < length; ++i) {
            switch (propertyName.charAt(i)) {
                case '[': {
                    ++unclosedPrefixes;
                    continue block4;
                }
                case ']': {
                    if (unclosedPrefixes == 0) {
                        return i;
                    }
                    --unclosedPrefixes;
                }
            }
        }
        return -1;
    }

    @Nullable
    protected HussarBeanPropertyHandler getLocalPropertyHandler(String propertyName) {
        CachedIntrospectionResults introspectionResults = this.getCachedIntrospectionResults();
        PropertyDescriptor pd = introspectionResults.getPropertyDescriptor(propertyName);
        return pd != null ? new HussarBeanPropertyHandler(pd) : null;
    }

    private PropertyDescriptor getExpansionMapPropertyDescriptor(String propertyName, CachedIntrospectionResults introspectionResults) {
        Class beanClass = introspectionResults.getBeanClass();
        PropertyDescriptor propertyDescriptor = introspectionResults.getPropertyDescriptor(this.hussarExpansionProperties.getPropertyMapPropertyName());
        if (HussarUtils.isNotEmpty((Object)propertyDescriptor)) {
            return propertyDescriptor;
        }
        boolean assignable = ClassUtil.isAssignable(ExpansionMapEntity.class, (Class)beanClass);
        if (assignable) {
            propertyDescriptor = introspectionResults.getPropertyDescriptor("expansionMap");
        }
        return propertyDescriptor;
    }

    protected HussarBeanWrapperImpl newNestedPropertyAccessor(Object object, String nestedPath) {
        return new HussarBeanWrapperImpl(object, nestedPath, this, this.hussarExpansionProperties);
    }

    protected NotWritablePropertyException createNotWritablePropertyException(String propertyName) {
        PropertyMatches matches = PropertyMatches.forProperty((String)propertyName, (Class)this.getRootClass());
        throw new NotWritablePropertyException(this.getRootClass(), this.getNestedPath() + propertyName, matches.buildErrorMessage(), matches.getPossibleMatches());
    }

    public PropertyDescriptor[] getPropertyDescriptors() {
        return this.getCachedIntrospectionResults().getPropertyDescriptors();
    }

    public PropertyDescriptor getPropertyDescriptor(String propertyName) throws InvalidPropertyException {
        HussarBeanWrapperImpl nestedBw = (HussarBeanWrapperImpl)this.getPropertyAccessorForPropertyPath(propertyName);
        String finalPath = this.getFinalPath(nestedBw, propertyName);
        PropertyDescriptor pd = nestedBw.getCachedIntrospectionResults().getPropertyDescriptor(finalPath);
        if (pd == null) {
            throw new InvalidPropertyException(this.getRootClass(), this.getNestedPath() + propertyName, "No property '" + propertyName + "' found");
        }
        return pd;
    }

    public HussarExpansionProperties getHussarExpansionProperties() {
        return this.hussarExpansionProperties;
    }

    public void setHussarExpansionProperties(HussarExpansionProperties hussarExpansionProperties) {
        this.hussarExpansionProperties = hussarExpansionProperties;
    }

    private class HussarBeanPropertyHandler
    extends AbstractNestablePropertyAccessor.PropertyHandler {
        private final PropertyDescriptor pd;

        public HussarBeanPropertyHandler(PropertyDescriptor pd) {
            super(pd.getPropertyType(), pd.getReadMethod() != null, pd.getWriteMethod() != null);
            this.pd = pd;
        }

        public ResolvableType getResolvableType() {
            return ResolvableType.forMethodReturnType((Method)this.pd.getReadMethod());
        }

        public TypeDescriptor toTypeDescriptor() {
            return new TypeDescriptor(HussarBeanWrapperImpl.this.property(this.pd));
        }

        @Nullable
        public TypeDescriptor nested(int level) {
            return TypeDescriptor.nested((Property)HussarBeanWrapperImpl.this.property(this.pd), (int)level);
        }

        @Nullable
        public Object getValue() throws Exception {
            Method readMethod = this.pd.getReadMethod();
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(() -> {
                    ReflectionUtils.makeAccessible((Method)readMethod);
                    return null;
                });
                try {
                    return AccessController.doPrivileged(() -> readMethod.invoke(HussarBeanWrapperImpl.this.getWrappedInstance(), (Object[])null), HussarBeanWrapperImpl.this.acc);
                }
                catch (PrivilegedActionException pae) {
                    throw pae.getException();
                }
            }
            ReflectionUtils.makeAccessible((Method)readMethod);
            return readMethod.invoke(HussarBeanWrapperImpl.this.getWrappedInstance(), (Object[])null);
        }

        public void setValue(@Nullable Object value) throws Exception {
            Method writeMethod;
            Method method = writeMethod = this.pd instanceof GenericTypeAwarePropertyDescriptor ? ((GenericTypeAwarePropertyDescriptor)this.pd).getWriteMethodForActualAccess() : this.pd.getWriteMethod();
            if (System.getSecurityManager() != null) {
                AccessController.doPrivileged(() -> {
                    ReflectionUtils.makeAccessible((Method)writeMethod);
                    return null;
                });
                try {
                    AccessController.doPrivileged(() -> writeMethod.invoke(HussarBeanWrapperImpl.this.getWrappedInstance(), value), HussarBeanWrapperImpl.this.acc);
                }
                catch (PrivilegedActionException ex) {
                    throw ex.getException();
                }
            } else {
                ReflectionUtils.makeAccessible((Method)writeMethod);
                writeMethod.invoke(HussarBeanWrapperImpl.this.getWrappedInstance(), value);
            }
        }
    }
}

