/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.expansion.plugin.mvc.serializer;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.PropertyMetadata;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.SerializationConfig;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.ser.AnyGetterWriter;
import com.fasterxml.jackson.databind.ser.BeanPropertyWriter;
import com.fasterxml.jackson.databind.ser.BeanSerializerBuilder;
import com.fasterxml.jackson.databind.ser.BeanSerializerModifier;
import com.fasterxml.jackson.databind.ser.std.MapSerializer;
import com.fasterxml.jackson.databind.type.ArrayType;
import com.fasterxml.jackson.databind.type.CollectionLikeType;
import com.fasterxml.jackson.databind.type.CollectionType;
import com.fasterxml.jackson.databind.type.MapLikeType;
import com.fasterxml.jackson.databind.type.MapType;
import com.fasterxml.jackson.datatype.jsr310.ser.LocalDateTimeSerializer;
import com.jxdinfo.hussar.platform.core.utils.DateTimeUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.expansion.core.config.HussarExpansionProperties;
import com.jxdinfo.hussar.support.expansion.plugin.mvc.ExpansionMvcUtils;
import com.jxdinfo.hussar.support.expansion.plugin.mvc.serializer.ExpansionAnyGetterWriter;
import java.util.List;
import java.util.Set;

public class HussarExpansionBeanSerializerModifier
extends BeanSerializerModifier {
    private HussarExpansionProperties hussarExpansionProperties;

    public HussarExpansionBeanSerializerModifier(HussarExpansionProperties hussarExpansionProperties) {
        this.hussarExpansionProperties = hussarExpansionProperties;
    }

    public List<BeanPropertyWriter> changeProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        return super.changeProperties(config, beanDesc, beanProperties);
    }

    public List<BeanPropertyWriter> orderProperties(SerializationConfig config, BeanDescription beanDesc, List<BeanPropertyWriter> beanProperties) {
        return super.orderProperties(config, beanDesc, beanProperties);
    }

    public BeanSerializerBuilder updateBuilder(SerializationConfig config, BeanDescription beanDesc, BeanSerializerBuilder builder) {
        BeanPropertyDefinition beanPropertyDefinition = ExpansionMvcUtils.doGetExpansionMapKey(beanDesc, this.hussarExpansionProperties);
        if (HussarUtils.isEmpty((Object)beanPropertyDefinition)) {
            return builder;
        }
        AnnotatedMethod mapGetter = beanPropertyDefinition.getGetter();
        AnnotatedMethod mapSetter = beanPropertyDefinition.getSetter();
        if (HussarUtils.isEmpty((Object)mapGetter) || HussarUtils.isEmpty((Object)mapSetter)) {
            return builder;
        }
        JavaType anyType = mapGetter.getType();
        JavaType valueType = anyType.getContentType();
        MapSerializer anySer = MapSerializer.construct((Set)null, (JavaType)anyType, (boolean)config.isEnabled(MapperFeature.USE_STATIC_TYPING), null, null, null, null);
        PropertyName name = PropertyName.construct((String)mapGetter.getName());
        BeanProperty.Std anyProp = new BeanProperty.Std(name, valueType, null, (AnnotatedMember)mapGetter, PropertyMetadata.STD_OPTIONAL);
        builder.setAnyGetter((AnyGetterWriter)new ExpansionAnyGetterWriter((BeanProperty)anyProp, (AnnotatedMember)mapGetter, (JsonSerializer<?>)anySer, (AnnotatedMember)mapSetter, this.hussarExpansionProperties, beanPropertyDefinition));
        return builder;
    }

    public JsonSerializer<?> modifySerializer(SerializationConfig config, BeanDescription beanDesc, JsonSerializer<?> serializer) {
        if (serializer instanceof LocalDateTimeSerializer) {
            return new LocalDateTimeSerializer(DateTimeUtil.DATETIME_FORMAT);
        }
        return super.modifySerializer(config, beanDesc, serializer);
    }

    public JsonSerializer<?> modifyArraySerializer(SerializationConfig config, ArrayType valueType, BeanDescription beanDesc, JsonSerializer<?> serializer) {
        return super.modifyArraySerializer(config, valueType, beanDesc, serializer);
    }

    public JsonSerializer<?> modifyCollectionSerializer(SerializationConfig config, CollectionType valueType, BeanDescription beanDesc, JsonSerializer<?> serializer) {
        return super.modifyCollectionSerializer(config, valueType, beanDesc, serializer);
    }

    public JsonSerializer<?> modifyCollectionLikeSerializer(SerializationConfig config, CollectionLikeType valueType, BeanDescription beanDesc, JsonSerializer<?> serializer) {
        return super.modifyCollectionLikeSerializer(config, valueType, beanDesc, serializer);
    }

    public JsonSerializer<?> modifyMapSerializer(SerializationConfig config, MapType valueType, BeanDescription beanDesc, JsonSerializer<?> serializer) {
        return super.modifyMapSerializer(config, valueType, beanDesc, serializer);
    }

    public JsonSerializer<?> modifyMapLikeSerializer(SerializationConfig config, MapLikeType valueType, BeanDescription beanDesc, JsonSerializer<?> serializer) {
        return super.modifyMapLikeSerializer(config, valueType, beanDesc, serializer);
    }

    public JsonSerializer<?> modifyEnumSerializer(SerializationConfig config, JavaType valueType, BeanDescription beanDesc, JsonSerializer<?> serializer) {
        return super.modifyEnumSerializer(config, valueType, beanDesc, serializer);
    }

    public JsonSerializer<?> modifyKeySerializer(SerializationConfig config, JavaType valueType, BeanDescription beanDesc, JsonSerializer<?> serializer) {
        return super.modifyKeySerializer(config, valueType, beanDesc, serializer);
    }
}

