/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.expansion.plugin.mvc.deserializer;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.deser.BeanDeserializerBuilder;
import com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import com.fasterxml.jackson.databind.deser.SettableAnyProperty;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.introspect.AnnotatedField;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.type.ReferenceType;
import com.fasterxml.jackson.datatype.jsr310.deser.LocalDateTimeDeserializer;
import com.jxdinfo.hussar.platform.core.serialize.HussarLocalDateTimeDeserializer;
import com.jxdinfo.hussar.platform.core.utils.DateTimeUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.ReflectUtil;
import com.jxdinfo.hussar.support.expansion.core.config.HussarExpansionProperties;
import com.jxdinfo.hussar.support.expansion.plugin.mvc.ExpansionMvcUtils;
import com.jxdinfo.hussar.support.expansion.plugin.mvc.deserializer.ExpansionSettableAnyProperty;
import java.util.List;

public class HussarExpansionBeanDeserializerModifier
extends BeanDeserializerModifier {
    private HussarExpansionProperties hussarExpansionProperties;

    public HussarExpansionBeanDeserializerModifier(HussarExpansionProperties hussarExpansionProperties) {
        this.hussarExpansionProperties = hussarExpansionProperties;
    }

    public List<BeanPropertyDefinition> updateProperties(DeserializationConfig config, BeanDescription beanDesc, List<BeanPropertyDefinition> propDefs) {
        return super.updateProperties(config, beanDesc, propDefs);
    }

    public BeanDeserializerBuilder updateBuilder(DeserializationConfig config, BeanDescription beanDesc, BeanDeserializerBuilder builder) {
        BeanPropertyDefinition beanPropertyDefinition = ExpansionMvcUtils.doGetExpansionMapKey(beanDesc, this.hussarExpansionProperties);
        if (HussarUtils.isEmpty((Object)beanPropertyDefinition)) {
            return builder;
        }
        SettableBeanProperty settableBeanProperty = builder.findProperty(PropertyName.construct((String)beanPropertyDefinition.getName()));
        JavaType type = settableBeanProperty.getType();
        JavaType contentType = type.getContentType();
        ExpansionSettableAnyProperty expansionSettableAnyProperty = null;
        AnnotatedField setterAndField = beanPropertyDefinition.getField();
        AnnotatedMethod getter = null;
        if (HussarUtils.isEmpty((Object)setterAndField)) {
            setterAndField = beanPropertyDefinition.getSetter();
            getter = beanPropertyDefinition.getGetter();
        }
        if (HussarUtils.isEmpty((Object)setterAndField)) {
            return super.updateBuilder(config, beanDesc, builder);
        }
        if (setterAndField instanceof AnnotatedField) {
            expansionSettableAnyProperty = new ExpansionSettableAnyProperty((BeanProperty)settableBeanProperty, (AnnotatedMember)setterAndField, contentType);
        } else if (setterAndField instanceof AnnotatedMethod && HussarUtils.isNotEmpty((Object)getter)) {
            expansionSettableAnyProperty = new ExpansionSettableAnyProperty((BeanProperty)settableBeanProperty, (AnnotatedMember)setterAndField, (AnnotatedMember)getter, contentType);
        }
        if (HussarUtils.isNotEmpty(expansionSettableAnyProperty)) {
            if (HussarUtils.isNotEmpty((Object)builder.getAnySetter())) {
                ReflectUtil.setFieldValue((Object)builder, (String)"_anySetter", null);
            }
            builder.setAnySetter((SettableAnyProperty)expansionSettableAnyProperty);
        }
        return super.updateBuilder(config, beanDesc, builder);
    }

    public KeyDeserializer modifyKeyDeserializer(DeserializationConfig config, JavaType type, KeyDeserializer deserializer) {
        return super.modifyKeyDeserializer(config, type, deserializer);
    }

    public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
        if (deserializer instanceof LocalDateTimeDeserializer) {
            return new HussarLocalDateTimeDeserializer(DateTimeUtil.DATETIME_FORMAT);
        }
        return super.modifyDeserializer(config, beanDesc, deserializer);
    }

    public JsonDeserializer<?> modifyReferenceDeserializer(DeserializationConfig config, ReferenceType type, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
        return super.modifyReferenceDeserializer(config, type, beanDesc, deserializer);
    }
}

