/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.beans;

import com.jxdinfo.hussar.platform.core.base.entity.ExpansionMapEntity;
import com.jxdinfo.hussar.platform.core.utils.ClassUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.expansion.core.config.HussarExpansionProperties;
import com.jxdinfo.hussar.support.expansion.plugin.mvc.bindingresult.HussarBeanPropertyBindingResult;
import java.beans.PropertyDescriptor;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.CachedIntrospectionResults;
import org.springframework.beans.ExpansionPropertyPath;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.PropertyAccessorUtils;
import org.springframework.beans.PropertyValue;
import org.springframework.http.HttpMethod;
import org.springframework.lang.Nullable;
import org.springframework.util.StringUtils;
import org.springframework.validation.AbstractPropertyBindingResult;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.ServletRequestParameterPropertyValues;
import org.springframework.web.multipart.MultipartRequest;
import org.springframework.web.multipart.support.StandardServletPartUtils;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.util.WebUtils;

public class HussarExtendedServletRequestDataBinder
extends ServletRequestDataBinder {
    HussarExpansionProperties hussarExpansionProperties;

    public HussarExtendedServletRequestDataBinder(@Nullable Object target) {
        super(target);
    }

    public HussarExtendedServletRequestDataBinder(@Nullable Object target, String objectName) {
        super(target, objectName);
    }

    public HussarExtendedServletRequestDataBinder(Object target, HussarExpansionProperties hussarExpansionProperties) {
        super(target);
        this.hussarExpansionProperties = hussarExpansionProperties;
    }

    public HussarExtendedServletRequestDataBinder(Object target, String objectName, HussarExpansionProperties hussarExpansionProperties) {
        super(target, objectName);
        this.hussarExpansionProperties = hussarExpansionProperties;
    }

    protected AbstractPropertyBindingResult createBeanPropertyBindingResult() {
        AbstractPropertyBindingResult beanPropertyBindingResult = super.createBeanPropertyBindingResult();
        HussarBeanPropertyBindingResult result = new HussarBeanPropertyBindingResult(this.getTarget(), this.getObjectName(), this.isAutoGrowNestedPaths(), this.getAutoGrowCollectionLimit());
        result.setHussarExpansionProperties(this.hussarExpansionProperties);
        if (this.getConversionService() != null) {
            result.initConversion(this.getConversionService());
        }
        if (HussarUtils.isNotEmpty((Object)beanPropertyBindingResult.getMessageCodesResolver())) {
            result.setMessageCodesResolver(beanPropertyBindingResult.getMessageCodesResolver());
        }
        return result;
    }

    protected void addBindValues(MutablePropertyValues mpvs, ServletRequest request) {
        String attr = HandlerMapping.URI_TEMPLATE_VARIABLES_ATTRIBUTE;
        Map uriVars = (Map)request.getAttribute(attr);
        if (uriVars != null) {
            uriVars.forEach((name, value) -> {
                if (mpvs.contains(name)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("URI variable '" + name + "' overridden by request bind value."));
                    }
                } else {
                    mpvs.addPropertyValue(name, value);
                }
            });
        }
    }

    public void bind(ServletRequest request) {
        HttpServletRequest httpServletRequest;
        ServletRequestParameterPropertyValues mpvs = new ServletRequestParameterPropertyValues(request);
        MultipartRequest multipartRequest = (MultipartRequest)WebUtils.getNativeRequest((ServletRequest)request, MultipartRequest.class);
        if (multipartRequest != null) {
            this.bindMultipart((Map)multipartRequest.getMultiFileMap(), (MutablePropertyValues)mpvs);
        } else if (StringUtils.startsWithIgnoreCase((String)request.getContentType(), (String)"multipart/form-data") && (httpServletRequest = (HttpServletRequest)WebUtils.getNativeRequest((ServletRequest)request, HttpServletRequest.class)) != null && HttpMethod.POST.matches(httpServletRequest.getMethod())) {
            StandardServletPartUtils.bindParts((HttpServletRequest)httpServletRequest, (MutablePropertyValues)mpvs, (boolean)this.isBindEmptyMultipartFiles());
        }
        CachedIntrospectionResults cachedIntrospectionResults = CachedIntrospectionResults.forClass(this.getTarget().getClass());
        mpvs = this.changeMutablePropertyValues(cachedIntrospectionResults, (MutablePropertyValues)mpvs);
        this.addBindValues((MutablePropertyValues)mpvs, request);
        super.doBind((MutablePropertyValues)mpvs);
    }

    private MutablePropertyValues changeMutablePropertyValues(CachedIntrospectionResults cachedIntrospectionResults, MutablePropertyValues mpvs) {
        if (HussarUtils.isEmpty((Object)this.hussarExpansionProperties) || !this.hussarExpansionProperties.isEnable() || HussarUtils.isEmpty((Object)mpvs)) {
            return mpvs;
        }
        HashMap<String, Map<String, Object>> propertyExpansionMap = new HashMap<String, Map<String, Object>>();
        List propertyValueList = mpvs.getPropertyValueList();
        for (PropertyValue propertyValue : propertyValueList) {
            this.doChangeMutablePropertyValues(propertyExpansionMap, propertyValue, cachedIntrospectionResults);
        }
        if (HussarUtils.isNotEmpty(propertyExpansionMap)) {
            for (Map.Entry entry : propertyExpansionMap.entrySet()) {
                mpvs.add((String)entry.getKey(), entry.getValue());
            }
        }
        return mpvs;
    }

    private void doChangeMutablePropertyValues(Map<String, Map<String, Object>> propertyExpansionMap, PropertyValue pv, CachedIntrospectionResults cachedIntrospectionResults) {
        String propertyName = pv.getName();
        ExpansionPropertyPath expansionPropertyPath = this.getExpansionPropertyPath(propertyName);
        String pnName = expansionPropertyPath.getPropertyName();
        if (!StringUtil.startWith((CharSequence)pnName, (CharSequence)this.hussarExpansionProperties.getPrefixProperty())) {
            return;
        }
        String expansionMapKey = this.getExpansionMapKey(expansionPropertyPath, cachedIntrospectionResults);
        Map<Object, Object> propertyExpansionMapValue = null;
        if (HussarUtils.isNotEmpty((Object)expansionMapKey)) {
            String parentPropertyPath = expansionPropertyPath.getParentPropertyPath();
            String propertyExpansionMapkey = null;
            propertyExpansionMapkey = HussarUtils.isNotEmpty((Object)parentPropertyPath) ? parentPropertyPath + "." + expansionMapKey : expansionMapKey;
            if (propertyExpansionMap.containsKey(propertyExpansionMapkey)) {
                propertyExpansionMapValue = propertyExpansionMap.get(propertyExpansionMapkey);
            } else {
                propertyExpansionMapValue = new HashMap();
                propertyExpansionMap.put(propertyExpansionMapkey, propertyExpansionMapValue);
            }
            propertyExpansionMapValue.put(pnName, pv.getValue());
        }
    }

    private ExpansionPropertyPath getExpansionPropertyPath(String propertyPath) {
        int pos = PropertyAccessorUtils.getLastNestedPropertySeparatorIndex((String)propertyPath);
        ExpansionPropertyPath expansionPropertyPath = new ExpansionPropertyPath();
        expansionPropertyPath.setSourcePropertyPath(propertyPath);
        if (pos > -1) {
            String expansionObjectPath = propertyPath.substring(0, pos);
            String expansionPropertyName = propertyPath.substring(pos + 1);
            expansionPropertyPath.setPropertyName(expansionPropertyName);
            expansionPropertyPath.setParentPropertyPath(expansionObjectPath);
        } else {
            expansionPropertyPath.setPropertyName(propertyPath);
        }
        return expansionPropertyPath;
    }

    private String getExpansionMapKey(ExpansionPropertyPath expansionPropertyPath, CachedIntrospectionResults cachedIntrospectionResults) {
        List<String> parentPropertyPathList = expansionPropertyPath.getParentPropertyPathList();
        CachedIntrospectionResults results = null;
        if (HussarUtils.isNotEmpty(parentPropertyPathList)) {
            for (String property : parentPropertyPathList) {
                PropertyDescriptor propertyDescriptor = cachedIntrospectionResults.getPropertyDescriptor(property);
                Class<?> propertyTypeClass = propertyDescriptor.getPropertyType();
                boolean simpleValueType = ClassUtil.isSimpleValueType(propertyTypeClass);
                if (simpleValueType) {
                    return null;
                }
                results = CachedIntrospectionResults.forClass(propertyTypeClass);
            }
        } else {
            results = cachedIntrospectionResults;
        }
        return this.doGetExpansionMapKey(results);
    }

    private String doGetExpansionMapKey(CachedIntrospectionResults cachedIntrospectionResults) {
        PropertyDescriptor propertyDescriptor = cachedIntrospectionResults.getPropertyDescriptor(this.hussarExpansionProperties.getPropertyMapPropertyName());
        if (HussarUtils.isNotEmpty((Object)propertyDescriptor)) {
            return this.hussarExpansionProperties.getPropertyMapPropertyName();
        }
        Class beanClass = cachedIntrospectionResults.getBeanClass();
        boolean assignable = ClassUtil.isAssignable(ExpansionMapEntity.class, (Class)beanClass);
        if (assignable && HussarUtils.isNotEmpty((Object)(propertyDescriptor = cachedIntrospectionResults.getPropertyDescriptor("expansionMap")))) {
            return "expansionMap";
        }
        return null;
    }
}

