/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.expansion.plugin.mvc.bindingresult;

import com.jxdinfo.hussar.support.expansion.core.config.HussarExpansionProperties;
import java.io.Serializable;
import org.springframework.beans.BeanWrapper;
import org.springframework.beans.ConfigurablePropertyAccessor;
import org.springframework.beans.HussarBeanWrapperImpl;
import org.springframework.lang.Nullable;
import org.springframework.validation.AbstractPropertyBindingResult;

public class HussarBeanPropertyBindingResult
extends AbstractPropertyBindingResult
implements Serializable {
    @Nullable
    private final Object target;
    private final boolean autoGrowNestedPaths;
    private final int autoGrowCollectionLimit;
    @Nullable
    private transient BeanWrapper beanWrapper;
    private HussarExpansionProperties hussarExpansionProperties;

    public HussarBeanPropertyBindingResult(@Nullable Object target, String objectName) {
        this(target, objectName, true, Integer.MAX_VALUE);
    }

    public HussarBeanPropertyBindingResult(@Nullable Object target, String objectName, boolean autoGrowNestedPaths, int autoGrowCollectionLimit) {
        super(objectName);
        this.target = target;
        this.autoGrowNestedPaths = autoGrowNestedPaths;
        this.autoGrowCollectionLimit = autoGrowCollectionLimit;
    }

    @Nullable
    public final Object getTarget() {
        return this.target;
    }

    public final ConfigurablePropertyAccessor getPropertyAccessor() {
        if (this.beanWrapper == null) {
            this.beanWrapper = this.createBeanWrapper();
            this.beanWrapper.setExtractOldValueForEditor(true);
            this.beanWrapper.setAutoGrowNestedPaths(this.autoGrowNestedPaths);
            this.beanWrapper.setAutoGrowCollectionLimit(this.autoGrowCollectionLimit);
        }
        return this.beanWrapper;
    }

    protected BeanWrapper createBeanWrapper() {
        if (this.target == null) {
            throw new IllegalStateException("Cannot access properties on null bean instance '" + this.getObjectName() + "'");
        }
        return new HussarBeanWrapperImpl(this.target, this.hussarExpansionProperties);
    }

    public HussarExpansionProperties getHussarExpansionProperties() {
        return this.hussarExpansionProperties;
    }

    public void setHussarExpansionProperties(HussarExpansionProperties hussarExpansionProperties) {
        this.hussarExpansionProperties = hussarExpansionProperties;
    }
}

