/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.sync;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.cache.support.properties.HussarCacheProperties;
import com.jxdinfo.hussar.support.datasource.support.service.DynamicDatasourceService;
import com.jxdinfo.hussar.support.engine.api.entity.Dataservice;
import com.jxdinfo.hussar.support.engine.api.entity.DataserviceInout;
import com.jxdinfo.hussar.support.engine.api.enums.InoutType;
import com.jxdinfo.hussar.support.engine.api.factory.ApiActionFactory;
import com.jxdinfo.hussar.support.engine.api.model.DataserviceDto;
import com.jxdinfo.hussar.support.engine.api.service.DataserviceService;
import com.jxdinfo.hussar.support.engine.api.service.UnderlyingService;
import com.jxdinfo.hussar.support.engine.core.annotations.EngineMethod;
import com.jxdinfo.hussar.support.engine.core.annotations.EngineService;
import com.jxdinfo.hussar.support.engine.core.enums.EngineExceptionEnum;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.support.service.DataserviceInoutService;
import com.jxdinfo.hussar.support.engine.properties.EngineProperties;
import com.jxdinfo.hussar.support.mp.base.service.HussarService;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.util.ClassUtils;

public class EngineMethodTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(EngineMethodTask.class);
    private final Set<String> checkMap = new HashSet<String>();
    private RedisTemplate<String, String> redisTemplate;
    private String engineMethodTaskLock = "EngineMethodTaskLock";
    private int timeout = 60;

    public EngineMethodTask(RedisTemplate<String, String> redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public EngineMethodTask() {
    }

    @Override
    public void run() {
        boolean initMethod;
        HussarCacheProperties hussarCacheProperties = (HussarCacheProperties)SpringContextUtil.getBean(HussarCacheProperties.class);
        DynamicDatasourceService bean = (DynamicDatasourceService)SpringContextUtil.getBean(DynamicDatasourceService.class);
        String jdbcUrl = bean.getCurrentDatasource().getUrl();
        if (HussarUtils.isNotEmpty((Object)jdbcUrl)) {
            int questionMarkIndex = jdbcUrl.indexOf("?");
            String dbUrl = questionMarkIndex != -1 ? jdbcUrl.substring(0, questionMarkIndex) : jdbcUrl;
            this.engineMethodTaskLock = this.engineMethodTaskLock + dbUrl;
        }
        String cacheType = hussarCacheProperties.getCacheType();
        Boolean redisUnLock = true;
        if (HussarUtils.equals((Object)cacheType, (Object)"redis") && HussarUtils.isNotEmpty(this.redisTemplate)) {
            redisUnLock = this.redisTemplate.opsForValue().setIfAbsent((Object)this.engineMethodTaskLock, (Object)"locked", (long)this.timeout, TimeUnit.SECONDS);
        }
        if (!(initMethod = ((EngineProperties)SpringContextUtil.getBean(EngineProperties.class)).getInitMethod()) || !redisUnLock.booleanValue()) {
            return;
        }
        ArrayList<Dataservice> list = new ArrayList<Dataservice>();
        ArrayList<DataserviceInout> inoutList = new ArrayList<DataserviceInout>();
        this.renderClass(list, inoutList);
        this.saveDataService(list, inoutList);
        Map dataserviceMap = list.stream().collect(Collectors.toMap(Dataservice::getUniqueCode, Function.identity(), (k1, k2) -> k1));
        ApiActionFactory.setDataServiceMap(dataserviceMap);
        if (HussarUtils.equals((Object)cacheType, (Object)"redis") && HussarUtils.isNotEmpty(this.redisTemplate)) {
            this.redisTemplate.delete((Object)this.engineMethodTaskLock);
        }
    }

    private void saveDataService(List<Dataservice> list, List<DataserviceInout> inoutList) {
        DataserviceService service = (DataserviceService)SpringContextUtil.getBean(DataserviceService.class);
        DataserviceInoutService inoutService = (DataserviceInoutService)SpringContextUtil.getBean(DataserviceInoutService.class);
        Map map = service.mapDataServiceDto();
        if (map.isEmpty()) {
            inoutService.remove((Wrapper)Wrappers.lambdaQuery(DataserviceInout.class).isNotNull(DataserviceInout::getInoutId));
            this.saveBatch((List)list, (HussarService)service);
            this.saveBatch((List)inoutList, (HussarService)inoutService);
            return;
        }
        for (Dataservice dataservice : list) {
            if (!map.containsKey(dataservice.getUniqueCode())) continue;
            DataserviceDto dataserviceDto = (DataserviceDto)map.get(dataservice.getUniqueCode());
            Long dataserviceId = dataservice.getDataserviceId();
            dataservice.setDataserviceId(dataserviceDto.getDataserviceId());
            List dataserviceInoutList = inoutService.list((Wrapper)Wrappers.lambdaQuery(DataserviceInout.class).eq(DataserviceInout::getDataServiceId, (Object)dataservice.getDataserviceId()));
            this.resetInoutList(inoutList, dataserviceId, dataserviceInoutList, dataservice.getDataserviceId());
        }
        this.saveOrUpdateBatch((List)list, (HussarService)service);
        this.saveOrUpdateBatch((List)inoutList, (HussarService)inoutService);
    }

    private void resetInoutList(List<DataserviceInout> inoutList, Long dataServiceId, List<DataserviceInout> dataserviceInoutList, Long newDataServiceId) {
        for (DataserviceInout inout : inoutList) {
            if (!inout.getDataServiceId().equals(dataServiceId)) continue;
            inout.setDataServiceId(newDataServiceId);
            for (DataserviceInout dataserviceInout : dataserviceInoutList) {
                if (!HussarUtils.equals((Object)inout.getInoutType(), (Object)dataserviceInout.getInoutType()) || !HussarUtils.equals((Object)inout.getInoutAlies(), (Object)dataserviceInout.getInoutAlies())) continue;
                inout.setInoutId(dataserviceInout.getInoutId());
            }
        }
    }

    private void renderClass(List<Dataservice> list, List<DataserviceInout> inoutList) {
        for (UnderlyingService bean : SpringContextUtil.getBeansByClass(UnderlyingService.class)) {
            Class<?> beanClass = this.getClass(bean.getClass());
            EngineService serviceAnnotation = beanClass.getAnnotation(EngineService.class);
            if (serviceAnnotation == null) continue;
            this.renderMethods(list, inoutList, beanClass.getMethods(), serviceAnnotation);
        }
    }

    private void renderMethods(List<Dataservice> list, List<DataserviceInout> inoutList, Method[] methods, EngineService serviceAnnotation) {
        for (Method method : methods) {
            String serviceName;
            EngineMethod methodAnnotation = method.getAnnotation(EngineMethod.class);
            String beanName = serviceAnnotation.value();
            String string = serviceName = beanName.contains(".") ? beanName.substring(beanName.lastIndexOf(".") + 1) : beanName;
            if (methodAnnotation == null || !this.checkMap.add(beanName + method.getName())) continue;
            Long dataServiceId = EngineUtil.getId();
            Dataservice dataservice = new Dataservice(dataServiceId, Integer.valueOf(serviceAnnotation.type().getValue()), beanName, serviceAnnotation.des(), method.getName(), methodAnnotation.des(), serviceName);
            DataserviceInout out = new DataserviceInout(dataServiceId, InoutType.OUT.getValue(), method.getReturnType().getName(), "", Integer.valueOf(1), methodAnnotation.returnDes());
            this.renderParams(inoutList, method.getParameters(), dataServiceId, methodAnnotation.paramDes(), methodAnnotation.paramAlias());
            list.add(dataservice);
            inoutList.add(out);
        }
    }

    private void renderParams(List<DataserviceInout> inoutList, Parameter[] parameters, Long dataServiceId, String[] paramDes, String[] paramAlias) {
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            if (Consumer.class.equals(parameter.getType())) continue;
            String des = paramDes.length > i ? paramDes[i] : "";
            String parameterName = paramAlias.length > i && HussarUtils.isNotBlank((CharSequence)paramAlias[i]) ? paramAlias[i] : parameter.getName();
            DataserviceInout in = new DataserviceInout(dataServiceId, InoutType.IN.getValue(), parameter.getType().getName(), parameterName, Integer.valueOf(i + 1), des);
            inoutList.add(in);
        }
    }

    private Class<?> getClass(Class<?> clazz) {
        return ClassUtils.getUserClass(clazz);
    }

    private <T> void saveBatch(List<T> list, HussarService<T> service) {
        try {
            for (List partition : Lists.partition(list, (int)500)) {
                service.saveBatch((Collection)partition);
            }
        }
        catch (Exception e) {
            logger.error(EngineExceptionEnum.CODE_FAIL.getMessage(), (Throwable)e);
        }
    }

    private <T> void saveOrUpdateBatch(List<T> list, HussarService<T> service) {
        try {
            for (List partition : Lists.partition(list, (int)500)) {
                service.saveOrUpdateBatch((Collection)partition);
            }
        }
        catch (Exception e) {
            logger.error(EngineExceptionEnum.CODE_FAIL.getMessage(), (Throwable)e);
        }
    }
}

