/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.handler;

import com.alibaba.fastjson.JSON;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelFieldDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelFieldRulesDto;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessVo;
import com.jxdinfo.hussar.support.engine.api.model.SQLModel;
import com.jxdinfo.hussar.support.engine.api.support.solidorg.handler.EngineParamHandler;
import com.jxdinfo.hussar.support.engine.core.model.EngineResultEntity;
import com.jxdinfo.hussar.support.engine.handler.AbstractEngineDictTransHandler;
import com.jxdinfo.hussar.support.engine.plugin.model.dto.SQLModelExtendInfo;
import com.jxdinfo.hussar.support.engine.plugin.model.service.SQLModelService;
import com.jxdinfo.hussar.support.transdict.core.anno.Trans;
import com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil;
import com.jxdinfo.hussar.support.transdict.extend.formdesign.extend.CustomClassContent;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="hussar.engine", name={"trans"}, havingValue="true", matchIfMissing=true)
public class EngineCustomSqlDictTransHandler
extends AbstractEngineDictTransHandler
implements EngineParamHandler {
    protected static final Logger logger = LoggerFactory.getLogger(EngineCustomSqlDictTransHandler.class);
    private final SQLModelService sqlModelService;

    public EngineCustomSqlDictTransHandler(SQLModelService sqlModelService) {
        this.sqlModelService = sqlModelService;
    }

    public void resultHandling(Object result, NodeBusinessVo nodeBusiness) {
        String actionName = nodeBusiness.getActionName();
        if (!"sqlModelCustomSql".equals(actionName)) {
            return;
        }
        SQLModel sqlModel = this.sqlModelService.getModelByTfId(nodeBusiness.getTfModelId());
        SQLModelExtendInfo sqlModelExtendInfo = (SQLModelExtendInfo)JSON.parseObject((String)sqlModel.getJsonParam(), SQLModelExtendInfo.class);
        List fieldList = sqlModelExtendInfo.getFieldList();
        HashMap<String, List<ModelFieldRulesDto>> fieldRuleMap = new HashMap<String, List<ModelFieldRulesDto>>();
        this.getRules(fieldList, fieldRuleMap);
        if (HussarUtils.isEmpty(fieldRuleMap)) {
            return;
        }
        CustomClassContent.Builder builder = new CustomClassContent.Builder();
        Set<String> refSet = this.transFields(fieldList, nodeBusiness.getTfModelId(), fieldRuleMap, builder);
        if (HussarUtils.isNotEmpty((Object)((List)result)) && ((List)result).get(0) instanceof EngineResultEntity) {
            this.addProperties((List)result, refSet, null);
        }
        TransUtil.trans((List)((List)result), (CustomClassContent)builder.builder());
    }

    public int getOrder() {
        return 0;
    }

    private void getRules(List<ModelFieldDto> fieldList, Map<String, List<ModelFieldRulesDto>> fieldRuleMap) {
        for (ModelFieldDto modelFieldDto : fieldList) {
            if (!HussarUtils.isNotEmpty((Object)modelFieldDto.getFieldRules())) continue;
            fieldRuleMap.put(modelFieldDto.getFieldAlias(), modelFieldDto.getFieldRules());
        }
    }

    private Set<String> transFields(List<ModelFieldDto> fields, String tfModelId, Map<String, List<ModelFieldRulesDto>> rulesMap, CustomClassContent.Builder builder) {
        builder.setId(tfModelId);
        ArrayList<Map<String, Object>> annotationValueList = new ArrayList<Map<String, Object>>();
        HashSet<String> columnName = new HashSet<String>();
        for (ModelFieldDto field : fields) {
            Class<Trans> transClass = Trans.class;
            String columnAlias = field.getFieldAlias();
            if (!columnName.add(columnAlias)) continue;
            List<ModelFieldRulesDto> modelFieldRules = rulesMap.get(columnAlias);
            Class javaClass = null;
            try {
                javaClass = field.javaType();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            HashMap<String, Object> annotationValue = null;
            if (HussarUtils.isNotEmpty(modelFieldRules)) {
                annotationValue = new HashMap<String, Object>();
                String ruleContent = modelFieldRules.get(0).getRuleContent();
                this.transQueryValue(ruleContent, annotationValue);
                annotationValueList.add(annotationValue);
            } else {
                transClass = null;
            }
            builder.defineField(columnAlias, (Type)javaClass, transClass, annotationValue);
        }
        HashSet<String> refSet = new HashSet<String>();
        this.getRefSettings(annotationValueList, refSet);
        for (String ref : refSet) {
            builder.defineField(ref, Object.class);
        }
        return refSet;
    }
}

