/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.trans.service.impl;

import com.jxdinfo.hussar.common.exception.BaseException;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.SelectEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.support.service.SingleTableService;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlEntityUtil;
import com.jxdinfo.hussar.support.engine.plugin.model.application.IEnginePluginModelApp;
import com.jxdinfo.hussar.support.engine.trans.model.dto.DictModelDto;
import com.jxdinfo.hussar.support.engine.trans.service.MsTransDictService;
import com.jxdinfo.hussar.support.transdict.extend.formdesign.DictTranContent;
import com.jxdinfo.hussar.support.transdict.extend.formdesign.TransAbleMapping;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
public class EngineTransMapping
implements TransAbleMapping {
    private static final String ENGINE = "engine";
    private final MsTransDictService msTransDictService;
    private final SingleTableService singleTableService;
    private final IEnginePluginModelApp iEnginePluginModelApp;

    public EngineTransMapping(MsTransDictService msTransDictService, SingleTableService singleTableService, IEnginePluginModelApp iEnginePluginModelApp) {
        this.msTransDictService = msTransDictService;
        this.singleTableService = singleTableService;
        this.iEnginePluginModelApp = iEnginePluginModelApp;
    }

    public boolean match(String nameSpace, String type) {
        try {
            String[] split = nameSpace.split("\\.");
            if (HussarUtils.equals((Object)ENGINE, (Object)split[0]) && split.length == 2 && split[1].matches("\\d+")) {
                return true;
            }
        }
        catch (BaseException baseException) {
            // empty catch block
        }
        return false;
    }

    public Object getById(Object o, DictTranContent dictTranContent) {
        return null;
    }

    public String keyProperty() {
        return null;
    }

    public <T> List<T> listByMap(Map<String, Object> param, DictTranContent dictTranContent) {
        String namespace = dictTranContent.getFieldsTrans().namespace();
        String modelId = namespace.split("\\.")[1];
        ModelTableMappingDTO modelTableMapping = this.iEnginePluginModelApp.getModelTableMapping(Long.valueOf(modelId));
        DictModelDto dictModelDto = new DictModelDto();
        dictModelDto.setModel(modelTableMapping);
        dictModelDto.setParams(param);
        if (modelTableMapping.getSlaveTables().size() > 0) {
            PageVo pageVo = this.msTransDictService.findMsDictModelInfo(dictModelDto);
            return pageVo.getData();
        }
        SelectEntity selectEntity = this.getSelectEntity(dictModelDto.getModel(), param);
        PageVo pageVo = this.singleTableService.selectList(selectEntity);
        return pageVo.getData();
    }

    public int getOrder() {
        return 0;
    }

    private SelectEntity getSelectEntity(ModelTableMappingDTO model, Map<String, Object> params) {
        HashMap map = new HashMap();
        List columns = model.getColumns();
        if (HussarUtils.isNotEmpty(params)) {
            params.forEach((k, v) -> {
                if (k.matches("\\d+")) {
                    map.put(Long.valueOf(k), v);
                } else {
                    columns.stream().filter(c -> c.getColumnAlias().equals(k)).findFirst().ifPresent(c -> map.put(c.getColumnId(), v));
                }
            });
            SelectEntity selectEntity = new DmlEntityUtil.DmlServiceEntity(model).selectByColumns(map);
            return selectEntity;
        }
        return new DmlEntityUtil.DmlServiceEntity(model).selectAll();
    }
}

