/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.handler;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessVo;
import com.jxdinfo.hussar.support.engine.api.support.solidorg.handler.EngineParamHandler;
import com.jxdinfo.hussar.support.engine.core.model.EngineQueryConditionDto;
import com.jxdinfo.hussar.support.engine.core.model.FieldAccess;
import com.jxdinfo.hussar.support.engine.core.service.PlatformApi;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.SelectEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlEntityUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlSqlUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.util.DmlWhereEntityUtil;
import com.jxdinfo.hussar.support.engine.plugin.model.util.ModelResultMapUtil;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.stereotype.Component;

@Component
public class EngineDataAccessHandler
implements EngineParamHandler {
    private PlatformApi platformApi;
    private String[] whileList = new String[]{"jvcdwume0vxztr0lfnp4doe8152rrdtz", "5m3f3ywhll6fjnk916ywvqbfp11mu5bq", "2is61eg3qeb3a662lsh6j385v2blbv24"};

    public EngineDataAccessHandler(ObjectProvider<PlatformApi> objectProvider) {
        this.platformApi = (PlatformApi)objectProvider.getIfAvailable();
        if (this.platformApi == null) {
            this.platformApi = new DefaultPlatformApi();
        }
    }

    public boolean isApply(NodeBusinessVo nodeBusiness) {
        if (this.platformApi instanceof DefaultPlatformApi) {
            return false;
        }
        String nodeName = nodeBusiness.getNodeName();
        for (String item : this.whileList) {
            if (!nodeName.endsWith(item)) continue;
            return false;
        }
        return super.isApply(nodeBusiness);
    }

    public void pmHandling(Map<String, Object> params, NodeBusinessVo nodeBusiness) {
    }

    public void ghPmHandling(Object[] invokeParams, NodeBusinessVo nodeBusiness) {
        SelectEntity entity = this.findParam(invokeParams);
        if (entity == null) {
            return;
        }
        if (entity.getParam() != null && entity.getParam().containsKey("BC8D215A-26F1-9B83-4DE2-7867003DA241")) {
            return;
        }
        this.dataFiler(entity);
        this.fieldAccess(entity);
    }

    private void dataFiler(SelectEntity entity) {
        List conditionDtoList = this.platformApi.getDataFilter(entity.getModel().getTfModelId(), "");
        if (HussarUtils.isEmpty((Object)conditionDtoList)) {
            return;
        }
        this.organFilter(entity, conditionDtoList);
    }

    private void organFilter(SelectEntity entity, List<EngineQueryConditionDto> organFilters) {
        if (HussarUtils.isEmpty(organFilters) || entity.getModel() == null) {
            return;
        }
        List conditionWhere = DmlEntityUtil.getConditionWhere(organFilters, (ModelTableMappingDTO)entity.getModel(), (Map)entity.getParam(), (String)"SC");
        if (HussarUtils.isNotEmpty((Object)conditionWhere)) {
            conditionWhere.forEach(x -> x.initVal(entity.getParam()));
            List newConditionWhere = DmlWhereEntityUtil.whereIntuitionRebuild((List)conditionWhere);
            String whereSqlStr = DmlSqlUtil.getWhereSql((List)DmlEntityUtil.getWhereTree((List)newConditionWhere), (boolean)HussarUtils.isNotEmpty((Object)entity.getModel().getSlaveTables()));
            entity.appendWhere(whereSqlStr, true);
        }
    }

    private void fieldAccess(SelectEntity entity) {
        List fieldAccess = this.platformApi.getFieldAccess(entity.getModel().getTfModelId(), "");
        if (HussarUtils.isEmpty((Object)fieldAccess)) {
            return;
        }
        this.initField(fieldAccess, entity.getModel());
        Map unVisibleFieldMap = fieldAccess.stream().collect(Collectors.toMap(FieldAccess::getResultMappingColumn, Function.identity()));
        entity.resetColumnSql(entities -> entities.removeIf(columnEntity -> unVisibleFieldMap.containsKey(ModelResultMapUtil.getResultMappingColumn((String)columnEntity.getTableName(), (String)columnEntity.getColAlias()))));
    }

    private void initField(List<FieldAccess> fieldAccess, ModelTableMappingDTO model) {
        String masterTable = model.getTableName();
        HashMap<String, String> tableParam = new HashMap<String, String>();
        this.getSlaveTableParam(tableParam, model.getSlaveTables());
        for (FieldAccess access : fieldAccess) {
            String parentAlias = access.getParentId();
            if (HussarUtils.isEmpty((Object)parentAlias)) {
                access.setResultMappingColumn(ModelResultMapUtil.getResultMappingColumn((String)masterTable, (String)access.getFieldId()));
                continue;
            }
            String tableAlias = Optional.ofNullable(tableParam.get(parentAlias)).orElse(masterTable);
            access.setResultMappingColumn(ModelResultMapUtil.getResultMappingColumn((String)tableAlias, (String)access.getFieldId()));
        }
    }

    private void getSlaveTableParam(Map<String, String> tableParam, List<ModelTableMappingDTO> slaveTables) {
        if (HussarUtils.isEmpty(slaveTables)) {
            return;
        }
        slaveTables.forEach(s -> {
            tableParam.put(s.getParamName(), s.getTableName());
            if (HussarUtils.isNotEmpty((Object)s.getSlaveTables())) {
                this.getSlaveTableParam(tableParam, s.getSlaveTables());
            }
        });
    }

    private SelectEntity findParam(Object[] invokeParams) {
        if (invokeParams != null) {
            for (Object param : invokeParams) {
                if (!(param instanceof SelectEntity)) continue;
                return (SelectEntity)param;
            }
        }
        return null;
    }

    public void resultHandling(Object result, NodeBusinessVo nodeBusiness) {
    }

    public int getOrder() {
        return 0;
    }

    public class DefaultPlatformApi
    implements PlatformApi {
        public List<FieldAccess> getFieldAccess(String businessId, String type) {
            return null;
        }

        public List<EngineQueryConditionDto> getDataFilter(String businessId, String type) {
            return null;
        }

        public String getFormName(String businessId) {
            return null;
        }

        public List<Long> getUnderDept() {
            return null;
        }
    }
}

