/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.sync;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.google.common.collect.Lists;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.engine.api.entity.Dataservice;
import com.jxdinfo.hussar.support.engine.api.entity.DataserviceInout;
import com.jxdinfo.hussar.support.engine.api.enums.InoutType;
import com.jxdinfo.hussar.support.engine.api.service.DataserviceService;
import com.jxdinfo.hussar.support.engine.api.service.UnderlyingService;
import com.jxdinfo.hussar.support.engine.core.annotations.EngineMethod;
import com.jxdinfo.hussar.support.engine.core.annotations.EngineService;
import com.jxdinfo.hussar.support.engine.core.enums.EngineExceptionEnum;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.support.service.DataserviceInoutService;
import com.jxdinfo.hussar.support.engine.properties.EngineProperties;
import com.jxdinfo.hussar.support.mp.base.service.HussarService;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ClassUtils;

public class EngineMethodTask
implements Runnable {
    private static final Logger logger = LoggerFactory.getLogger(EngineMethodTask.class);
    private final DataserviceService service = (DataserviceService)SpringContextUtil.getBean(DataserviceService.class);
    private final DataserviceInoutService inoutService = (DataserviceInoutService)SpringContextUtil.getBean(DataserviceInoutService.class);
    private final Set<String> checkMap = new HashSet<String>();
    private final boolean initMethod = ((EngineProperties)SpringContextUtil.getBean(EngineProperties.class)).getInitMethod();

    @Override
    public void run() {
        if (!this.initMethod) {
            return;
        }
        ArrayList<Dataservice> list = new ArrayList<Dataservice>();
        ArrayList<DataserviceInout> inoutList = new ArrayList<DataserviceInout>();
        this.renderClass(list, inoutList);
        this.saveDataService(list, inoutList);
    }

    private void saveDataService(List<Dataservice> list, List<DataserviceInout> inoutList) {
        this.inoutService.remove((Wrapper)Wrappers.lambdaQuery(DataserviceInout.class).isNotNull(DataserviceInout::getInoutId));
        this.service.remove((Wrapper)Wrappers.lambdaQuery(Dataservice.class).isNotNull(Dataservice::getDataserviceId));
        this.saveBatch((List)list, (HussarService)this.service);
        this.saveBatch((List)inoutList, (HussarService)this.inoutService);
    }

    private void renderClass(List<Dataservice> list, List<DataserviceInout> inoutList) {
        for (UnderlyingService bean : SpringContextUtil.getBeansByClass(UnderlyingService.class)) {
            Class<?> beanClass = this.getClass(bean.getClass());
            EngineService serviceAnnotation = beanClass.getAnnotation(EngineService.class);
            if (serviceAnnotation == null) continue;
            this.renderMethods(list, inoutList, beanClass.getMethods(), serviceAnnotation);
        }
    }

    private void renderMethods(List<Dataservice> list, List<DataserviceInout> inoutList, Method[] methods, EngineService serviceAnnotation) {
        for (Method method : methods) {
            String serviceName;
            EngineMethod methodAnnotation = method.getAnnotation(EngineMethod.class);
            String beanName = serviceAnnotation.value();
            String string = serviceName = beanName.contains(".") ? beanName.substring(beanName.lastIndexOf(".") + 1) : beanName;
            if (methodAnnotation == null || !this.checkMap.add(beanName + method.getName())) continue;
            Long dataServiceId = EngineUtil.getId();
            Dataservice dataservice = new Dataservice(dataServiceId, Integer.valueOf(serviceAnnotation.type().getValue()), beanName, serviceAnnotation.des(), method.getName(), methodAnnotation.des(), serviceName);
            DataserviceInout out = new DataserviceInout(dataServiceId, InoutType.OUT.getValue(), method.getReturnType().getName(), "", Integer.valueOf(1), methodAnnotation.returnDes());
            this.renderParams(inoutList, method.getParameters(), dataServiceId, methodAnnotation.paramDes(), methodAnnotation.paramAlias());
            list.add(dataservice);
            inoutList.add(out);
        }
    }

    private void renderParams(List<DataserviceInout> inoutList, Parameter[] parameters, Long dataServiceId, String[] paramDes, String[] paramAlias) {
        for (int i = 0; i < parameters.length; ++i) {
            Parameter parameter = parameters[i];
            if (Consumer.class.equals(parameter.getType())) continue;
            String des = paramDes.length > i ? paramDes[i] : "";
            String parameterName = paramAlias.length > i && HussarUtils.isNotBlank((CharSequence)paramAlias[i]) ? paramAlias[i] : parameter.getName();
            DataserviceInout in = new DataserviceInout(dataServiceId, InoutType.IN.getValue(), parameter.getType().getName(), parameterName, Integer.valueOf(i + 1), des);
            inoutList.add(in);
        }
    }

    private Class<?> getClass(Class<?> clazz) {
        return ClassUtils.getUserClass(clazz);
    }

    private <T> void saveBatch(List<T> list, HussarService<T> service) {
        try {
            for (List partition : Lists.partition(list, (int)500)) {
                service.saveBatch((Collection)partition);
            }
        }
        catch (Exception e) {
            logger.error(EngineExceptionEnum.CODE_FAIL.getMessage(), (Throwable)e);
        }
    }
}

