/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine;

import com.jxdinfo.hussar.support.engine.api.service.EngineMappingService;
import com.jxdinfo.hussar.support.engine.api.support.solidorg.handler.EngineIntercepts;
import com.jxdinfo.hussar.support.engine.api.support.solidorg.handler.EngineParamHandler;
import com.jxdinfo.hussar.support.engine.controlller.EngineMapperMappingController;
import com.jxdinfo.hussar.support.engine.properties.EngineProperties;
import com.jxdinfo.hussar.support.engine.sync.EngineMethodTask;
import com.jxdinfo.hussar.support.engine.sync.EngineThreadPoolUtil;
import java.util.Arrays;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

@Configuration
@ComponentScan(value={"com.jxdinfo.hussar.support.engine.plugin.**.config"})
@EnableConfigurationProperties(value={EngineProperties.class})
public class EngineConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(EngineConfiguration.class);

    @Bean
    public EngineMapperMappingController engineMapperMappingController(EngineMappingService engineMapperMappingService) {
        return new EngineMapperMappingController(engineMapperMappingService);
    }

    @Bean
    @ConditionalOnMissingBean(value={EngineIntercepts.class})
    public EngineIntercepts engineIntercepts(ObjectProvider<EngineParamHandler[]> paramHandlers) {
        Object[] pmHandlerArray = (EngineParamHandler[])paramHandlers.getIfAvailable();
        EngineIntercepts intercepts = new EngineIntercepts();
        if (ObjectUtils.isNotEmpty((Object)pmHandlerArray)) {
            AnnotationAwareOrderComparator.sort((Object[])pmHandlerArray);
            intercepts.setParamHandlers(Arrays.asList(pmHandlerArray));
        }
        return intercepts;
    }

    @Configuration
    @ComponentScan(value={"com.jxdinfo.hussar.support.engine.handler"})
    @ConditionalOnProperty(prefix="hussar.engine", name={"handler"}, havingValue="true", matchIfMissing=true)
    public class handlerConfig {
    }

    @Configuration
    @ComponentScan(value={"com.jxdinfo.hussar.support.engine.trans"})
    @ConditionalOnProperty(prefix="hussar.engine", name={"trans"}, havingValue="true", matchIfMissing=true)
    public class TransConfig {
    }

    @Configuration
    @ConditionalOnProperty(prefix="hussar.engine", name={"task"}, havingValue="true", matchIfMissing=true)
    public class EngineTaskConfiguration {
        @EventListener(value={WebServerInitializedEvent.class})
        public void initCache() {
            EngineThreadPoolUtil.getExecutor().execute(new EngineMethodTask());
        }
    }
}

