/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.handler;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.engine.api.dto.ModelColumnDto;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessVo;
import com.jxdinfo.hussar.support.engine.api.entity.ModelColumnsRules;
import com.jxdinfo.hussar.support.engine.api.enums.ModelRelation;
import com.jxdinfo.hussar.support.engine.api.support.solidorg.handler.EngineParamHandler;
import com.jxdinfo.hussar.support.engine.core.enums.ColumnRuleType;
import com.jxdinfo.hussar.support.engine.core.vo.PageVo;
import com.jxdinfo.hussar.support.engine.plugin.model.application.IEnginePluginModelApp;
import com.jxdinfo.hussar.support.transdict.core.anno.Trans;
import com.jxdinfo.hussar.support.transdict.extend.formdesign.TransUtil;
import com.jxdinfo.hussar.support.transdict.extend.formdesign.extend.CustomClassContent;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(prefix="hussar.engine", name={"trans"}, havingValue="true", matchIfMissing=true)
public class DefaultEngineDictTransHandler
implements EngineParamHandler {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultEngineDictTransHandler.class);
    private final IEnginePluginModelApp iEnginePluginModelApp;
    private static final String[] actionName = new String[]{"selectOne", "selectList", "selectPage", "selectExpressionList", "selectExpressionPage"};

    public DefaultEngineDictTransHandler(IEnginePluginModelApp iEnginePluginModelApp) {
        this.iEnginePluginModelApp = iEnginePluginModelApp;
    }

    public void pmHandling(Map<String, Object> params, NodeBusinessVo nodeBusiness) {
    }

    public void ghPmHandling(Object[] invokeParams, NodeBusinessVo nodeBusiness) {
    }

    public void resultHandling(Object result, NodeBusinessVo nodeBusiness) {
        String dataServiceCode = nodeBusiness.getActionName();
        Boolean check = false;
        for (int i = 0; i < actionName.length; ++i) {
            if (!dataServiceCode.equals(actionName[i])) continue;
            check = true;
            break;
        }
        if (!check.booleanValue()) {
            return;
        }
        Long modelId = nodeBusiness.getModelId();
        ModelTableMappingDTO modelTableMapping = this.iEnginePluginModelApp.getModelTableMapping(modelId);
        CustomClassContent.Builder builder = new CustomClassContent.Builder();
        List<ModelColumnsRules> res = DefaultEngineDictTransHandler.findRule(modelTableMapping);
        if (res.isEmpty()) {
            return;
        }
        Map<Long, ModelColumnsRules> rulesMap = res.stream().collect(Collectors.toMap(ModelColumnsRules::getModelColumnId, Function.identity()));
        if (HussarUtils.isEmpty((Object)modelTableMapping.getSlaveTables())) {
            this.transSingleTable(modelTableMapping.getColumns(), modelId, rulesMap, builder);
        } else {
            this.transSingleTable(modelTableMapping.getColumns(), modelId, rulesMap, builder);
            this.transMsTable(modelTableMapping.getSlaveTables(), rulesMap, builder);
        }
        if (result instanceof PageVo) {
            result = ((PageVo)result).getData();
        }
        TransUtil.trans((List)((List)result), (CustomClassContent)builder.builder());
    }

    private static List<ModelColumnsRules> findRule(ModelTableMappingDTO modelTableMapping) {
        ArrayList<ModelColumnsRules> res = new ArrayList<ModelColumnsRules>();
        modelTableMapping.getRuleByRuleType(res, ColumnRuleType.TRANSLATION);
        return res;
    }

    public int getOrder() {
        return 0;
    }

    private static void transQueryValue(String ruleContent, Map<String, Object> annotationValue) {
        JSONObject jsonObject = JSON.parseObject((String)ruleContent);
        if (jsonObject.containsKey((Object)"namespace")) {
            annotationValue.put("namespace", jsonObject.getString("namespace"));
        }
        if (jsonObject.containsKey((Object)"queryFields")) {
            annotationValue.put("queryFields", jsonObject.getString("queryFields").split(","));
        }
        if (jsonObject.containsKey((Object)"keyRef") && StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{jsonObject.getString("keyRef")})) {
            annotationValue.put("keyRef", jsonObject.getString("keyRef").split(","));
        }
        if (jsonObject.containsKey((Object)"ref") && StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{jsonObject.getString("ref")})) {
            annotationValue.put("ref", jsonObject.getString("ref"));
        }
        if (jsonObject.containsKey((Object)"refs") && StringUtil.isNoneBlank((CharSequence[])new CharSequence[]{jsonObject.getString("refs")})) {
            annotationValue.put("refs", jsonObject.getString("refs").split(","));
        }
        if (jsonObject.containsKey((Object)"type")) {
            annotationValue.put("type", jsonObject.getString("type"));
        }
    }

    private void transSingleTable(List<ModelColumnDto> columns, Long modelId, Map<Long, ModelColumnsRules> rulesMap, CustomClassContent.Builder builder) {
        Class<Trans> transClass = Trans.class;
        builder.setId(String.valueOf(modelId));
        HashSet<String> columnName = new HashSet<String>();
        for (int i = 0; i < columns.size(); ++i) {
            int finalI = i;
            String columnAlias = columns.get(i).getColumnAlias();
            if (!columnName.add(columnAlias)) continue;
            ModelColumnsRules columnsRules = rulesMap.get(columns.get(i).getModelColumnId());
            Class javaClass = null;
            try {
                javaClass = columns.get(i).javaType();
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            HashMap<String, Object> annotationValue = null;
            if (HussarUtils.isNotEmpty((Object)columnsRules)) {
                annotationValue = new HashMap<String, Object>();
                String ruleContent = columnsRules.getRuleContent();
                DefaultEngineDictTransHandler.transQueryValue(ruleContent, annotationValue);
            } else {
                transClass = null;
            }
            builder.defineField(columnAlias, (Type)javaClass, transClass, annotationValue);
        }
    }

    private void transMsTable(List<ModelTableMappingDTO> modelTableMapping, Map<Long, ModelColumnsRules> rulesMap, CustomClassContent.Builder builder) {
        for (ModelTableMappingDTO modelTableMappingDTO : modelTableMapping) {
            List columns = modelTableMappingDTO.getColumns();
            if (modelTableMappingDTO.getRelation().equals((Object)ModelRelation.ONE_ONE)) {
                this.transSingleTable(columns, modelTableMappingDTO.getRelatedId(), rulesMap, builder);
            } else if (ModelRelation.isMS((ModelRelation)modelTableMappingDTO.getRelation())) {
                if (!columns.stream().anyMatch(c -> rulesMap.get(c.getModelColumnId()) != null)) continue;
                CustomClassContent.Builder builderslave = new CustomClassContent.Builder();
                this.transSingleTable(columns, modelTableMappingDTO.getRelatedId(), rulesMap, builderslave);
                builder.defineField(modelTableMappingDTO.getParamName(), List.class, builderslave.builder());
            }
            if (!HussarUtils.isNotEmpty((Object)modelTableMappingDTO.getSlaveTables())) continue;
            this.transMsTable(modelTableMappingDTO.getSlaveTables(), rulesMap, builder);
        }
    }
}

