/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.handler;

import com.jxdinfo.hussar.datasource.manager.api.entity.MetadataColumn;
import com.jxdinfo.hussar.platform.core.config.HussarCoreProperties;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.ObjectUtil;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.platform.core.utils.StringUtil;
import com.jxdinfo.hussar.support.datascope.core.enums.DataScopeEnum;
import com.jxdinfo.hussar.support.datascope.core.support.extend.util.DataScopeUtil;
import com.jxdinfo.hussar.support.datascope.core.support.model.DataScopeInfo;
import com.jxdinfo.hussar.support.datascope.core.support.service.base.DataScopeService;
import com.jxdinfo.hussar.support.datascope.core.support.service.base.impl.DefaultDataScopeService;
import com.jxdinfo.hussar.support.engine.api.dto.ModelTableMappingDTO;
import com.jxdinfo.hussar.support.engine.api.dto.NodeBusinessVo;
import com.jxdinfo.hussar.support.engine.api.support.solidorg.handler.EngineParamHandler;
import com.jxdinfo.hussar.support.engine.core.enums.PurposeEnum;
import com.jxdinfo.hussar.support.engine.core.util.EngineUtil;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.ColumnEntity;
import com.jxdinfo.hussar.support.engine.plugin.dml.model.dml.SelectEntity;
import com.jxdinfo.hussar.support.engine.plugin.model.util.ModelResultMapUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.parser.CCJSqlParser;
import net.sf.jsqlparser.parser.ParseException;
import net.sf.jsqlparser.parser.Provider;
import net.sf.jsqlparser.parser.StringProvider;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.util.TablesNamesFinder;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Component;

@Component
public class DefaultEngineDataScopeHandler
implements EngineParamHandler {
    protected static final Logger logger = LoggerFactory.getLogger(DefaultEngineDataScopeHandler.class);
    private DataScopeService dataScopeService;
    private String serverName = null;

    @Autowired
    public DefaultEngineDataScopeHandler(HussarCoreProperties hussarCoreProperties, Environment environment) {
        if (hussarCoreProperties.isEnableMicroService()) {
            this.serverName = environment.getProperty("spring.application.name");
        }
    }

    public void ghPmHandling(Object[] invokeParams, NodeBusinessVo nodeBusiness) {
        this.sqlCondition(invokeParams, nodeBusiness);
    }

    public int getOrder() {
        return 1;
    }

    public void sqlCondition(Object[] invokeParams, NodeBusinessVo nodeBusiness) {
        SelectEntity entity = this.findParam(invokeParams);
        if (entity == null) {
            return;
        }
        String nodeName = nodeBusiness.getNodeName();
        List<DataScopeInfo> dataScopeInfos = this.getDataScope(nodeName);
        DataScopeInfo defaultDataScope = DataScopeUtil.getDefaultDataScope(dataScopeInfos);
        List customDataScopes = DataScopeUtil.getEffectCustomDataScopes(dataScopeInfos);
        if (HussarUtils.isEmpty((Object)defaultDataScope) && HussarUtils.isEmpty((Object)customDataScopes)) {
            return;
        }
        this.sqlPackage(defaultDataScope, customDataScopes, entity);
    }

    private List<DataScopeInfo> getDataScope(String nodeName) {
        Long userId;
        if (HussarUtils.isEmpty((Object)this.dataScopeService)) {
            DataScopeService bean = (DataScopeService)SpringContextUtil.getBean(DataScopeService.class);
            Object object = this.dataScopeService = bean == null ? new DefaultDataScopeService() : bean;
        }
        if ((userId = EngineUtil.getUserId()) != null) {
            return this.dataScopeService.getDataScope(userId, nodeName, this.serverName);
        }
        return null;
    }

    private SelectEntity findParam(Object[] invokeParams) {
        if (invokeParams != null) {
            for (Object param : invokeParams) {
                if (!(param instanceof SelectEntity)) continue;
                return (SelectEntity)param;
            }
        }
        return null;
    }

    private void sqlPackage(DataScopeInfo dataScopeInfo, List<DataScopeInfo> customDataScopeInfos, SelectEntity entity) {
        String finalDataScopeSql;
        String customOrSql;
        String dataScopeSql = this.resolveDataScope(dataScopeInfo, entity);
        Pair<String, String> customSqlPair = this.resolveCustomDataScope(customDataScopeInfos);
        String customAndSql = HussarUtils.isNotEmpty(customSqlPair) ? this.replaceTableAlias((String)customSqlPair.getLeft(), entity.getModel()) : "";
        String string = customOrSql = HussarUtils.isNotEmpty(customSqlPair) ? this.replaceTableAlias((String)customSqlPair.getRight(), entity.getModel()) : "";
        String string2 = ObjectUtil.isAllNotEmpty((Object[])new Object[]{dataScopeSql, customOrSql}) ? "(" + dataScopeSql + " OR " + customOrSql + ")" : (finalDataScopeSql = ObjectUtil.isNotEmpty((Object)dataScopeSql) ? dataScopeSql : customOrSql);
        String string3 = ObjectUtil.isAllNotEmpty((Object[])new Object[]{finalDataScopeSql, customAndSql}) ? "(" + finalDataScopeSql + "AND" + customAndSql + ")" : (finalDataScopeSql = ObjectUtil.isNotEmpty((Object)finalDataScopeSql) ? finalDataScopeSql : customAndSql);
        if (ObjectUtil.isEmpty((Object)finalDataScopeSql)) {
            return;
        }
        entity.appendWhere(finalDataScopeSql, true);
    }

    private String replaceTableAlias(String customDataScopeSql, ModelTableMappingDTO model) {
        try {
            if (HussarUtils.isEmpty((Object)model.getSlaveTables())) {
                return customDataScopeSql;
            }
            CCJSqlParser parser = new CCJSqlParser((Provider)new StringProvider(customDataScopeSql));
            Expression expression = parser.Expression();
            ColumnFinder columnFinder = new ColumnFinder();
            Map<String, String> columnMap = model.getAllColumns().stream().collect(Collectors.toMap(c -> c.getColumnName().toUpperCase(), MetadataColumn::getTableName, (k1, k2) -> k1));
            List<Column> columnList = columnFinder.getColumnList(expression);
            for (Column column : columnList) {
                String tableName = columnMap.get(column.getColumnName().toUpperCase());
                if (tableName == null) {
                    logger.error("\u672a\u627e\u5230\u6743\u9650\u5b57\u6bb5: {}", (Object)column);
                    tableName = model.getTableName();
                }
                Table table = new Table(tableName);
                Optional.ofNullable(column.getTable()).map(Table::getSchemaName).ifPresent(arg_0 -> ((Table)table).setSchemaName(arg_0));
                table.setAlias(new Alias(ModelResultMapUtil.getTableShortName((String)tableName.toLowerCase())));
                column.setTable(table);
            }
            customDataScopeSql = expression.toString();
        }
        catch (ParseException e) {
            logger.error("\u6570\u636e\u6743\u9650SQL\u7247\u6bb5\u5f02\u5e38\uff1a{}", (Object)customDataScopeSql);
        }
        return customDataScopeSql;
    }

    private Pair<String, String> resolveCustomDataScope(List<DataScopeInfo> customDataScopeInfos) {
        return DataScopeUtil.generateCustomSql(customDataScopeInfos);
    }

    private String resolveDataScope(DataScopeInfo dataScopeInfo, SelectEntity entity) {
        if (HussarUtils.isEmpty((Object)dataScopeInfo)) {
            return null;
        }
        List scopeTypes = dataScopeInfo.getScopeTypes();
        if (HussarUtils.isEmpty((Object)scopeTypes)) {
            return null;
        }
        Integer finalType = null;
        for (Integer scopeType : scopeTypes) {
            if (HussarUtils.isEmpty((Object)scopeType)) continue;
            if (HussarUtils.isEmpty(finalType)) {
                finalType = scopeType;
            }
            if (scopeType > finalType) continue;
            finalType = scopeType;
        }
        DataScopeEnum finalScope = DataScopeEnum.of(finalType);
        StringBuilder where = new StringBuilder();
        if (HussarUtils.isEmpty((Object)finalScope) || DataScopeEnum.ALL == finalScope) {
            return null;
        }
        if (DataScopeEnum.OWN == finalScope) {
            String sql = this.ownSql(dataScopeInfo, entity);
            where.append(sql);
            String deptSql = this.deptSql(dataScopeInfo, entity);
            if (HussarUtils.isNotEmpty((Object)deptSql)) {
                where.insert(0, "(").append(" OR ").append(deptSql).append(")");
            }
        } else {
            String sql = this.deptSql(dataScopeInfo, entity);
            if (HussarUtils.isEmpty((Object)sql)) {
                return null;
            }
            where.append(sql);
        }
        return where.toString();
    }

    private String deptSql(DataScopeInfo dataScopeInfo, SelectEntity entity) {
        List deptIds = dataScopeInfo.getScopeDeptIds();
        if (HussarUtils.isEmpty((Object)deptIds) || HussarUtils.isEmpty((Object)dataScopeInfo.getDeptScopeField())) {
            return "";
        }
        String deptScopeField = this.getFieldNameByPurpose(PurposeEnum.DATA_ORGAN, entity);
        return HussarUtils.isNotEmpty((Object)deptScopeField) ? String.format("%s IN (%s)", deptScopeField, StringUtil.arrayToDelimitedString((Object[])deptIds.toArray(), (String)",")) : "";
    }

    private String ownSql(DataScopeInfo dataScopeInfo, SelectEntity entity) {
        Long userId = EngineUtil.getUserId();
        if (HussarUtils.isEmpty((Object)dataScopeInfo.getUserScopeField()) || HussarUtils.isEmpty((Object)userId)) {
            return "";
        }
        String deptScopeField = this.getFieldNameByPurpose(PurposeEnum.DATA_HOLDER, entity);
        return HussarUtils.isNotEmpty((Object)deptScopeField) ? String.format("%s = %s", deptScopeField, userId) : "";
    }

    private String getFieldNameByPurpose(PurposeEnum purposeEnum, SelectEntity entity) {
        boolean ms = HussarUtils.isNotEmpty((Object)entity.getJoinEntityList());
        for (ColumnEntity columnEntity : entity.getSelectColumnsList()) {
            if (!HussarUtils.isNotEmpty((Object)columnEntity.getPurpose()) || !purposeEnum.getValue().equals(columnEntity.getPurpose())) continue;
            return ms ? columnEntity.getTableAliasAndColName() : columnEntity.getColNameEnableEscape();
        }
        return null;
    }

    public void pmHandling(Map<String, Object> params, NodeBusinessVo nodeBusiness) {
    }

    public void resultHandling(Object result, NodeBusinessVo nodeBusiness) {
    }

    public static class ColumnFinder
    extends TablesNamesFinder {
        private boolean init;
        List<Column> columns;

        public List<String> getTableList(Expression expr) {
            this.columns = new ArrayList<Column>();
            return super.getTableList(expr);
        }

        public List<Column> getColumnList(Expression expr) {
            if (!this.init) {
                this.getTableList(expr);
            }
            return this.columns;
        }

        public void visit(Column column) {
            this.init = true;
            this.columns.add(column);
            super.visit(column);
        }
    }
}

