/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine;

import com.jxdinfo.hussar.support.engine.api.support.solidorg.handler.EngineIntercepts;
import com.jxdinfo.hussar.support.engine.api.support.solidorg.handler.EngineParamHandler;
import com.jxdinfo.hussar.support.engine.plugin.solidorg.config.SolidOrgConfiguration;
import com.jxdinfo.hussar.support.engine.plugin.upgrade.config.EnginePluginUpgradeConfig;
import com.jxdinfo.hussar.support.engine.sync.EngineMethodTask;
import com.jxdinfo.hussar.support.engine.sync.EngineThreadPoolUtil;
import java.util.Arrays;
import org.apache.commons.lang3.ObjectUtils;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.web.context.WebServerInitializedEvent;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

@Configuration
@ComponentScan(value={"com.jxdinfo.hussar.support.engine.controlller"})
@Import(value={SolidOrgConfiguration.class, EnginePluginUpgradeConfig.class})
public class EngineConfiguration {
    @EventListener(value={WebServerInitializedEvent.class})
    public void initCache() {
        EngineThreadPoolUtil.getExecutor().execute(new EngineMethodTask());
    }

    @Bean
    @ConditionalOnMissingBean(value={EngineIntercepts.class})
    public EngineIntercepts engineIntercepts(ObjectProvider<EngineParamHandler[]> paramHandlers) {
        Object[] pmHandlerArray = (EngineParamHandler[])paramHandlers.getIfAvailable();
        EngineIntercepts intercepts = new EngineIntercepts();
        if (ObjectUtils.isNotEmpty((Object)pmHandlerArray)) {
            AnnotationAwareOrderComparator.sort((Object[])pmHandlerArray);
            intercepts.setParamHandlers(Arrays.asList(pmHandlerArray));
        }
        return intercepts;
    }
}

