/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.upgrade.manage.impl;

import com.baomidou.dynamic.datasource.ds.ItemDataSource;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.plugin.upgrade.backup.BackupEntity;
import com.jxdinfo.hussar.support.engine.plugin.upgrade.backup.BackupHelper;
import com.jxdinfo.hussar.support.engine.plugin.upgrade.backup.BackupProperties;
import com.jxdinfo.hussar.support.engine.plugin.upgrade.backup.DbBackupFactory;
import com.jxdinfo.hussar.support.engine.plugin.upgrade.backup.IDbBackup;
import com.jxdinfo.hussar.support.engine.plugin.upgrade.manage.IEngineUpgrade;
import com.jxdinfo.hussar.support.engine.plugin.upgrade.manage.IEngineUpgradeManager;
import com.jxdinfo.hussar.support.engine.plugin.upgrade.service.UpgradeRecordService;
import com.jxdinfo.hussar.support.engine.plugin.upgrade.util.ComparableVersion;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class EngineUpgradeManager
implements IEngineUpgradeManager {
    private static final Logger logger = LoggerFactory.getLogger(EngineUpgradeManager.class);
    @Autowired
    private UpgradeRecordService upgradeRecordService;
    @Autowired
    private List<IEngineUpgrade> engineUpgrades;
    @Autowired
    private BackupProperties backupProperties;
    @Value(value="${hussar.engine.upgrade.backup:false}")
    private boolean backupOpen;
    @Value(value="${hussar.engine.upgrade.enable:false}")
    private boolean upgradeEnable;

    @Override
    public void upgradeLatest() {
        if (!this.upgradeEnable) {
            return;
        }
        try {
            logger.info("\u89e3\u6790\u5f15\u64ce\u6570\u636e\u5347\u7ea7\u5f00\u59cb");
            String currentVersion = this.upgradeRecordService.maxVersion();
            List<IEngineUpgrade> upgrades = this.engineUpgrades.stream().filter(x -> new ComparableVersion(x.getVersion()).compareTo(new ComparableVersion(currentVersion)) > 0).sorted(Comparator.comparing(x -> new ComparableVersion(x.getVersion()))).collect(Collectors.toList());
            if (HussarUtils.isNotEmpty(upgrades)) {
                upgrades.forEach(upgrade -> {
                    new Thread(new BackupTask(upgrade.tablesForBackups(), upgrade.getDatasource(), upgrade.getVersion())).start();
                    upgrade.upgrade();
                });
            }
        }
        catch (Exception e) {
            logger.error("\u5907\u4efd\u5931\u8d25\uff0c{}", (Object)e.getMessage());
        }
        finally {
            logger.info("\u89e3\u6790\u5f15\u64ce\u6570\u636e\u5347\u7ea7\u7ed3\u675f");
        }
    }

    class BackupTask
    implements Runnable {
        private List<String> tables;
        private DataSource dataSource;
        private String version;

        public BackupTask(List<String> tables, DataSource dataSource, String version) {
            this.tables = tables;
            this.dataSource = dataSource;
            this.version = version;
        }

        @Override
        public void run() {
            this.backup(this.tables, this.dataSource, this.version);
        }

        private void backup(List<String> tables, DataSource dataSource, String version) {
            if (!EngineUpgradeManager.this.backupOpen) {
                return;
            }
            try {
                if (HussarUtils.isEmpty(tables)) {
                    return;
                }
                ItemDataSource itemDataSource = (ItemDataSource)dataSource;
                BackupEntity backupEntity = new BackupEntity();
                backupEntity.setDbType(itemDataSource.getDbType());
                backupEntity.setUserName(itemDataSource.getUsername());
                backupEntity.setPassword(itemDataSource.getPassword());
                backupEntity.setTables(tables);
                backupEntity.setVersion(version);
                IDbBackup dbBackup = DbBackupFactory.getDbBackup(itemDataSource.getDbType(), itemDataSource.getUrl(), itemDataSource.getUsername());
                if (dbBackup != null) {
                    backupEntity.setDbName(dbBackup.getDbName());
                    backupEntity.setHost(dbBackup.getHost());
                    backupEntity.setPort(dbBackup.getPort());
                    backupEntity.setService(dbBackup.getService());
                    BackupHelper.backup(backupEntity, EngineUpgradeManager.this.backupProperties);
                }
            }
            catch (Exception e) {
                logger.error("\u5907\u4efd\u5931\u8d25\uff0c{}", (Object)e.getMessage());
            }
        }
    }
}

