/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.rmi.support.service.oauth;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.plugin.pub.model.AuthTokenInfo;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.RmiExceptionEnum;
import com.jxdinfo.hussar.support.engine.plugin.rmi.support.service.AbstractOAuthService;
import com.jxdinfo.hussar.support.exception.HussarException;
import java.time.LocalDateTime;
import java.util.Map;
import org.springframework.stereotype.Service;

@Service
public class BaseOAuthServiceImpl
extends AbstractOAuthService {
    @Override
    protected AuthTokenInfo getTokenInfo(Map map) {
        Object refreshExpiresIn;
        Object refreshToken;
        Object expiresIn;
        HussarException.throwByNull((Object)map, (Integer)RmiExceptionEnum.GET_AUTH_INFO_EMPTY.getExceptionCode(), (String)RmiExceptionEnum.GET_AUTH_INFO_EMPTY.getMessage());
        AuthTokenInfo tokenInfo = new AuthTokenInfo();
        Map tokenMap = (Map)map.get("data");
        if (HussarUtils.isEmpty((Object)tokenMap)) {
            return tokenInfo;
        }
        Object accessToken = tokenMap.get("access-token");
        if (HussarUtils.isNotEmpty(accessToken)) {
            tokenInfo.setAccessToken(String.valueOf(accessToken));
        }
        if (HussarUtils.isNotEmpty(expiresIn = tokenMap.get("expires-in"))) {
            Long expires = Long.valueOf(String.valueOf(expiresIn));
            tokenInfo.setExpireTime(LocalDateTime.now().plusSeconds(expires));
        }
        if (HussarUtils.isNotEmpty(refreshToken = tokenMap.get("refresh-token"))) {
            tokenInfo.setRefreshToken(String.valueOf(refreshToken));
        }
        if (HussarUtils.isNotEmpty(refreshExpiresIn = tokenMap.get("refresh-expires-in"))) {
            Long refreshExpires = Long.valueOf(String.valueOf(refreshExpiresIn));
            tokenInfo.setRefreshExpireTime(LocalDateTime.now().plusSeconds(refreshExpires));
        }
        return tokenInfo;
    }
}

