/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.rmi.support.model.oauth.oauth2;

import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.OAuth2Type;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.ParamScope;
import com.jxdinfo.hussar.support.engine.plugin.rmi.support.model.oauth.AbstractOAuthInfoDto;
import com.jxdinfo.hussar.support.engine.plugin.rmi.support.model.oauth.OAuthParamDto;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class OAuthInfoDto
extends AbstractOAuthInfoDto {
    private OAuth2Type oAuth2Type;
    private String tokenUri;
    private List<OAuthParamDto> oAuthParamList;
    private String tokenHost;
    private String tokenport;
    private String tokenScheme;
    private String contentType = "";

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public String getTokenHost() {
        return this.tokenHost;
    }

    public void setTokenHost(String tokenHost) {
        this.tokenHost = tokenHost;
    }

    public String getTokenport() {
        if (HussarUtils.isEmpty((Object)this.tokenport)) {
            if ("http".equals(this.getTokenScheme().toLowerCase())) {
                return "80";
            }
            if ("https".equals(this.getTokenScheme().toLowerCase())) {
                return "443";
            }
        }
        return this.tokenport;
    }

    public void setTokenport(String tokenport) {
        this.tokenport = tokenport;
    }

    public String getTokenScheme() {
        return this.tokenScheme;
    }

    public void setTokenScheme(String tokenScheme) {
        this.tokenScheme = tokenScheme;
    }

    public Map<String, Object> getHeaderParams() {
        return this.getParams(ParamScope.HEADER);
    }

    public Map<String, Object> getBodyParams() {
        return this.getParams(ParamScope.BODY);
    }

    public Map<String, Object> getQueryParams() {
        return this.getParams(ParamScope.QUERY);
    }

    private Map<String, Object> getParams(ParamScope scope) {
        HashMap<String, Object> paramsMap = new HashMap<String, Object>();
        if (HussarUtils.isNotEmpty(this.getoAuthParamList())) {
            for (OAuthParamDto oAuthParam : this.getoAuthParamList()) {
                if (!scope.equals((Object)oAuthParam.getParamScope())) continue;
                paramsMap.put(oAuthParam.getParamKey(), oAuthParam.getParamValue());
            }
        }
        return paramsMap;
    }

    public Object getBodyObjectParams() {
        if (HussarUtils.isNotEmpty(this.getoAuthParamList())) {
            for (OAuthParamDto oAuthParam : this.getoAuthParamList()) {
                if (!ParamScope.BODY.equals((Object)oAuthParam.getParamScope())) continue;
                return oAuthParam.getParamValue();
            }
        }
        return "";
    }

    public OAuth2Type getoAuth2Type() {
        return this.oAuth2Type;
    }

    public void setoAuth2Type(OAuth2Type oAuth2Type) {
        this.oAuth2Type = oAuth2Type;
    }

    public String getTokenUri() {
        return this.tokenUri;
    }

    public void setTokenUri(String tokenUri) {
        this.tokenUri = tokenUri;
    }

    public List<OAuthParamDto> getoAuthParamList() {
        return this.oAuthParamList;
    }

    public void setoAuthParamList(List<OAuthParamDto> oAuthParamList) {
        this.oAuthParamList = oAuthParamList;
    }
}

