/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.rmi.connector.service.impl;

import com.baomidou.dynamic.datasource.annotation.DSTransactional;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.jxdinfo.hussar.platform.core.base.entity.BaseEntity;
import com.jxdinfo.hussar.platform.core.base.entity.HussarBaseEntity;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.WebUtil;
import com.jxdinfo.hussar.support.engine.plugin.pub.entity.PubVar;
import com.jxdinfo.hussar.support.engine.plugin.pub.enums.PubVarTypeEnum;
import com.jxdinfo.hussar.support.engine.plugin.pub.service.PubVarService;
import com.jxdinfo.hussar.support.engine.plugin.rmi.connector.dao.RmiConnectorMapper;
import com.jxdinfo.hussar.support.engine.plugin.rmi.connector.dto.RmiInterfaceQueryDto;
import com.jxdinfo.hussar.support.engine.plugin.rmi.connector.service.RmiConnectorService;
import com.jxdinfo.hussar.support.engine.plugin.rmi.connector.service.RmiInterfaceService;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.RmiClassifyEnum;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.RmiExceptionEnum;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.RmiStatusEnum;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.mp.base.service.impl.HussarServiceImpl;
import com.jxdinfo.hussar.support.rmi.api.entity.RmiConnector;
import com.jxdinfo.hussar.support.rmi.api.entity.RmiInterface;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RmiConnectorServiceImpl
extends HussarServiceImpl<RmiConnectorMapper, RmiConnector>
implements RmiConnectorService {
    @Autowired
    private PubVarService pubVarService;
    @Autowired
    private RmiInterfaceService rmiInterfaceService;

    @Override
    public RmiConnector getRmiConnector(Long connectorId) {
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)connectorId), (String)"API\u8fde\u63a5\u5668id\u4e0d\u80fd\u4e3a\u7a7a");
        return (RmiConnector)this.getById(connectorId);
    }

    @Override
    @DSTransactional
    public boolean deleteRmiConnector(Long connectorId) {
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)connectorId), (String)"API\u8fde\u63a5\u5668id\u4e0d\u80fd\u4e3a\u7a7a");
        RmiConnector rmiConnector = (RmiConnector)this.getById(connectorId);
        if (HussarUtils.isEmpty((Object)rmiConnector)) {
            return Boolean.TRUE;
        }
        Long appId = rmiConnector.getAppId();
        HussarException.throwBy((boolean)RmiStatusEnum.IN_USE.getValue().equals(rmiConnector.getConnectorStatus()), (String)"\u4e0d\u80fd\u5220\u9664\u542f\u7528\u4e2d\u7684\u8fde\u63a5\u5668");
        this.pubVarService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(PubVar::getBelongId, (Object)connectorId)).eq(PubVar::getBelongType, (Object)PubVarTypeEnum.CONNECTOR.getType()));
        String code = rmiConnector.getConnectorCode();
        if (HussarUtils.isEmpty((Object)code)) {
            return Boolean.TRUE;
        }
        this.rmiInterfaceService.remove((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RmiInterface::getConnectorCode, (Object)code)).eq(HussarUtils.isNotEmpty((Object)appId), RmiInterface::getAppId, (Object)appId));
        return this.removeById(connectorId);
    }

    @Override
    public boolean saveRmiConnector(RmiConnector rmiConnector) {
        long count;
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)rmiConnector), (String)"\u8fde\u63a5\u5668\u4e0d\u80fd\u4e3a\u7a7a");
        String connectorName = rmiConnector.getConnectorName();
        Long appId = rmiConnector.getAppId();
        Long id = rmiConnector.getConnectorId();
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RmiConnector::getConnectorName, (Object)connectorName)).eq(HussarUtils.isNotEmpty((Object)appId), RmiConnector::getAppId, (Object)appId);
        if (HussarUtils.isNotEmpty((Object)id)) {
            wrapper.ne(RmiConnector::getConnectorId, (Object)id);
        }
        HussarException.throwBy(((count = this.count((Wrapper)wrapper)) > 0L ? 1 : 0) != 0, (String)"\u8fde\u63a5\u5668\u540d\u79f0\u5df2\u5b58\u5728");
        return this.saveOrUpdate((BaseEntity)rmiConnector);
    }

    @Override
    @DSTransactional
    public Long addConnector(RmiConnector rmiConnector) {
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)rmiConnector), (String)"\u8fde\u63a5\u5668\u4e0d\u80fd\u4e3a\u7a7a");
        String connectorCode = rmiConnector.getConnectorCode();
        Long appId = rmiConnector.getAppId();
        rmiConnector.setConnectorStatus(RmiStatusEnum.NOT_USE.getValue());
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RmiConnector::getConnectorCode, (Object)connectorCode)).eq(HussarUtils.isNotEmpty((Object)appId), RmiConnector::getAppId, (Object)appId);
        long count = this.count((Wrapper)wrapper);
        HussarException.throwBy((count > 0L ? 1 : 0) != 0, (String)"\u8fde\u63a5\u5668\u6807\u8bc6\u5df2\u5b58\u5728");
        this.saveRmiConnector(rmiConnector);
        Long connectorId = rmiConnector.getConnectorId();
        String authCode = rmiConnector.getAuthCode();
        if (this.needAuth(rmiConnector.getIsAuth()) && HussarUtils.isNotEmpty((Object)authCode)) {
            this.pubVarService.initAuthTokenInfo(connectorId);
            this.rmiInterfaceService.addAuthInterfaceByAuthCode(rmiConnector);
        }
        return rmiConnector.getConnectorId();
    }

    @Override
    public List<RmiInterface> getAuthRmi(RmiConnector rmiConnector) {
        return this.rmiInterfaceService.getAuthInterfacesByConnectorCode(rmiConnector);
    }

    @Override
    public List<RmiInterface> getRmi(RmiInterfaceQueryDto rmiInterfaceQueryDto) {
        String connectorCode = rmiInterfaceQueryDto.getConnectorCode();
        String query = rmiInterfaceQueryDto.getQuery();
        Long appId = rmiInterfaceQueryDto.getAppId();
        HussarException.throwByNull((Object)connectorCode, (String)"API\u8fde\u63a5\u5668\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RmiInterface::getConnectorCode, (Object)connectorCode)).eq(HussarUtils.isNotEmpty((Object)appId), RmiInterface::getAppId, (Object)appId)).eq(RmiInterface::getRmiClassify, (Object)RmiClassifyEnum.NORMAL.getType())).orderByAsc(HussarBaseEntity::getCreateTime);
        if (HussarUtils.isNotEmpty((Object)query)) {
            wrapper.and(i -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)i.like(RmiInterface::getRmiName, (Object)query)).or()).like(RmiInterface::getRmiCode, (Object)query);
            });
        }
        return this.rmiInterfaceService.list((Wrapper)wrapper);
    }

    @Override
    public boolean updateStatus(RmiConnector rmiConnector) {
        String connectorCode = rmiConnector.getConnectorCode();
        HussarException.throwByNull((Object)connectorCode, (String)"API\u8fde\u63a5\u5668\u6807\u8bc6\u4e0d\u80fd\u4e3a\u7a7a");
        String status = rmiConnector.getConnectorStatus();
        Long appId = rmiConnector.getAppId();
        this.updateById((BaseEntity)rmiConnector);
        return this.rmiInterfaceService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new LambdaUpdateWrapper().set(RmiInterface::getRmiStatus, (Object)status)).eq(RmiInterface::getConnectorCode, (Object)connectorCode)).eq(HussarUtils.isNotEmpty((Object)appId), RmiInterface::getAppId, (Object)appId));
    }

    @Override
    public boolean resetAuthInfo(RmiConnector rmiConnector) {
        Long connectorId = rmiConnector.getConnectorId();
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)connectorId), (String)"API\u8fde\u63a5\u5668id\u4e0d\u80fd\u4e3a\u7a7a");
        return this.pubVarService.resetAuthTokenInfo(connectorId);
    }

    private boolean needAuth(String isAuth) {
        return "1".equals(isAuth);
    }

    public List<RmiConnector> getAllConnector() {
        String appId = WebUtil.getHeader((String)"appId");
        HussarException.throwByNull((Object)appId, (Integer)RmiExceptionEnum.APPID_EMPTY.getExceptionCode(), (String)RmiExceptionEnum.APPID_EMPTY.getMessage());
        RmiConnector connector = new RmiConnector();
        connector.setConnectorStatus(RmiStatusEnum.IN_USE.getValue());
        connector.setAppId(Long.valueOf(appId));
        return this.list((Wrapper)new QueryWrapper((Object)connector));
    }

    public RmiInterface getPushInterface(RmiConnector rmiConnector, Long rmiId) {
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)rmiConnector), (Integer)RmiExceptionEnum.CONNECTOR_EMPTY.getExceptionCode(), (String)RmiExceptionEnum.CONNECTOR_EMPTY.getMessage());
        HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)rmiId), (Integer)RmiExceptionEnum.RMI_INTERFACE_ID_EMPTY.getExceptionCode(), (String)RmiExceptionEnum.RMI_INTERFACE_ID_EMPTY.getMessage());
        String connectorCode = rmiConnector.getConnectorCode();
        Long appId = rmiConnector.getAppId();
        return (RmiInterface)this.rmiInterfaceService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RmiInterface::getRmiId, (Object)rmiId)).eq(RmiInterface::getConnectorCode, (Object)connectorCode)).eq(HussarUtils.isNotEmpty((Object)appId), RmiInterface::getAppId, (Object)appId));
    }
}

