/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.rmi.support.service.oauth;

import com.alibaba.fastjson.JSONObject;
import com.jxdinfo.hussar.platform.core.utils.ClassUtil;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.LocaleMessageUtils;
import com.jxdinfo.hussar.platform.core.utils.SpringContextUtil;
import com.jxdinfo.hussar.support.engine.plugin.pub.model.AuthTokenInfo;
import com.jxdinfo.hussar.support.engine.plugin.pub.service.PubVarService;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.HttpBodyEnum;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.ParamScope;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.RequestMethodType;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.RmiExceptionEnum;
import com.jxdinfo.hussar.support.engine.plugin.rmi.support.model.invocation.InvokeOAuthDto;
import com.jxdinfo.hussar.support.engine.plugin.rmi.support.model.oauth.AuthTokenInfoDto;
import com.jxdinfo.hussar.support.engine.plugin.rmi.support.model.oauth.OAuthParamDto;
import com.jxdinfo.hussar.support.engine.plugin.rmi.support.service.ObtainOAuthService;
import com.jxdinfo.hussar.support.engine.plugin.rmi.support.service.RmiOAuthInfoTestService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.rmi.api.entity.RmiConnector;
import com.jxdinfo.hussar.support.rmi.api.entity.RmiInterface;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RmiOAuthInfoTestServiceImpl
implements RmiOAuthInfoTestService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RmiOAuthInfoTestServiceImpl.class);
    @Autowired
    private PubVarService pubVarService;
    private final List<ObtainOAuthService> obtainOAuthServices;

    public RmiOAuthInfoTestServiceImpl(ObjectProvider<List<ObtainOAuthService>> obtainOAuthServices) {
        this.obtainOAuthServices = (List)obtainOAuthServices.getIfAvailable();
    }

    @Override
    public Object oAuthInfoTest(RmiConnector rmiConnector, RmiInterface rmiInterface, boolean saveOrNot) {
        AuthTokenInfoDto authTokenInfoDto;
        Method method;
        HussarException.throwByNull((Object)rmiInterface, (Integer)RmiExceptionEnum.AUTH_INFO_EMPTY.getExceptionCode(), (String)RmiExceptionEnum.AUTH_INFO_EMPTY.getMessage());
        HussarException.throwByNull((Object)rmiConnector, (Integer)RmiExceptionEnum.CONNECTOR_EMPTY.getExceptionCode(), (String)RmiExceptionEnum.CONNECTOR_EMPTY.getMessage());
        InvokeOAuthDto authInfo = this.dealAuthInfo(rmiInterface, rmiConnector);
        this.handleAuthParam(rmiConnector, authInfo, rmiInterface);
        HussarException.throwByNull((Object)authInfo.getGhClassName(), (Integer)RmiExceptionEnum.GET_TOKEN_CLASS_ERROR.getExceptionCode(), (String)RmiExceptionEnum.GET_TOKEN_CLASS_ERROR.getMessage());
        ObtainOAuthService getOAuthService = this.getObtainOAuthService(authInfo.getGhClassName());
        HussarException.throwByNull((Object)getOAuthService, (Integer)RmiExceptionEnum.GET_TOKEN_CLASS_ERROR.getExceptionCode(), (String)RmiExceptionEnum.GET_TOKEN_CLASS_ERROR.getMessage());
        try {
            method = ClassUtil.getMethod(getOAuthService.getClass(), (String)authInfo.getGhMethodName(), null);
        }
        catch (Exception e) {
            throw new HussarException(String.format(LocaleMessageUtils.getMessage((String)"ENGINE_METHOD_NOT_FOUND"), getOAuthService.getClass(), getOAuthService));
        }
        try {
            authTokenInfoDto = (AuthTokenInfoDto)((Object)method.invoke((Object)getOAuthService, authInfo));
        }
        catch (InvocationTargetException e) {
            throw new HussarException(e.getTargetException().getMessage(), e.getCause());
        }
        catch (Exception e) {
            throw new HussarException(e.getMessage(), e.getCause());
        }
        if (HussarUtils.isNull((Object)((Object)authTokenInfoDto))) {
            return null;
        }
        String responseContent = authTokenInfoDto.getResponseContent();
        if (saveOrNot) {
            authTokenInfoDto.setConnectorId(rmiConnector.getConnectorId());
            LOGGER.debug(LocaleMessageUtils.getMessage((String)"ENGINE_AUTH_SAVE_INFO"));
            this.pubVarService.setAuthTokenInfo((AuthTokenInfo)authTokenInfoDto);
            return responseContent;
        }
        return responseContent;
    }

    public InvokeOAuthDto dealAuthInfo(RmiInterface rmiAuthInterface, RmiConnector apiConnector) {
        InvokeOAuthDto callOAuth = new InvokeOAuthDto();
        callOAuth.setGhClassName(rmiAuthInterface.getRmiClass());
        callOAuth.setGhMethodName(rmiAuthInterface.getRmiMethod());
        callOAuth.setTokenUri(rmiAuthInterface.getRmiUri());
        callOAuth.setRequestMethodType(RequestMethodType.findByType(rmiAuthInterface.getRequestType()));
        if (apiConnector.getHostUrl().contains(":")) {
            String[] hostArray = apiConnector.getHostUrl().split(":");
            callOAuth.setTokenHost(hostArray[0]);
            callOAuth.setTokenport(hostArray[1]);
        } else {
            callOAuth.setTokenHost(apiConnector.getHostUrl());
        }
        String contentType = rmiAuthInterface.getContentType();
        if (HussarUtils.isNotEmpty((Object)contentType)) {
            HttpBodyEnum httpBodyEnum = HttpBodyEnum.findByType(contentType);
            HussarException.throwBy((boolean)HussarUtils.isEmpty((Object)((Object)httpBodyEnum)), (Integer)RmiExceptionEnum.CONNECT_TYPE_ERROR.getExceptionCode(), (String)RmiExceptionEnum.CONNECT_TYPE_ERROR.getMessage());
            callOAuth.setContentType(httpBodyEnum.getVal());
        }
        callOAuth.setTokenScheme(apiConnector.getProtocol());
        return callOAuth;
    }

    public ObtainOAuthService getObtainOAuthService(String oAuthServiceName) {
        ObtainOAuthService obtainOAuthService = null;
        try {
            for (ObtainOAuthService obtainItem : this.obtainOAuthServices) {
                if (!SpringContextUtil.getTarget((Object)obtainItem).getClass().getName().equals(oAuthServiceName)) continue;
                obtainOAuthService = obtainItem;
            }
        }
        catch (Exception e) {
            HussarException.throwBy((boolean)true, (Integer)RmiExceptionEnum.AUTH_CLASS_ERROR.getExceptionCode(), (String)RmiExceptionEnum.AUTH_CLASS_ERROR.getMessage());
        }
        return obtainOAuthService;
    }

    public void handleAuthParam(RmiConnector apiConnector, InvokeOAuthDto invokeOAuthDto, RmiInterface rmiInterface) {
        ArrayList<OAuthParamDto> oAuthParams = new ArrayList<OAuthParamDto>();
        String httpConfig = rmiInterface.getHttpConfig();
        if (HussarUtils.isEmpty((Object)httpConfig)) {
            return;
        }
        JSONObject httpObject = JSONObject.parseObject((String)httpConfig);
        Map querys = (Map)httpObject.getObject(ParamScope.QUERY.getScope(), Map.class);
        Map headers = (Map)httpObject.getObject(ParamScope.HEADER.getScope(), Map.class);
        Map bodys = (Map)httpObject.getObject(ParamScope.BODY.getScope(), Map.class);
        if (HussarUtils.isNotEmpty((Object)headers)) {
            oAuthParams.addAll(this.handleParams(apiConnector, headers, ParamScope.HEADER));
        }
        if (HussarUtils.isNotEmpty((Object)bodys)) {
            oAuthParams.addAll(this.handleParams(apiConnector, bodys, ParamScope.BODY));
        }
        if (HussarUtils.isNotEmpty((Object)querys)) {
            oAuthParams.addAll(this.handleParams(apiConnector, querys, ParamScope.QUERY));
        }
        invokeOAuthDto.setoAuthParamList(oAuthParams);
    }

    private List<OAuthParamDto> handleParams(RmiConnector apiConnector, Map<String, Object> httpConfigMap, ParamScope paramScope) {
        ArrayList<OAuthParamDto> oAuthParams = new ArrayList<OAuthParamDto>();
        httpConfigMap.keySet().forEach(key -> {
            OAuthParamDto oAuthParam = new OAuthParamDto();
            oAuthParam.setParamKey((String)key);
            oAuthParam.setParamScope(paramScope);
            oAuthParam.setParamValue(this.pubVarService.getPublicValue(apiConnector.getConnectorId(), httpConfigMap.get(key).toString()));
            oAuthParams.add(oAuthParam);
        });
        return oAuthParams;
    }
}

