/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.rmi.support.service.oauth;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.jxdinfo.hussar.platform.core.utils.HussarUtils;
import com.jxdinfo.hussar.platform.core.utils.LocaleMessageUtils;
import com.jxdinfo.hussar.platform.core.utils.date.LocalDateTimeUtil;
import com.jxdinfo.hussar.support.engine.plugin.pub.model.AuthTokenInfo;
import com.jxdinfo.hussar.support.engine.plugin.pub.service.PubVarService;
import com.jxdinfo.hussar.support.engine.plugin.rmi.connector.service.RmiConnectorService;
import com.jxdinfo.hussar.support.engine.plugin.rmi.connector.service.RmiInterfaceService;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.RmiClassifyEnum;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.RmiExceptionEnum;
import com.jxdinfo.hussar.support.engine.plugin.rmi.support.model.invocation.InvokeOAuthDto;
import com.jxdinfo.hussar.support.engine.plugin.rmi.support.model.oauth.AuthTokenInfoDto;
import com.jxdinfo.hussar.support.engine.plugin.rmi.support.service.ObtainOAuthService;
import com.jxdinfo.hussar.support.engine.plugin.rmi.support.service.RmiOAuthInfoService;
import com.jxdinfo.hussar.support.engine.plugin.rmi.support.service.oauth.RmiOAuthInfoTestServiceImpl;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.rmi.api.entity.RmiConnector;
import com.jxdinfo.hussar.support.rmi.api.entity.RmiInterface;
import com.jxdinfo.hussar.support.rmi.core.http.RmiApiRequest;
import java.time.LocalDateTime;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RmiOAuthInfoServiceImpl
implements RmiOAuthInfoService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RmiOAuthInfoServiceImpl.class);
    private static final int REFRESH_TOKEN_LAST_SECONDS = 300;
    @Autowired
    private RmiInterfaceService rmiInterfaceService;
    @Autowired
    private PubVarService pubVarService;
    @Autowired
    private RmiConnectorService rmiConnectorService;
    @Autowired
    private RmiOAuthInfoTestServiceImpl rmiOAuthInfoTestService;

    @Override
    public void handelCtxToken(RmiConnector apiConnector, RmiApiRequest request, String tokenKey) {
        AuthTokenInfo authTokenInfo = this.pubVarService.getAuthTokenInfo(apiConnector.getConnectorId());
        if (HussarUtils.isNotEmpty((Object)authTokenInfo.getAccessToken()) && HussarUtils.isNotEmpty((Object)authTokenInfo.getExpireTime())) {
            if (this.getTokenExpiresIn(authTokenInfo.getExpireTime()) > 300L) {
                LOGGER.debug(LocaleMessageUtils.getMessage((String)"ENGINE_TOKEN_NOT_EXPIRE"));
                return;
            }
            LOGGER.debug(LocaleMessageUtils.getMessage((String)"ENGINE_TIME_NOT_ENOUGH"), (Object)300);
            this.getToken(apiConnector, request, tokenKey);
            return;
        }
        this.getToken(apiConnector, request, tokenKey);
    }

    @Override
    public Object oAuthInfoTest(RmiInterface rmiInterface, boolean saveOrNot) {
        HussarException.throwByNull((Object)rmiInterface, (Integer)RmiExceptionEnum.AUTH_INFO_EMPTY.getExceptionCode(), (String)RmiExceptionEnum.AUTH_INFO_EMPTY.getMessage());
        String connectorCode = rmiInterface.getConnectorCode();
        Long appId = rmiInterface.getAppId();
        RmiConnector returnRmiConnector = (RmiConnector)this.rmiConnectorService.getOne((Wrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(RmiConnector::getConnectorCode, (Object)connectorCode)).eq(HussarUtils.isNotEmpty((Object)appId), RmiConnector::getAppId, (Object)appId));
        HussarException.throwByNull((Object)returnRmiConnector, (Integer)RmiExceptionEnum.CONNECTOR_EMPTY.getExceptionCode(), (String)RmiExceptionEnum.CONNECTOR_EMPTY.getMessage());
        return this.rmiOAuthInfoTestService.oAuthInfoTest(returnRmiConnector, rmiInterface, saveOrNot);
    }

    private AuthTokenInfo getToken(RmiConnector apiConnector, RmiApiRequest request, String tokenKey) {
        AuthTokenInfoDto tokenInfo;
        long startTime = System.currentTimeMillis();
        LOGGER.debug(LocaleMessageUtils.getMessage((String)"ENGINE_READY_GET_TOKEN"));
        List<RmiInterface> rmiInterfaces = this.rmiInterfaceService.getAuthInterfacesByConnectorCode(apiConnector);
        InvokeOAuthDto authInfo = this.handleAuthInfo(rmiInterfaces, apiConnector, RmiClassifyEnum.AUTH);
        InvokeOAuthDto refreshauthInfo = this.handleAuthInfo(rmiInterfaces, apiConnector, RmiClassifyEnum.REFRESH);
        if (!HussarUtils.isNull((Object)refreshauthInfo)) {
            HussarException.throwByNull((Object)refreshauthInfo.getGhClassName(), (Integer)RmiExceptionEnum.GET_TOKEN_CLASS_ERROR.getExceptionCode(), (String)RmiExceptionEnum.GET_TOKEN_CLASS_ERROR.getMessage());
            ObtainOAuthService refreshOAuthService = this.rmiOAuthInfoTestService.getObtainOAuthService(refreshauthInfo.getGhClassName());
            HussarException.throwByNull((Object)refreshOAuthService, (Integer)RmiExceptionEnum.GET_TOKEN_CLASS_ERROR.getExceptionCode(), (String)RmiExceptionEnum.GET_TOKEN_CLASS_ERROR.getMessage());
            tokenInfo = refreshOAuthService.requestRefreshToken(refreshauthInfo);
        } else {
            HussarException.throwByNull((Object)authInfo.getGhClassName(), (Integer)RmiExceptionEnum.GET_TOKEN_CLASS_ERROR.getExceptionCode(), (String)RmiExceptionEnum.GET_TOKEN_CLASS_ERROR.getMessage());
            ObtainOAuthService getOAuthService = this.rmiOAuthInfoTestService.getObtainOAuthService(authInfo.getGhClassName());
            HussarException.throwByNull((Object)getOAuthService, (Integer)RmiExceptionEnum.GET_TOKEN_CLASS_ERROR.getExceptionCode(), (String)RmiExceptionEnum.GET_TOKEN_CLASS_ERROR.getMessage());
            tokenInfo = getOAuthService.requestToken(authInfo);
        }
        tokenInfo.setConnectorId(apiConnector.getConnectorId());
        this.pubVarService.setAuthTokenInfo((AuthTokenInfo)tokenInfo);
        LOGGER.debug(LocaleMessageUtils.getMessage((String)"ENGINE_RE_GET_TOKEN"));
        if (request.getBody().containsKey((Object)tokenKey)) {
            request.getBody().setNameValue(tokenKey, (Object)tokenInfo.getAccessToken());
        } else if (request.getHeaders().containsKey((Object)tokenKey)) {
            request.addHeader(tokenKey, (Object)tokenInfo.getAccessToken());
        } else if (request.getQuery().containsKey((Object)tokenKey)) {
            request.replaceOrAddQuery(tokenKey, tokenInfo.getAccessToken());
        }
        LOGGER.debug(LocaleMessageUtils.getMessage((String)"ENGINE_REQUEST_TOKEN_SUCCESS"), (Object)(System.currentTimeMillis() - startTime));
        return tokenInfo;
    }

    private InvokeOAuthDto handleAuthInfo(List<RmiInterface> rmiInterfaces, RmiConnector apiConnector, RmiClassifyEnum rmiClassifyEnum) {
        HussarException.throwByNull(rmiInterfaces, (Integer)RmiExceptionEnum.AUTH_INFO_EMPTY.getExceptionCode(), (String)RmiExceptionEnum.AUTH_INFO_EMPTY.getMessage());
        InvokeOAuthDto callOAuth = null;
        if (HussarUtils.isNotEmpty(rmiInterfaces)) {
            for (RmiInterface rmiInterface : rmiInterfaces) {
                if (!rmiClassifyEnum.getType().equals(rmiInterface.getRmiClassify())) continue;
                callOAuth = this.rmiOAuthInfoTestService.dealAuthInfo(rmiInterface, apiConnector);
                this.rmiOAuthInfoTestService.handleAuthParam(apiConnector, callOAuth, rmiInterface);
                break;
            }
        }
        return callOAuth;
    }

    private long getTokenExpiresIn(LocalDateTime expireTime) {
        return LocalDateTimeUtil.between((LocalDateTime)LocalDateTime.now(), (LocalDateTime)expireTime).getSeconds();
    }
}

