/*
 * Decompiled with CFR 0.152.
 */
package com.jxdinfo.hussar.support.engine.plugin.rmi.support.service;

import com.jxdinfo.hussar.platform.core.utils.BeanUtil;
import com.jxdinfo.hussar.platform.core.utils.LocaleMessageUtils;
import com.jxdinfo.hussar.support.engine.plugin.pub.model.AuthTokenInfo;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.HttpBodyEnum;
import com.jxdinfo.hussar.support.engine.plugin.rmi.enums.RequestMethodType;
import com.jxdinfo.hussar.support.engine.plugin.rmi.support.mapper.OAuthClient;
import com.jxdinfo.hussar.support.engine.plugin.rmi.support.model.oauth.AuthTokenInfoDto;
import com.jxdinfo.hussar.support.engine.plugin.rmi.support.model.oauth.OAuthDto;
import com.jxdinfo.hussar.support.engine.plugin.rmi.support.model.oauth.oauth2.OAuthInfoDto;
import com.jxdinfo.hussar.support.engine.plugin.rmi.support.service.ObtainOAuthService;
import com.jxdinfo.hussar.support.exception.HussarException;
import com.jxdinfo.hussar.support.rmi.core.RmiApi;
import com.jxdinfo.hussar.support.rmi.core.http.RmiApiResponse;
import com.jxdinfo.hussar.support.rmi.core.utils.RmiApiDataType;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractOAuthService
implements ObtainOAuthService {
    private static final Logger logger = LoggerFactory.getLogger(AbstractOAuthService.class);

    public AuthTokenInfoDto handleOAuth(OAuthDto oAuthDto) {
        OAuthInfoDto oAuthInfo = (OAuthInfoDto)oAuthDto;
        String tokenUri = oAuthInfo.getTokenUri();
        long startTime = System.currentTimeMillis();
        logger.debug(LocaleMessageUtils.getMessage((String)"ENGINE_START_GET_TOKEN"), (Object)tokenUri);
        Map<String, Object> headerMap = oAuthInfo.getHeaderParams();
        Object body = "";
        Map<String, Object> queryMap = oAuthInfo.getQueryParams();
        body = HttpBodyEnum.JSON.getVal().equals(oAuthInfo.getContentType()) ? oAuthInfo.getBodyObjectParams() : oAuthInfo.getBodyParams();
        RmiApiResponse<String> response = null;
        OAuthClient oAuthClient = (OAuthClient)RmiApi.client(OAuthClient.class);
        if (RequestMethodType.GET.equals((Object)oAuthInfo.getRequestMethodType())) {
            response = oAuthClient.getToken(oAuthInfo.getTokenHost(), oAuthInfo.getTokenport(), oAuthInfo.getTokenScheme(), tokenUri, String.valueOf(oAuthInfo.getRetryCount()), String.valueOf(oAuthInfo.getRetryInterval()), queryMap, headerMap, (ex, req, res) -> HussarException.throwBy((boolean)true, (String)ex.getMessage()));
        } else if (RequestMethodType.POST.equals((Object)oAuthInfo.getRequestMethodType())) {
            response = oAuthClient.postToken(oAuthInfo.getTokenHost(), oAuthInfo.getTokenport(), oAuthInfo.getTokenScheme(), tokenUri, String.valueOf(oAuthInfo.getRetryCount()), String.valueOf(oAuthInfo.getRetryInterval()), oAuthInfo.getContentType(), body, headerMap, queryMap, (ex, req, res) -> HussarException.throwBy((boolean)true, (String)ex.getMessage()));
        }
        Map map = (Map)response.getRequest().getConfiguration().getConverter(RmiApiDataType.AUTO).convertToJavaObject((Object)response.getContent(), Map.class);
        AuthTokenInfoDto authTokenInfoDto = new AuthTokenInfoDto();
        AuthTokenInfo authTokenInfo = this.getTokenInfo(map);
        BeanUtil.copy((Object)authTokenInfo, (Object)((Object)authTokenInfoDto));
        authTokenInfoDto.setResponseContent(response.getContent());
        logger.debug(LocaleMessageUtils.getMessage((String)"ENGINE_GET_TOKEN_SUCCESS"), (Object)(System.currentTimeMillis() - startTime));
        return authTokenInfoDto;
    }

    @Override
    public AuthTokenInfoDto requestToken(OAuthDto oAuthDto) {
        return this.handleOAuth(oAuthDto);
    }

    @Override
    public AuthTokenInfoDto requestRefreshToken(OAuthDto oAuthDto) {
        return this.handleOAuth(oAuthDto);
    }

    protected abstract AuthTokenInfo getTokenInfo(Map var1);
}

